/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.MMapDataAccess;
import com.graphhopper.storage.RAMDataAccess;
import com.graphhopper.storage.RAMIntDataAccess;
import com.graphhopper.storage.UnsafeDataAccess;
import com.graphhopper.util.Helper;
import java.io.File;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GHDirectory
implements Directory {
    private final ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private final DAType defaultType;
    protected final String location;
    protected Map<String, DataAccess> map = new HashMap<String, DataAccess>();
    protected Map<String, DAType> types = new HashMap<String, DAType>();

    public GHDirectory(String object, DAType object2) {
        this.defaultType = object2;
        String string2 = object;
        if (Helper.isEmpty((String)object)) {
            string2 = new File("").getAbsolutePath();
        }
        object = string2;
        if (!string2.endsWith("/")) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("/");
            object = ((StringBuilder)object).toString();
        }
        this.location = object;
        if (((File)(object = new File((String)object))).exists() && !((File)object).isDirectory()) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("file '");
            ((StringBuilder)object2).append(object);
            ((StringBuilder)object2).append("' exists but is not a directory");
            throw new RuntimeException(((StringBuilder)object2).toString());
        }
        if (((DAType)object2).isInMemory()) {
            if (this.isStoring()) {
                this.put("location_index", DAType.RAM_INT_STORE);
                this.put("edges", DAType.RAM_INT_STORE);
                this.put("nodes", DAType.RAM_INT_STORE);
            } else {
                this.put("location_index", DAType.RAM_INT);
                this.put("edges", DAType.RAM_INT);
                this.put("nodes", DAType.RAM_INT);
            }
        }
    }

    @Override
    public void clear() {
        Iterator<DataAccess> iterator2 = this.map.values().iterator();
        MMapDataAccess mMapDataAccess = null;
        while (iterator2.hasNext()) {
            DataAccess dataAccess = iterator2.next();
            if (dataAccess instanceof MMapDataAccess) {
                mMapDataAccess = (MMapDataAccess)dataAccess;
            }
            this.removeDA(dataAccess, dataAccess.getName(), false);
        }
        if (mMapDataAccess != null) {
            Helper.cleanHack();
        }
        this.map.clear();
    }

    @Override
    public Directory create() {
        if (this.isStoring()) {
            new File(this.location).mkdirs();
        }
        return this;
    }

    @Override
    public DataAccess find(String string2) {
        DAType dAType;
        DAType dAType2 = dAType = this.types.get(string2);
        if (dAType == null) {
            dAType2 = this.defaultType;
        }
        return this.find(string2, dAType2);
    }

    @Override
    public DataAccess find(String string2, DAType object) {
        if (string2.equals(Helper.toLowerCase(string2))) {
            DataAccess dataAccess = this.map.get(string2);
            if (dataAccess != null) {
                if (((DAType)object).equals(dataAccess.getType())) {
                    return dataAccess;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Found existing DataAccess object '");
                stringBuilder.append(string2);
                stringBuilder.append("' but types did not match. Requested:");
                stringBuilder.append(object);
                stringBuilder.append(", was:");
                stringBuilder.append(dataAccess.getType());
                throw new IllegalStateException(stringBuilder.toString());
            }
            object = ((DAType)object).isInMemory() ? (((DAType)object).isInteg() ? (((DAType)object).isStoring() ? new RAMIntDataAccess(string2, this.location, true, this.byteOrder) : new RAMIntDataAccess(string2, this.location, false, this.byteOrder)) : (((DAType)object).isStoring() ? new RAMDataAccess(string2, this.location, true, this.byteOrder) : new RAMDataAccess(string2, this.location, false, this.byteOrder))) : (((DAType)object).isMMap() ? new MMapDataAccess(string2, this.location, this.byteOrder, ((DAType)object).isAllowWrites()) : new UnsafeDataAccess(string2, this.location, this.byteOrder));
            this.map.put(string2, (DataAccess)object);
            return object;
        }
        throw new IllegalArgumentException("Since 0.7 DataAccess objects does no longer accept upper case names");
    }

    @Override
    public Collection<DataAccess> getAll() {
        return this.map.values();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public DAType getDefaultType() {
        return this.defaultType;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public boolean isStoring() {
        return this.defaultType.isStoring();
    }

    public Directory put(String string2, DAType dAType) {
        if (string2.equals(Helper.toLowerCase(string2))) {
            this.types.put(string2, dAType);
            return this;
        }
        throw new IllegalArgumentException("Since 0.7 DataAccess objects does no longer accept upper case names");
    }

    @Override
    public void remove(DataAccess dataAccess) {
        this.removeFromMap(dataAccess.getName());
        this.removeDA(dataAccess, dataAccess.getName(), true);
    }

    void removeDA(DataAccess object, String string2, boolean bl) {
        if (object instanceof MMapDataAccess) {
            ((MMapDataAccess)object).close(bl);
        } else {
            object.close();
        }
        if (object.getType().isStoring()) {
            object = new StringBuilder();
            ((StringBuilder)object).append(this.location);
            ((StringBuilder)object).append(string2);
            Helper.removeDir(new File(((StringBuilder)object).toString()));
        }
    }

    void removeFromMap(String string2) {
        if (this.map.remove(string2) != null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Couldn't remove dataAccess object:");
        stringBuilder.append(string2);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public String toString() {
        return this.getLocation();
    }
}

