/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.MMapDirectory;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.TurnCostExtension;
import java.util.Arrays;

public class GraphBuilder {
    private long byteCapacity = 100L;
    private boolean elevation;
    private final EncodingManager encodingManager;
    private String location;
    private boolean mmap;
    private Weighting singleCHWeighting;
    private boolean store;

    public GraphBuilder(EncodingManager encodingManager) {
        this.encodingManager = encodingManager;
    }

    public GraphHopperStorage build() {
        Weighting weighting;
        Object object = this.mmap ? new MMapDirectory(this.location) : new RAMDirectory(this.location, this.store);
        object = !this.encodingManager.needsTurnCostsSupport() && (weighting = this.singleCHWeighting) != null ? new GraphHopperStorage(Arrays.asList(weighting), (Directory)object, this.encodingManager, this.elevation, new GraphExtension.NoOpExtension()) : new GraphHopperStorage((Directory)object, this.encodingManager, this.elevation, new TurnCostExtension());
        return object;
    }

    public CHGraph chGraphCreate(Weighting weighting) {
        return this.setCHGraph(weighting).create().getGraph(CHGraph.class, weighting);
    }

    public GraphHopperStorage create() {
        return this.build().create(this.byteCapacity);
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public GraphHopperStorage load() {
        Object object = this.build();
        if (((GraphHopperStorage)object).loadExisting()) {
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Cannot load graph ");
        ((StringBuilder)object).append(this.location);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public GraphBuilder set3D(boolean bl) {
        this.elevation = bl;
        return this;
    }

    public GraphBuilder setCHGraph(Weighting weighting) {
        this.singleCHWeighting = weighting;
        return this;
    }

    public GraphBuilder setExpectedSize(byte by) {
        this.byteCapacity = by;
        return this;
    }

    public GraphBuilder setLocation(String string2) {
        this.location = string2;
        return this;
    }

    public GraphBuilder setMmap(boolean bl) {
        this.mmap = bl;
        return this;
    }

    public GraphBuilder setStore(boolean bl) {
        this.store = bl;
        return this;
    }
}

