/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Circle;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Polygon;
import com.graphhopper.util.shapes.Shape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphEdgeIdFinder {
    private final Graph graph;
    private final LocationIndex locationIndex;

    public GraphEdgeIdFinder(Graph graph, LocationIndex locationIndex) {
        this.graph = graph;
        this.locationIndex = locationIndex;
    }

    /*
     * WARNING - void declaration
     */
    public void fillEdgeIDs(GHIntHashSet gHIntHashSet, Geometry object2, EdgeFilter edgeFilter) {
        void var3_6;
        if (object2 instanceof Point) {
            this.findClosestEdgeToPoint(gHIntHashSet, GHPoint.create((Point)object2), (EdgeFilter)var3_6);
        } else if (object2 instanceof LineString) {
            PointList pointList = PointList.fromLineString((LineString)object2);
            int n = pointList.size() - 1;
            if (pointList.size() >= 2) {
                this.findClosestEdge(gHIntHashSet, (pointList.getLatitude(0) + pointList.getLatitude(n)) / 2.0, (pointList.getLongitude(0) + pointList.getLongitude(n)) / 2.0, (EdgeFilter)var3_6);
            }
        } else if (object2 instanceof MultiPoint) {
            for (Coordinate coordinate : ((Geometry)object2).getCoordinates()) {
                this.findClosestEdge(gHIntHashSet, coordinate.y, coordinate.x, (EdgeFilter)var3_6);
            }
        }
    }

    public void findClosestEdge(GHIntHashSet gHIntHashSet, double d, double d2, EdgeFilter object) {
        if (((QueryResult)(object = this.locationIndex.findClosest(d, d2, (EdgeFilter)object))).isValid()) {
            gHIntHashSet.add(((QueryResult)object).getClosestEdge().getEdge());
        }
    }

    public void findClosestEdgeToPoint(GHIntHashSet gHIntHashSet, GHPoint gHPoint, EdgeFilter edgeFilter) {
        this.findClosestEdge(gHIntHashSet, gHPoint.getLat(), gHPoint.getLon(), edgeFilter);
    }

    public void findEdgesInShape(GHIntHashSet object, final Shape shape, EdgeFilter edgeFilter) {
        Object object2 = shape.getCenter();
        if (((QueryResult)(object2 = this.locationIndex.findClosest(((GHPoint)object2).getLat(), ((GHPoint)object2).getLon(), edgeFilter))).isValid()) {
            if (shape.contains(((QueryResult)object2).getSnappedPoint().lat, ((QueryResult)object2).getSnappedPoint().lon)) {
                object.add(((QueryResult)object2).getClosestEdge().getEdge());
            }
            new BreadthFirstSearch(shape instanceof Polygon, (GHIntHashSet)((Object)object)){
                final Shape localShape;
                final NodeAccess na;
                final /* synthetic */ GHIntHashSet val$edgeIds;
                final /* synthetic */ boolean val$isPolygon;
                {
                    this.val$isPolygon = bl;
                    this.val$edgeIds = gHIntHashSet;
                    this.na = GraphEdgeIdFinder.this.graph.getNodeAccess();
                    this.localShape = shape2;
                }

                private boolean isInsideBBox(int n) {
                    BBox bBox = this.localShape.getBounds();
                    double d = this.na.getLatitude(n);
                    double d2 = this.na.getLongitude(n);
                    boolean bl = d <= bBox.maxLat && d >= bBox.minLat && d2 <= bBox.maxLon && d2 >= bBox.minLon;
                    return bl;
                }

                @Override
                protected boolean checkAdjacent(EdgeIteratorState edgeIteratorState) {
                    int n = edgeIteratorState.getAdjNode();
                    boolean bl = this.localShape.contains(this.na.getLatitude(n), this.na.getLongitude(n));
                    boolean bl2 = true;
                    if (bl) {
                        this.val$edgeIds.add(edgeIteratorState.getEdge());
                        return true;
                    }
                    if (!this.val$isPolygon || !this.isInsideBBox(n)) {
                        bl2 = false;
                    }
                    return bl2;
                }

                @Override
                protected boolean goFurther(int n) {
                    if (this.val$isPolygon) {
                        return this.isInsideBBox(n);
                    }
                    return this.localShape.contains(this.na.getLatitude(n), this.na.getLongitude(n));
                }
            }.start(this.graph.createEdgeExplorer(edgeFilter), ((QueryResult)object2).getClosestNode());
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Shape ");
        ((StringBuilder)object).append(shape);
        ((StringBuilder)object).append(" does not cover graph");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public BlockArea parseBlockArea(String object, EdgeFilter edgeFilter, double d) {
        BlockArea blockArea = new BlockArea(this.graph);
        if (!((String)object).isEmpty()) {
            object = ((String)object).split(";");
            for (int i = 0; i < ((String[])object).length; ++i) {
                Object object2 = object[i];
                String[] stringArray = ((String)object2).split(",");
                if (stringArray.length > 4) {
                    object2 = Polygon.parsePoints((String)object2, 0.003);
                    this.findEdgesInShape(blockArea.blockedEdges, (Shape)object2, edgeFilter);
                    continue;
                }
                if (stringArray.length == 4) {
                    if (((BBox)(object2 = BBox.parseTwoPoints((String)object2))).calculateArea() > d) {
                        blockArea.add((Shape)object2);
                        continue;
                    }
                    this.findEdgesInShape(blockArea.blockedEdges, (Shape)object2, edgeFilter);
                    continue;
                }
                if (stringArray.length == 3) {
                    object2 = new Circle(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Integer.parseInt(stringArray[2]));
                    if (((Circle)object2).calculateArea() > d) {
                        blockArea.add((Shape)object2);
                        continue;
                    }
                    this.findEdgesInShape(blockArea.blockedEdges, (Shape)object2, edgeFilter);
                    continue;
                }
                if (stringArray.length == 2) {
                    double d2 = Double.parseDouble(stringArray[0]);
                    double d3 = Double.parseDouble(stringArray[1]);
                    this.findClosestEdge(blockArea.blockedEdges, d2, d3, edgeFilter);
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" at index ");
                ((StringBuilder)object).append(i);
                ((StringBuilder)object).append(" need to be defined as lat,lon or as a circle lat,lon,radius or rectangular lat1,lon1,lat2,lon2");
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
        }
        return blockArea;
    }

    public static class BlockArea {
        final GHIntHashSet blockedEdges = new GHIntHashSet();
        final List<Shape> blockedShapes = new ArrayList<Shape>();
        private final NodeAccess na;

        public BlockArea(Graph graph) {
            this.na = graph.getNodeAccess();
        }

        public void add(int n) {
            this.blockedEdges.addAll(new int[]{n});
        }

        public void add(Shape shape) {
            this.blockedShapes.add(shape);
        }

        public final boolean contains(EdgeIteratorState edgeIteratorState) {
            if (!this.blockedEdges.isEmpty() && this.blockedEdges.contains(edgeIteratorState.getEdge())) {
                return true;
            }
            if (!this.blockedShapes.isEmpty() && this.na != null) {
                Iterator<Shape> iterator2 = this.blockedShapes.iterator();
                while (iterator2.hasNext()) {
                    if (!iterator2.next().contains(this.na.getLatitude(edgeIteratorState.getAdjNode()), this.na.getLongitude(edgeIteratorState.getAdjNode()))) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

