/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractDataAccess;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.Constants;
import com.graphhopper.util.Helper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MMapDataAccess
extends AbstractDataAccess {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(MMapDataAccess.class);
    private final boolean allowWrites;
    private RandomAccessFile raFile;
    private List<ByteBuffer> segments = new ArrayList<ByteBuffer>();

    MMapDataAccess(String string2, String string3, ByteOrder byteOrder, boolean bl) {
        super(string2, string3, byteOrder);
        this.allowWrites = bl;
    }

    private static void callBufferFree(ByteBuffer comparable, Class<?> genericDeclaration) throws InvocationTargetException, IllegalAccessException {
        try {
            genericDeclaration = ((Class)genericDeclaration).getMethod("free", new Class[0]);
            ((Method)genericDeclaration).setAccessible(true);
            ((Method)genericDeclaration).invoke(comparable, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger logger = LOGGER;
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("NoSuchMethodException | ");
            ((StringBuilder)comparable).append(System.getProperty("java.version"));
            logger.warn(((StringBuilder)comparable).toString(), (Throwable)noSuchMethodException);
        }
    }

    private void clean(int n, int n2) {
        while (n < n2) {
            MMapDataAccess.cleanMappedByteBuffer(this.segments.get(n));
            this.segments.set(n, null);
            ++n;
        }
    }

    public static void cleanMappedByteBuffer(final ByteBuffer byteBuffer) {
        try {
            PrivilegedExceptionAction<Object> privilegedExceptionAction = new PrivilegedExceptionAction<Object>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Object run() throws Exception {
                    if (MMapDataAccess.jreIsMinimumJava9()) {
                        GenericDeclaration genericDeclaration = Class.forName("sun.misc.Unsafe");
                        Object object = ((Class)genericDeclaration).getDeclaredField("theUnsafe");
                        ((Field)object).setAccessible(true);
                        object = ((Field)object).get(null);
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("invokeCleaner", ByteBuffer.class);
                        try {
                            ((Method)genericDeclaration).invoke(object, byteBuffer);
                            return null;
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException(throwable);
                        }
                    }
                    if (byteBuffer.getClass().getSimpleName().equals("MappedByteBufferAdapter")) {
                        if (!Constants.ANDROID) throw new RuntimeException("MappedByteBufferAdapter only supported for Android at the moment");
                        Class<?> clazz = Class.forName("java.nio.MappedByteBufferAdapter");
                        MMapDataAccess.callBufferFree(byteBuffer, clazz);
                        return null;
                    }
                    Serializable serializable = Class.forName("java.nio.DirectByteBuffer");
                    Method method = ((Class)serializable).getMethod("cleaner", new Class[0]);
                    method.setAccessible(true);
                    Object object = method.invoke((Object)byteBuffer, new Object[0]);
                    if (object == null) return null;
                    try {
                        method = method.getReturnType().getDeclaredMethod("clean", new Class[0]);
                        method.setAccessible(true);
                        method.invoke(object, new Object[0]);
                        return null;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (Constants.ANDROID) {
                            MMapDataAccess.callBufferFree(byteBuffer, serializable);
                            return null;
                        }
                        method = LOGGER;
                        serializable = new StringBuilder();
                        ((StringBuilder)serializable).append("NoSuchMethodException | ");
                        ((StringBuilder)serializable).append(System.getProperty("java.version"));
                        method.warn(((StringBuilder)serializable).toString(), noSuchMethodException);
                    }
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedExceptionAction);
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException("Unable to unmap the mapped buffer", privilegedActionException);
        }
    }

    private void initRandomAccessFile() {
        RandomAccessFile randomAccessFile;
        String string2;
        String string3;
        if (this.raFile != null) {
            return;
        }
        try {
            string3 = this.getFullName();
            string2 = this.allowWrites ? "rw" : "r";
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.raFile = randomAccessFile = new RandomAccessFile(string3, string2);
    }

    public static boolean jreIsMinimumJava9() {
        boolean bl;
        block3: {
            block2: {
                StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.specification.version"), ".");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                bl = stringTokenizer.hasMoreTokens();
                boolean bl2 = false;
                int n2 = bl ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                if (n > 1) break block2;
                bl = bl2;
                if (n != 1) break block3;
                bl = bl2;
                if (n2 < 9) break block3;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean mapIt(long l, long l2) {
        void var18_14;
        long l5;
        int n5;
        long l4;
        int n;
        long l3;
        block13: {
            long l6;
            if (l2 < 0L) {
                throw new IllegalArgumentException("new capacity has to be strictly positive");
            }
            l3 = this.getCapacity();
            n = 0;
            int n2 = 0;
            int n3 = 0;
            if (l2 <= l3) {
                return false;
            }
            l4 = this.segmentSizeInBytes;
            int n4 = (int)(l2 / l4);
            if (n4 < 0) {
                throw new IllegalStateException("Too many segments needs to be allocated. Increase segmentSize.");
            }
            n5 = n4;
            if (l2 % l4 != 0L) {
                n5 = n4 + 1;
            }
            if (n5 == 0) {
                throw new IllegalStateException("0 segments are not allowed.");
            }
            l5 = n5;
            try {
                n4 = this.segments.size();
            }
            catch (IOException iOException) {
                l3 = l;
                n = n2;
                break block13;
            }
            l3 = l6 = (long)n4 * l4 + l;
            try {
                n2 = this.segments.size();
            }
            catch (IOException iOException) {}
            while (true) {
                if (n3 >= n5 - n2) {
                    return true;
                }
                n = n3++;
                l3 = l6;
                this.segments.add(this.newByteBuffer(l6, l4));
                l6 += l4;
                continue;
                break;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Couldn't map buffer ");
        stringBuilder.append(n);
        stringBuilder.append(" of ");
        stringBuilder.append(n5);
        stringBuilder.append(" for ");
        stringBuilder.append(this.name);
        stringBuilder.append(" at position ");
        stringBuilder.append(l3);
        stringBuilder.append(" for ");
        stringBuilder.append(l2);
        stringBuilder.append(" bytes with offset ");
        stringBuilder.append(l);
        stringBuilder.append(", new fileLength:");
        stringBuilder.append(l5 * l4 + l);
        throw new RuntimeException(stringBuilder.toString(), (Throwable)var18_14);
    }

    private ByteBuffer newByteBuffer(long l, long l2) throws IOException {
        Object object;
        ByteBuffer byteBuffer = null;
        int n = 0;
        Object var7_5 = null;
        while (true) {
            object = byteBuffer;
            if (n >= true) break;
            try {
                FileChannel fileChannel = this.raFile.getChannel();
                object = this.allowWrites ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY;
                object = fileChannel.map((FileChannel.MapMode)object, l, l2);
                break;
            }
            catch (IOException iOException) {
                ++n;
                Helper.cleanHack();
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
        }
        if (object == null) {
            if (var7_5 == null) {
                throw new AssertionError((Object)"internal problem as the exception 'ioex' shouldn't be null");
            }
            throw var7_5;
        }
        ((ByteBuffer)object).order(this.byteOrder);
        return object;
    }

    @Override
    public void close() {
        super.close();
        this.close(true);
    }

    void close(boolean bl) {
        this.clean(0, this.segments.size());
        this.segments.clear();
        Helper.close(this.raFile);
        if (bl) {
            Helper.cleanHack();
        }
    }

    @Override
    public DataAccess copyTo(DataAccess dataAccess) {
        return super.copyTo(dataAccess);
    }

    @Override
    public MMapDataAccess create(long l) {
        if (this.segments.isEmpty()) {
            this.initRandomAccessFile();
            l = Math.max(40L, l);
            this.setSegmentSize(this.segmentSizeInBytes);
            this.ensureCapacity(l);
            return this;
        }
        throw new IllegalThreadStateException("already created");
    }

    @Override
    public boolean ensureCapacity(long l) {
        return this.mapIt(100L, l);
    }

    @Override
    public void flush() {
        if (!this.isClosed()) {
            try {
                Object object;
                if (!this.segments.isEmpty() && this.segments.get(0) instanceof MappedByteBuffer) {
                    object = this.segments.iterator();
                    while (object.hasNext()) {
                        ((MappedByteBuffer)((ByteBuffer)object.next())).force();
                    }
                }
                object = this.raFile;
                this.writeHeader((RandomAccessFile)object, ((RandomAccessFile)object).length(), this.segmentSizeInBytes);
                this.raFile.getFD().sync();
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        throw new IllegalStateException("already closed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getBytes(long l, byte[] byArray, int n) {
        int n2 = (int)(l >>> this.segmentSizePower);
        int n3 = (int)(l & (long)this.indexDivisor);
        int n4 = n3 + n - this.segmentSizeInBytes;
        ByteBuffer byteBuffer = this.segments.get(n2);
        synchronized (byteBuffer) {
            byteBuffer.position(n3);
            if (n4 > 0) {
                byteBuffer.get(byArray, 0, n -= n4);
            } else {
                byteBuffer.get(byArray, 0, n);
            }
        }
        if (n4 <= 0) return;
        byteBuffer = this.segments.get(n2 + 1);
        synchronized (byteBuffer) {
            byteBuffer.position(0);
            byteBuffer.get(byArray, n, n4);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getCapacity() {
        Iterator<ByteBuffer> iterator2 = this.segments.iterator();
        long l = 0L;
        while (iterator2.hasNext()) {
            ByteBuffer byteBuffer = iterator2.next();
            synchronized (byteBuffer) {
                l += (long)byteBuffer.capacity();
            }
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int getInt(long l) {
        int n = (int)(l >> this.segmentSizePower);
        int n2 = (int)(l & (long)this.indexDivisor);
        ByteBuffer byteBuffer = this.segments.get(n);
        synchronized (byteBuffer) {
            return byteBuffer.getInt(n2);
        }
    }

    @Override
    public int getSegments() {
        return this.segments.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final short getShort(long l) {
        int n = (int)(l >>> this.segmentSizePower);
        int n2 = (int)(l & (long)this.indexDivisor);
        ByteBuffer byteBuffer = this.segments.get(n);
        synchronized (byteBuffer) {
            return byteBuffer.getShort(n2);
        }
    }

    @Override
    public DAType getType() {
        return DAType.MMAP;
    }

    @Override
    public boolean loadExisting() {
        if (this.segments.size() <= 0) {
            if (!this.isClosed()) {
                File file = new File(this.getFullName());
                if (file.exists() && file.length() != 0L) {
                    long l;
                    block6: {
                        this.initRandomAccessFile();
                        try {
                            l = this.readHeader(this.raFile);
                            if (l >= 0L) break block6;
                            return false;
                        }
                        catch (IOException iOException) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Problem while loading ");
                            stringBuilder.append(this.getFullName());
                            throw new RuntimeException(stringBuilder.toString(), iOException);
                        }
                    }
                    this.mapIt(100L, l - 100L);
                    return true;
                }
                return false;
            }
            throw new IllegalStateException("already closed");
        }
        throw new IllegalStateException("already initialized");
    }

    @Override
    public void rename(String string2) {
        if (!this.checkBeforeRename(string2)) {
            return;
        }
        this.close();
        super.rename(string2);
        this.raFile = null;
        this.closed = false;
        this.loadExisting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setBytes(long l, byte[] byArray, int n) {
        int n2 = (int)(l >>> this.segmentSizePower);
        int n3 = (int)(l & (long)this.indexDivisor);
        int n4 = n3 + n - this.segmentSizeInBytes;
        ByteBuffer byteBuffer = this.segments.get(n2);
        synchronized (byteBuffer) {
            byteBuffer.position(n3);
            if (n4 > 0) {
                byteBuffer.put(byArray, 0, n -= n4);
            } else {
                byteBuffer.put(byArray, 0, n);
            }
        }
        if (n4 <= 0) return;
        byteBuffer = this.segments.get(n2 + 1);
        synchronized (byteBuffer) {
            byteBuffer.position(0);
            byteBuffer.put(byArray, n, n4);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void setInt(long l, int n) {
        int n2 = (int)(l >> this.segmentSizePower);
        int n3 = (int)(l & (long)this.indexDivisor);
        ByteBuffer byteBuffer = this.segments.get(n2);
        synchronized (byteBuffer) {
            byteBuffer.putInt(n3, n);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void setShort(long l, short s) {
        int n = (int)(l >>> this.segmentSizePower);
        int n2 = (int)(l & (long)this.indexDivisor);
        ByteBuffer byteBuffer = this.segments.get(n);
        synchronized (byteBuffer) {
            byteBuffer.putShort(n2, s);
            return;
        }
    }

    @Override
    public void trimTo(long l) {
        int n;
        long l2 = l;
        if (l < (long)this.segmentSizeInBytes) {
            l2 = this.segmentSizeInBytes;
        }
        int n2 = n = (int)(l2 / (long)this.segmentSizeInBytes);
        if (l2 % (long)this.segmentSizeInBytes != 0L) {
            n2 = n + 1;
        }
        this.clean(n2, this.segments.size());
        Helper.cleanHack();
        this.segments = new ArrayList<ByteBuffer>(this.segments.subList(0, n2));
        try {
            if (!Constants.WINDOWS) {
                this.raFile.setLength(n2 * this.segmentSizeInBytes + 100);
            }
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

