/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.util.Helper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class NativeFSLockFactory
implements LockFactory {
    private File lockDir;

    public NativeFSLockFactory() {
    }

    public NativeFSLockFactory(File file) {
        this.lockDir = file;
    }

    public static void main(String[] object) throws IOException {
        object = new File("tmp.lock");
        ((File)object).createNewFile();
        object = new RandomAccessFile((File)object, "r").getChannel().tryLock(0L, Long.MAX_VALUE, true);
        PrintStream printStream = System.out;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("locked ");
        stringBuilder.append(object);
        printStream.println(stringBuilder.toString());
        System.in.read();
        printStream = System.out;
        stringBuilder = new StringBuilder();
        stringBuilder.append("release ");
        stringBuilder.append(object);
        printStream.println(stringBuilder.toString());
        ((FileLock)object).release();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GHLock create(String object, boolean bl) {
        synchronized (this) {
            Comparable<File> comparable = this.lockDir;
            if (comparable != null) return new NativeLock((File)comparable, (String)object, bl);
            comparable = new Comparable<File>();
            ((StringBuilder)comparable).append("Set lockDir before creating ");
            object = bl ? "write" : "read";
            ((StringBuilder)comparable).append((String)object);
            ((StringBuilder)comparable).append(" locks");
            RuntimeException runtimeException = new RuntimeException(((StringBuilder)comparable).toString());
            throw runtimeException;
        }
    }

    @Override
    public void forceRemove(String object, boolean bl) {
        synchronized (this) {
            if (this.lockDir.exists()) {
                this.create((String)object, bl).release();
                File file = new File(this.lockDir, (String)object);
                if (file.exists() && !file.delete()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Cannot delete ");
                    stringBuilder.append(file);
                    object = new RuntimeException(stringBuilder.toString());
                    throw object;
                }
            }
            return;
        }
    }

    @Override
    public void setLockDir(File file) {
        this.lockDir = file;
    }

    static class NativeLock
    implements GHLock {
        private Exception failedReason;
        private final File lockDir;
        private final File lockFile;
        private final String name;
        private FileChannel tmpChannel;
        private FileLock tmpLock;
        private RandomAccessFile tmpRaFile;
        private final boolean writeLock;

        public NativeLock(File file, String string2, boolean bl) {
            this.name = string2;
            this.lockDir = file;
            this.lockFile = new File(file, string2);
            this.writeLock = bl;
        }

        private boolean lockExists() {
            synchronized (this) {
                FileLock fileLock = this.tmpLock;
                boolean bl = fileLock != null;
                return bl;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Exception getObtainFailedReason() {
            return this.failedReason;
        }

        @Override
        public boolean isLocked() {
            synchronized (this) {
                boolean bl;
                block10: {
                    block9: {
                        bl = this.lockFile.exists();
                        if (bl) break block9;
                        return false;
                    }
                    bl = this.lockExists();
                    if (!bl) break block10;
                    return true;
                }
                try {
                    bl = this.tryLock();
                    if (bl) {
                        this.release();
                    }
                    return bl ^ true;
                }
                catch (Exception exception) {
                    return false;
                }
                finally {
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void release() {
            synchronized (this) {
                block46: {
                    Throwable throwable8222222;
                    Throwable throwable22222222;
                    block47: {
                        Throwable throwable32222222;
                        Throwable throwable42222222;
                        block44: {
                            Throwable throwable52222222;
                            Throwable throwable62222222;
                            block45: {
                                Throwable throwable72222222;
                                boolean bl = this.lockExists();
                                if (!bl) return;
                                this.failedReason = null;
                                this.tmpLock.release();
                                this.tmpLock = null;
                                {
                                    catch (Throwable throwable42222222) {
                                        break block44;
                                    }
                                    catch (Exception exception) {}
                                    {
                                        RuntimeException runtimeException = new RuntimeException(exception);
                                        throw runtimeException;
                                    }
                                }
                                this.tmpChannel.close();
                                this.tmpChannel = null;
                                {
                                    catch (Throwable throwable62222222) {
                                        break block45;
                                    }
                                    catch (Exception exception) {}
                                    {
                                        RuntimeException runtimeException = new RuntimeException(exception);
                                        throw runtimeException;
                                    }
                                }
                                this.tmpRaFile.close();
                                this.tmpRaFile = null;
                                this.lockFile.delete();
                                break block46;
                                {
                                    catch (Throwable throwable72222222) {
                                    }
                                    catch (Exception exception) {}
                                    {
                                        RuntimeException runtimeException = new RuntimeException(exception);
                                        throw runtimeException;
                                    }
                                }
                                this.tmpRaFile = null;
                                throw throwable72222222;
                            }
                            this.tmpChannel = null;
                            this.tmpRaFile.close();
                            this.tmpRaFile = null;
                            throw throwable62222222;
                            {
                                catch (Throwable throwable52222222) {
                                }
                                catch (Exception exception) {}
                                {
                                    RuntimeException runtimeException = new RuntimeException(exception);
                                    throw runtimeException;
                                }
                            }
                            this.tmpRaFile = null;
                            throw throwable52222222;
                        }
                        this.tmpLock = null;
                        this.tmpChannel.close();
                        this.tmpChannel = null;
                        {
                            catch (Throwable throwable22222222) {
                                break block47;
                            }
                            catch (Exception exception) {}
                            {
                                RuntimeException runtimeException = new RuntimeException(exception);
                                throw runtimeException;
                            }
                        }
                        this.tmpRaFile.close();
                        this.tmpRaFile = null;
                        throw throwable42222222;
                        {
                            catch (Throwable throwable32222222) {
                            }
                            catch (Exception exception) {}
                            {
                                RuntimeException runtimeException = new RuntimeException(exception);
                                throw runtimeException;
                            }
                        }
                        this.tmpRaFile = null;
                        throw throwable32222222;
                    }
                    this.tmpChannel = null;
                    this.tmpRaFile.close();
                    this.tmpRaFile = null;
                    throw throwable22222222;
                    {
                        catch (Throwable throwable8222222) {
                        }
                        catch (Exception exception) {}
                        {
                            RuntimeException runtimeException = new RuntimeException(exception);
                            throw runtimeException;
                        }
                    }
                    this.tmpRaFile = null;
                    throw throwable8222222;
                }
                return;
            }
        }

        public String toString() {
            return this.lockFile.toString();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean tryLock() {
            synchronized (this) {
                var1_1 = this.lockExists();
                if (var1_1) {
                    return false;
                }
                if (!this.lockDir.exists() && !this.lockDir.mkdirs()) {
                    var3_9 = new StringBuilder();
                    var3_9.append("Directory ");
                    var3_9.append(this.lockDir);
                    var3_9.append(" does not exist and cannot be created to place lock file there: ");
                    var3_9.append(this.lockFile);
                    var2_2 = new RuntimeException(var3_9.toString());
                    throw var2_2;
                }
                var1_1 = this.lockDir.isDirectory();
                if (!var1_1) {
                    var3_10 = new StringBuilder();
                    var3_10.append("lockDir has to be a directory: ");
                    var3_10.append(this.lockDir);
                    var2_8 = new IllegalArgumentException(var3_10.toString());
                    throw var2_8;
                }
                this.failedReason = null;
                this.tmpRaFile = var2_3 /* !! */  = new RandomAccessFile(this.lockFile, "rw");
                {
                    catch (IOException var2_7) {
                        this.failedReason = var2_7;
                        return false;
                    }
                }
                var2_3 /* !! */  = var2_3 /* !! */ .getChannel();
                this.tmpChannel = var2_3 /* !! */ ;
                var1_1 = this.writeLock == false;
                var2_3 /* !! */  = var2_3 /* !! */ .tryLock(0L, 0x7FFFFFFFFFFFFFFFL, var1_1);
                this.tmpLock = var2_3 /* !! */ ;
                if (var2_3 /* !! */  != null) return this.lockExists();
                try {
                    Helper.close(this.tmpChannel);
lbl43:
                    // 2 sources

                    while (true) {
                        this.tmpChannel = null;
                        return this.lockExists();
                    }
                }
                finally {
                    if (this.tmpChannel == null) {
                        Helper.close(this.tmpRaFile);
                        this.tmpRaFile = null;
                    }
                }
                {
                    block22: {
                        catch (Throwable var2_4) {
                            break block22;
                        }
                        catch (Exception var2_5) {}
                        {
                            this.failedReason = var2_5;
                        }
                        if (this.tmpLock != null) return this.lockExists();
                        Helper.close(this.tmpChannel);
                        ** continue;
                    }
                    if (this.tmpLock != null) throw var2_4;
                    Helper.close(this.tmpChannel);
                    this.tmpChannel = null;
                    throw var2_4;
                }
            }
        }
    }
}

