/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractDataAccess;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.Arrays;

class RAMIntDataAccess
extends AbstractDataAccess {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private boolean closed = false;
    private transient int segmentSizeIntsPower;
    private int[][] segments = new int[0][];
    private boolean store;

    RAMIntDataAccess(String string2, String string3, boolean bl, ByteOrder byteOrder) {
        super(string2, string3, byteOrder);
        this.store = bl;
    }

    @Override
    public void close() {
        super.close();
        this.segments = new int[0][];
        this.closed = true;
    }

    @Override
    public DataAccess copyTo(DataAccess dataAccess) {
        if (dataAccess instanceof RAMIntDataAccess) {
            Object object;
            this.copyHeader(dataAccess);
            RAMIntDataAccess rAMIntDataAccess = (RAMIntDataAccess)dataAccess;
            rAMIntDataAccess.segments = new int[this.segments.length][];
            for (int i = 0; i < ((int[][])(object = this.segments)).length; ++i) {
                object = object[i];
                rAMIntDataAccess.segments[i] = Arrays.copyOf((int[])object, ((int[][])object).length);
            }
            rAMIntDataAccess.setSegmentSize(this.segmentSizeInBytes);
            return dataAccess;
        }
        return super.copyTo(dataAccess);
    }

    @Override
    public RAMIntDataAccess create(long l) {
        if (this.segments.length <= 0) {
            this.setSegmentSize(this.segmentSizeInBytes);
            this.ensureCapacity(Math.max(40L, l));
            return this;
        }
        throw new IllegalThreadStateException("already created");
    }

    @Override
    public boolean ensureCapacity(long l) {
        if (l >= 0L) {
            int[][] nArray;
            int n;
            long l2 = this.getCapacity();
            if ((l -= l2) <= 0L) {
                return false;
            }
            int n2 = n = (int)(l / (long)this.segmentSizeInBytes);
            if (l % (long)this.segmentSizeInBytes != 0L) {
                n2 = n + 1;
            }
            try {
                nArray = this.segments;
                nArray = (int[][])Arrays.copyOf(nArray, nArray.length + n2);
                for (n = this.segments.length; n < nArray.length; ++n) {
                    nArray[n] = new int[1 << this.segmentSizeIntsPower];
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(outOfMemoryError.getMessage());
                stringBuilder.append(" - problem when allocating new memory. Old capacity: ");
                stringBuilder.append(l2);
                stringBuilder.append(", new bytes:");
                stringBuilder.append(l);
                stringBuilder.append(", segmentSizeIntsPower:");
                stringBuilder.append(this.segmentSizeIntsPower);
                stringBuilder.append(", new segments:");
                stringBuilder.append(n2);
                stringBuilder.append(", existing:");
                stringBuilder.append(this.segments.length);
                throw new OutOfMemoryError(stringBuilder.toString());
            }
            this.segments = nArray;
            return true;
        }
        throw new IllegalArgumentException("new capacity has to be strictly positive");
    }

    /*
     * Loose catch block
     */
    @Override
    public void flush() {
        if (!this.closed) {
            Object object;
            if (!this.store) {
                return;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.getFullName(), "rw");
            this.writeHeader(randomAccessFile, this.getCapacity(), this.segmentSizeInBytes);
            randomAccessFile.seek(100L);
            int n = 0;
            while (true) {
                object = this.segments;
                if (n >= ((Object)object).length) break;
                Object object2 = object[n];
                int n2 = ((Object)object2).length;
                object = new byte[n2 * 4];
                for (int i = 0; i < n2; ++i) {
                    this.bitUtil.fromInt((byte[])object, (int)object2[i], i * 4);
                    continue;
                }
                randomAccessFile.write((byte[])object);
                ++n;
                continue;
                break;
            }
            randomAccessFile.close();
            return;
            {
                catch (Exception exception) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Couldn't store integers to ");
                    ((StringBuilder)object).append(this.toString());
                    throw new RuntimeException(((StringBuilder)object).toString(), exception);
                }
            }
            catch (Throwable throwable) {
                randomAccessFile.close();
                throw throwable;
            }
        }
        throw new IllegalStateException("already closed");
    }

    @Override
    public void getBytes(long l, byte[] object, int n) {
        object = new StringBuilder();
        ((StringBuilder)object).append(this.toString());
        ((StringBuilder)object).append(" does not support byte based acccess. Use RAMDataAccess instead");
        throw new UnsupportedOperationException(((StringBuilder)object).toString());
    }

    @Override
    public long getCapacity() {
        return (long)this.getSegments() * (long)this.segmentSizeInBytes;
    }

    @Override
    public final int getInt(long l) {
        int n = (int)((l >>>= 2) >>> this.segmentSizeIntsPower);
        int n2 = (int)(l & (long)this.indexDivisor);
        return this.segments[n][n2];
    }

    @Override
    public int getSegments() {
        return this.segments.length;
    }

    @Override
    public final short getShort(long l) {
        long l2 = l % 4L;
        if (l2 != 0L && l2 != 2L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("bytePos of wrong multiple for RAMInt ");
            stringBuilder.append(l);
            throw new IllegalMonitorStateException(stringBuilder.toString());
        }
        l2 = l >> 2;
        int n = (int)(l2 >> this.segmentSizeIntsPower);
        int n2 = (int)((long)this.indexDivisor & l2);
        if (l2 * 4L == l) {
            return (short)((long)this.segments[n][n2] & 0xFFFFL);
        }
        return (short)(this.segments[n][n2] >> 16);
    }

    @Override
    public DAType getType() {
        if (this.isStoring()) {
            return DAType.RAM_INT_STORE;
        }
        return DAType.RAM_INT;
    }

    @Override
    protected boolean isIntBased() {
        return true;
    }

    @Override
    public boolean isStoring() {
        return this.store;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean loadExisting() {
        if (this.segments.length <= 0) {
            if (!this.isClosed()) {
                if (!this.store) {
                    return false;
                }
                Object object = new File(this.getFullName());
                if (((File)object).exists() && ((File)object).length() != 0L) {
                    Object object2;
                    int n;
                    int n2;
                    byte[] byArray;
                    block20: {
                        long l;
                        block19: {
                            object = new RandomAccessFile(this.getFullName(), "r");
                            l = this.readHeader((RandomAccessFile)object);
                            if ((l -= 100L) >= 0L) break block19;
                            ((RandomAccessFile)object).close();
                            return false;
                        }
                        byArray = new byte[this.segmentSizeInBytes];
                        ((RandomAccessFile)object).seek(100L);
                        n = n2 = (int)(l / (long)this.segmentSizeInBytes);
                        if (l % (long)this.segmentSizeInBytes == 0L) break block20;
                        n = n2 + 1;
                    }
                    this.segments = new int[n][];
                    for (n2 = 0; n2 < n; ++n2) {
                        int n3 = ((RandomAccessFile)object).read(byArray) / 4;
                        object2 = new int[n3];
                        for (int i = 0; i < n3; ++i) {
                            object2[i] = this.bitUtil.toInt(byArray, i * 4);
                            continue;
                        }
                        this.segments[n2] = (int[])object2;
                        continue;
                    }
                    ((RandomAccessFile)object).close();
                    return true;
                    {
                        catch (IOException iOException) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Problem while loading ");
                            ((StringBuilder)object2).append(this.getFullName());
                            throw new RuntimeException(((StringBuilder)object2).toString(), iOException);
                        }
                    }
                    catch (Throwable throwable) {
                        ((RandomAccessFile)object).close();
                        throw throwable;
                    }
                }
                return false;
            }
            throw new IllegalStateException("already closed");
        }
        throw new IllegalStateException("already initialized");
    }

    boolean releaseSegment(int n) {
        this.segments[n] = null;
        return true;
    }

    @Override
    public void rename(String string2) {
        if (!this.checkBeforeRename(string2)) {
            return;
        }
        if (this.store) {
            super.rename(string2);
        }
        this.name = string2;
    }

    @Override
    public void setBytes(long l, byte[] object, int n) {
        object = new StringBuilder();
        ((StringBuilder)object).append(this.toString());
        ((StringBuilder)object).append(" does not support byte based acccess. Use RAMDataAccess instead");
        throw new UnsupportedOperationException(((StringBuilder)object).toString());
    }

    @Override
    public final void setInt(long l, int n) {
        int n2 = (int)((l >>>= 2) >>> this.segmentSizeIntsPower);
        int n3 = (int)(l & (long)this.indexDivisor);
        this.segments[n2][n3] = n;
    }

    @Override
    public DataAccess setSegmentSize(int n) {
        super.setSegmentSize(n);
        this.segmentSizeIntsPower = (int)(Math.log(this.segmentSizeInBytes / 4) / Math.log(2.0));
        this.indexDivisor = this.segmentSizeInBytes / 4 - 1;
        return this;
    }

    @Override
    public final void setShort(long l, short s) {
        long l2 = l % 4L;
        if (l2 != 0L && l2 != 2L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("bytePos of wrong multiple for RAMInt ");
            stringBuilder.append(l);
            throw new IllegalMonitorStateException(stringBuilder.toString());
        }
        l2 = l >>> 2;
        int n = (int)(l2 >>> this.segmentSizeIntsPower);
        int n2 = (int)((long)this.indexDivisor & l2);
        int[][] nArray = this.segments;
        int n3 = nArray[n][n2];
        nArray[n][n2] = l2 * 4L == l ? 0xFFFF0000 & n3 | s & 0xFFFF : n3 & 0xFFFF | s << 16;
    }

    public RAMIntDataAccess setStore(boolean bl) {
        this.store = bl;
        return this;
    }

    @Override
    public void trimTo(long l) {
        int n;
        long l2 = l;
        if (l < (long)this.segmentSizeInBytes) {
            l2 = this.segmentSizeInBytes;
        }
        int n2 = n = (int)(l2 / (long)this.segmentSizeInBytes);
        if (l2 % (long)this.segmentSizeInBytes != 0L) {
            n2 = n + 1;
        }
        this.segments = (int[][])Arrays.copyOf(this.segments, n2);
    }
}

