/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.LockFactory;
import java.io.File;
import java.io.IOException;

public class SimpleFSLockFactory
implements LockFactory {
    private File lockDir;

    public SimpleFSLockFactory() {
    }

    public SimpleFSLockFactory(File file) {
        this.lockDir = file;
    }

    @Override
    public GHLock create(String object, boolean bl) {
        synchronized (this) {
            block5: {
                File file = this.lockDir;
                if (file == null) break block5;
                object = new SimpleLock(file, (String)object);
                return object;
            }
            object = new RuntimeException("Set lockDir before creating locks");
            throw object;
        }
    }

    @Override
    public void forceRemove(String charSequence, boolean bl) {
        synchronized (this) {
            File file;
            if (this.lockDir.exists() && (file = new File(this.lockDir, (String)charSequence)).exists() && !file.delete()) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("Cannot delete ");
                ((StringBuilder)charSequence).append(file);
                RuntimeException runtimeException = new RuntimeException(((StringBuilder)charSequence).toString());
                throw runtimeException;
            }
            return;
        }
    }

    @Override
    public void setLockDir(File file) {
        this.lockDir = file;
    }

    static class SimpleLock
    implements GHLock {
        private IOException failedReason;
        private final File lockDir;
        private final File lockFile;
        private final String name;

        public SimpleLock(File file, String string2) {
            this.name = string2;
            this.lockDir = file;
            this.lockFile = new File(file, string2);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Exception getObtainFailedReason() {
            synchronized (this) {
                IOException iOException = this.failedReason;
                return iOException;
            }
        }

        @Override
        public boolean isLocked() {
            synchronized (this) {
                boolean bl = this.lockFile.exists();
                return bl;
            }
        }

        @Override
        public void release() {
            synchronized (this) {
                if (this.isLocked() && this.lockFile.exists() && !this.lockFile.delete()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Cannot release lock file: ");
                    stringBuilder.append(this.lockFile);
                    RuntimeException runtimeException = new RuntimeException(stringBuilder.toString());
                    throw runtimeException;
                }
                return;
            }
        }

        public String toString() {
            return this.lockFile.toString();
        }

        @Override
        public boolean tryLock() {
            synchronized (this) {
                if (!this.lockDir.exists() && !this.lockDir.mkdirs()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Directory ");
                    stringBuilder.append(this.lockDir);
                    stringBuilder.append(" does not exist and cannot be created to place lock file there: ");
                    stringBuilder.append(this.lockFile);
                    RuntimeException runtimeException = new RuntimeException(stringBuilder.toString());
                    throw runtimeException;
                }
                boolean bl = this.lockDir.isDirectory();
                if (bl) {
                    bl = this.lockFile.createNewFile();
                    return bl;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("lockDir has to be a directory: ");
                stringBuilder.append(this.lockDir);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.toString());
                throw illegalArgumentException;
            }
        }
    }
}

