/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Storable;
import com.graphhopper.util.Helper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorableProperties
implements Storable<StorableProperties> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorableProperties.class);
    private final DataAccess da;
    private final Map<String, String> map = new LinkedHashMap<String, String>();

    public StorableProperties(Directory object) {
        this.da = object = object.find("properties");
        object.setSegmentSize(32768);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void loadProperties(Map<String, String> map, Reader reader) throws IOException {
        reader = new BufferedReader(reader);
        try {
            String string2;
            while ((string2 = ((BufferedReader)reader).readLine()) != null) {
                Object object;
                if (string2.startsWith("//") || string2.startsWith("#") || Helper.isEmpty(string2)) continue;
                int n = string2.indexOf("=");
                if (n < 0) {
                    object = LOGGER;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Skipping configuration at line:");
                    stringBuilder.append(string2);
                    object.warn(stringBuilder.toString());
                    continue;
                }
                object = string2.substring(0, n);
                string2 = string2.substring(n + 1);
                map.put(((String)object).trim(), string2.trim());
            }
            return;
        }
        finally {
            ((BufferedReader)reader).close();
        }
    }

    boolean check(String string2, int n, boolean bl) {
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(".version");
        charSequence = this.get(((StringBuilder)charSequence).toString());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append("");
        if (!((String)charSequence).equals(stringBuilder.toString())) {
            if (bl) {
                return false;
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("Version of ");
            stringBuilder.append(string2);
            stringBuilder.append(" unsupported: ");
            stringBuilder.append((String)charSequence);
            stringBuilder.append(", expected:");
            stringBuilder.append(n);
            stringBuilder.append(". Make sure you are using the same GraphHopper version for reading the files that was used for creating them. See https://discuss.graphhopper.com/t/722");
            throw new IllegalStateException(stringBuilder.toString());
        }
        return true;
    }

    public boolean checkVersions(boolean bl) {
        synchronized (this) {
            block13: {
                block12: {
                    boolean bl2;
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    bl2 = this.check("nodes", 5, bl);
                                    if (bl2) break block8;
                                    return false;
                                }
                                bl2 = this.check("edges", 14, bl);
                                if (bl2) break block9;
                                return false;
                            }
                            bl2 = this.check("geometry", 4, bl);
                            if (bl2) break block10;
                            return false;
                        }
                        bl2 = this.check("location_index", 3, bl);
                        if (bl2) break block11;
                        return false;
                    }
                    bl2 = this.check("name_index", 3, bl);
                    if (bl2) break block12;
                    return false;
                }
                bl = this.check("shortcuts", 2, bl);
                if (bl) break block13;
                return false;
            }
            return true;
        }
    }

    @Override
    public void close() {
        synchronized (this) {
            this.da.close();
            return;
        }
    }

    @Override
    public StorableProperties create(long l) {
        synchronized (this) {
            this.da.create(l);
            return this;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush() {
        synchronized (this) {
            try {
                try {
                    Object object = new StringWriter();
                    Helper.saveProperties(this.map, (Writer)object);
                    object = ((StringWriter)object).toString().getBytes(Helper.UTF_CS);
                    this.da.setBytes(0L, (byte[])object, ((Object)object).length);
                    this.da.flush();
                    return;
                }
                catch (IOException iOException) {
                    RuntimeException runtimeException = new RuntimeException(iOException);
                    throw runtimeException;
                }
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    public String get(String string2) {
        synchronized (this) {
            block4: {
                block5: {
                    if (!string2.equals(Helper.toLowerCase(string2))) break block4;
                    if ((string2 = this.map.get(string2)) != null) break block5;
                    return "";
                }
                return string2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Do not use upper case keys (");
            stringBuilder.append(string2);
            stringBuilder.append(") for StorableProperties since 0.7");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.toString());
            throw illegalArgumentException;
        }
    }

    @Override
    public long getCapacity() {
        synchronized (this) {
            long l = this.da.getCapacity();
            return l;
        }
    }

    @Override
    public boolean isClosed() {
        synchronized (this) {
            boolean bl = this.da.isClosed();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadExisting() {
        synchronized (this) {
            boolean bl = this.da.loadExisting();
            if (!bl) {
                return false;
            }
            int n = (int)this.da.getCapacity();
            byte[] byArray = new byte[n];
            this.da.getBytes(0L, byArray, n);
            try {
                Map<String, String> map = this.map;
                String string2 = new String(byArray, Helper.UTF_CS);
                StringReader stringReader = new StringReader(string2);
                StorableProperties.loadProperties(map, stringReader);
                return true;
            }
            catch (IOException iOException) {
                IllegalStateException illegalStateException = new IllegalStateException(iOException);
                throw illegalStateException;
            }
        }
    }

    public StorableProperties put(String string2, Object object) {
        synchronized (this) {
            block4: {
                if (!string2.equals(Helper.toLowerCase(string2))) break block4;
                this.map.put(string2, object.toString());
                return this;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Do not use upper case keys (");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(") for StorableProperties since 0.7");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(((StringBuilder)object).toString());
            throw illegalArgumentException;
        }
    }

    public StorableProperties put(String string2, String string3) {
        synchronized (this) {
            this.map.put(string2, string3);
            return this;
        }
    }

    public StorableProperties putAll(Map<String, String> map) {
        synchronized (this) {
            this.map.putAll(map);
            return this;
        }
    }

    public void putCurrentVersions() {
        synchronized (this) {
            this.put("nodes.version", 5);
            this.put("edges.version", 14);
            this.put("geometry.version", 4);
            this.put("location_index.version", 3);
            this.put("name_index.version", 3);
            this.put("shortcuts.version", 2);
            return;
        }
    }

    public StorableProperties remove(String string2) {
        synchronized (this) {
            this.map.remove(string2);
            return this;
        }
    }

    public String toString() {
        synchronized (this) {
            String string2 = this.da.toString();
            return string2;
        }
    }

    public String versionsToString() {
        synchronized (this) {
            CharSequence charSequence = new StringBuilder();
            charSequence.append(this.get("nodes.version"));
            charSequence.append(",");
            charSequence.append(this.get("edges.version"));
            charSequence.append(",");
            charSequence.append(this.get("geometry.version"));
            charSequence.append(",");
            charSequence.append(this.get("location_index.version"));
            charSequence.append(",");
            charSequence.append(this.get("name_index.version"));
            charSequence = charSequence.toString();
            return charSequence;
        }
    }
}

