/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.change;

import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeGraphHelper {
    private boolean enableLogging = false;
    private final Graph graph;
    private final GraphEdgeIdFinder graphBrowser;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ChangeGraphHelper(Graph graph, LocationIndex locationIndex) {
        this.graph = graph;
        this.graphBrowser = new GraphEdgeIdFinder(graph, locationIndex);
    }

    private long applyChange(JsonFeature jsonFeature, FlagEncoder object) {
        block9: {
            Object object2;
            Object object3;
            block8: {
                block7: {
                    object3 = DefaultEdgeFilter.allEdges((FlagEncoder)object);
                    object2 = new GHIntHashSet();
                    if (!jsonFeature.hasGeometry()) break block7;
                    this.graphBrowser.fillEdgeIDs((GHIntHashSet)((Object)object2), jsonFeature.getGeometry(), (EdgeFilter)object3);
                    break block8;
                }
                if (jsonFeature.getBBox() == null) break block9;
                this.graphBrowser.findEdgesInShape((GHIntHashSet)((Object)object2), jsonFeature.getBBox(), (EdgeFilter)object3);
            }
            object3 = object2.iterator();
            object2 = jsonFeature.getProperties();
            long l = 0L;
            while (object3.hasNext()) {
                StringBuilder stringBuilder;
                Logger logger;
                int n = ((IntCursor)object3.next()).value;
                EdgeIteratorState edgeIteratorState = this.graph.getEdgeIteratorState(n, Integer.MIN_VALUE);
                if (object2.containsKey("access")) {
                    boolean bl = (Boolean)object2.get("access");
                    ++l;
                    if (this.enableLogging) {
                        logger = this.logger;
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(object.toString());
                        stringBuilder.append(" - access change via feature ");
                        stringBuilder.append(jsonFeature.getId());
                        logger.info(stringBuilder.toString());
                    }
                    edgeIteratorState.setFlags(object.setAccess(edgeIteratorState.getFlags(), bl, bl));
                    continue;
                }
                if (!object2.containsKey("speed")) continue;
                double d = ((Number)object2.get("speed")).doubleValue();
                double d2 = object.getSpeed(edgeIteratorState.getFlags());
                if (d2 == d) continue;
                ++l;
                if (this.enableLogging) {
                    logger = this.logger;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(object.toString());
                    stringBuilder.append(" - speed change via feature ");
                    stringBuilder.append(jsonFeature.getId());
                    stringBuilder.append(". Old: ");
                    stringBuilder.append(d2);
                    stringBuilder.append(", new:");
                    stringBuilder.append(d);
                    logger.info(stringBuilder.toString());
                }
                edgeIteratorState.setFlags(object.setSpeed(edgeIteratorState.getFlags(), d));
            }
            return l;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Feature ");
        ((StringBuilder)object).append(jsonFeature.getId());
        ((StringBuilder)object).append(" has no geometry and no bbox");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public long applyChanges(EncodingManager encodingManager, Collection<JsonFeature> object) {
        Objects.requireNonNull(encodingManager, "EncodingManager cannot be null to change existing graph");
        long l = 0L;
        Iterator<JsonFeature> iterator2 = object.iterator();
        block0: while (iterator2.hasNext()) {
            object = iterator2.next();
            if (((JsonFeature)object).hasProperties()) {
                long l2;
                Object object2 = (List)((JsonFeature)object).getProperty("vehicles");
                if (object2 == null) {
                    object2 = encodingManager.fetchEdgeEncoders().iterator();
                    l2 = l;
                    while (true) {
                        l = l2;
                        if (!object2.hasNext()) continue block0;
                        l2 += this.applyChange((JsonFeature)object, object2.next());
                    }
                }
                object2 = object2.iterator();
                l2 = l;
                while (true) {
                    l = l2;
                    if (!object2.hasNext()) continue block0;
                    l2 += this.applyChange((JsonFeature)object, encodingManager.getEncoder((String)((Object)object2.next())));
                }
            }
            throw new IllegalArgumentException("One feature has no properties, please specify properties e.g. speed or access");
        }
        return l;
    }

    public void setLogging(boolean bl) {
        this.enableLogging = bl;
    }
}

