/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.Circle;

public class Location2IDFullIndex
implements LocationIndex {
    private DistanceCalc calc = Helper.DIST_PLANE;
    private boolean closed = false;
    private final Graph graph;
    private final NodeAccess nodeAccess;

    public Location2IDFullIndex(Graph graph) {
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public LocationIndex create(long l) {
        return this;
    }

    @Override
    public QueryResult findClosest(double d, double d2, EdgeFilter edgeFilter) {
        block4: {
            if (this.isClosed()) break block4;
            QueryResult queryResult = new QueryResult(d, d2);
            Circle circle = null;
            AllEdgesIterator allEdgesIterator = this.graph.getAllEdges();
            block0: while (allEdgesIterator.next()) {
                if (!edgeFilter.accept(allEdgesIterator)) continue;
                for (int i = 0; i < 2; ++i) {
                    Circle circle2;
                    block6: {
                        double d3;
                        double d4;
                        double d5;
                        int n;
                        block5: {
                            n = i == 0 ? allEdgesIterator.getBaseNode() : allEdgesIterator.getAdjNode();
                            d5 = this.nodeAccess.getLatitude(n);
                            d4 = this.nodeAccess.getLongitude(n);
                            d3 = this.calc.calcDist(d5, d4, d, d2);
                            if (circle == null) break block5;
                            circle2 = circle;
                            if (!(d3 < this.calc.calcDist(circle.getLat(), circle.getLon(), d, d2))) break block6;
                        }
                        queryResult.setClosestEdge(allEdgesIterator.detach(false));
                        queryResult.setClosestNode(n);
                        queryResult.setQueryDistance(d3);
                        if (d3 <= 0.0) continue block0;
                        circle2 = new Circle(d5, d4, d3, this.calc);
                    }
                    circle = circle2;
                }
            }
            return queryResult;
        }
        throw new IllegalStateException("You need to create a new LocationIndex instance as it is already closed");
    }

    @Override
    public void flush() {
    }

    @Override
    public long getCapacity() {
        return 0L;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean loadExisting() {
        return true;
    }

    @Override
    public LocationIndex prepareIndex() {
        return this;
    }

    @Override
    public LocationIndex setApproximation(boolean bl) {
        this.calc = bl ? Helper.DIST_PLANE : Helper.DIST_EARTH;
        return this;
    }

    @Override
    public LocationIndex setResolution(int n) {
        return this;
    }

    @Override
    public void setSegmentSize(int n) {
    }
}

