/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.coll.GHTBitSet;
import com.graphhopper.geohash.KeyAlgo;
import com.graphhopper.geohash.LinearKeyAlgo;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Location2IDQuadtree
implements LocationIndex {
    private static final int MAGIC_INT = 174507;
    protected DistanceCalc distCalc;
    private final Graph graph;
    private final DataAccess index;
    private KeyAlgo keyAlgo;
    private int latSize;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int lonSize;
    private double maxRasterWidth2InMeterNormed;
    private final NodeAccess nodeAccess;

    public Location2IDQuadtree(Graph graph, Directory directory) {
        this.distCalc = Helper.DIST_PLANE;
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
        this.index = directory.find("loc2id_index");
        this.setResolution(10000);
    }

    /*
     * Unable to fully structure code
     */
    private int fillEmptyIndices(GHBitSet var1_1) {
        block11: {
            var2_2 = this.latSize * this.lonSize;
            var3_3 = new RAMDirectory().find("temp_index_copy");
            var3_3.setSegmentSize(this.index.getSegmentSize()).create(this.index.getCapacity());
            var4_4 = new GHBitSetImpl(var2_2);
            var5_5 = var1_1.getCardinality();
            var6_6 = new int[var2_2];
            Arrays.fill(var6_6, -1);
            var7_7 = var1_1.next(0);
            while (var7_7 >= 0) {
                var6_6[var7_7] = var7_7;
                var7_7 = var1_1.next(var7_7 + 1);
            }
            if (var5_5 == 0) break block11;
            var7_7 = var5_5;
            while (var7_7 < var2_2) {
                this.index.copyTo(var3_3);
                var1_1.copyTo(var4_4);
                var8_8 = var1_1.getCardinality();
                for (var7_7 = 0; var7_7 < var2_2; ++var7_7) {
                    block10: {
                        block12: {
                            if (!var4_4.contains(var7_7)) break block12;
                            var9_9 = var7_7 + 1;
                            if (var9_9 % this.lonSize != 0 && !var4_4.contains(var9_9)) lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    var10_10 = var7_7;
                                    break block10;
                                    break;
                                }
                            }
                            var9_9 = this.lonSize;
                            if (var7_7 + var9_9 < var2_2 && !var4_4.contains(var9_9 + var7_7)) {
                                var9_9 = this.lonSize + var7_7;
                                ** continue;
                            }
                            ** GOTO lbl45
                        }
                        var9_9 = var7_7 + 1;
                        if (var9_9 % this.lonSize != 0 && var4_4.contains(var9_9)) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                var10_10 = var9_9;
                                var9_9 = var7_7;
                                break;
                            }
                        } else {
                            var9_9 = this.lonSize;
                            if (var7_7 + var9_9 < var2_2 && var4_4.contains(var9_9 + var7_7)) {
                                var9_9 = this.lonSize + var7_7;
                                ** continue;
                            }
lbl45:
                            // 3 sources

                            var9_9 = -1;
                            var10_10 = -1;
                        }
                    }
                    if (var9_9 < 0 || var6_6[var9_9] >= 0 && (var6_6[var9_9] == var9_9 || this.getNormedDist(var10_10, var9_9) >= this.getNormedDist(var6_6[var9_9], var9_9))) continue;
                    this.index.setInt(var9_9 * 4, var3_3.getInt(var10_10 * 4));
                    var6_6[var9_9] = var6_6[var10_10];
                    var1_1.add(var9_9);
                    ++var8_8;
                }
                var7_7 = var8_8;
            }
            return var7_7 - var5_5;
        }
        throw new IllegalStateException("at least one entry has to be != null, which should have happened in initIndex");
    }

    private GHBitSet fillQuadtree(int n) {
        int n2 = this.graph.getNodes();
        if (n2 > 0) {
            GHBitSetImpl gHBitSetImpl = new GHBitSetImpl(n);
            GHPoint gHPoint = new GHPoint();
            n = n2;
            for (int i = 0; i < n; ++i) {
                double d = this.nodeAccess.getLatitude(i);
                double d2 = this.nodeAccess.getLongitude(i);
                n2 = (int)this.keyAlgo.encode(d, d2);
                long l = n2;
                long l2 = 4L * l;
                if (gHBitSetImpl.contains(n2)) {
                    n2 = this.index.getInt(l2);
                    this.keyAlgo.decode(l, gHPoint);
                    d = this.distCalc.calcNormalizedDist(gHPoint.lat, gHPoint.lon, d, d2);
                    d2 = this.nodeAccess.getLatitude(n2);
                    double d3 = this.nodeAccess.getLongitude(n2);
                    if (!(d < this.distCalc.calcNormalizedDist(gHPoint.lat, gHPoint.lon, d2, d3))) continue;
                    this.index.setInt(l2, i);
                    continue;
                }
                this.index.setInt(l2, i);
                gHBitSetImpl.add(n2);
            }
            return gHBitSetImpl;
        }
        throw new IllegalStateException("check your graph - it is empty!");
    }

    private void initBuffer() {
        this.index.setSegmentSize(this.latSize * this.lonSize * 4);
        this.index.create(this.latSize * this.lonSize * 4);
    }

    private void initLatLonSize(int n) {
        int n2;
        this.lonSize = n2 = (int)Math.sqrt(n);
        this.latSize = n2;
        if (n2 * n2 < n) {
            this.lonSize = n2 + 1;
        }
    }

    @Override
    public void close() {
        this.index.close();
    }

    @Override
    public LocationIndex create(long l) {
        throw new UnsupportedOperationException("Not supported. Use prepareIndex instead.");
    }

    @Override
    public QueryResult findClosest(final double d, final double d2, EdgeFilter object) {
        if (!this.isClosed()) {
            if (object == EdgeFilter.ALL_EDGES) {
                long l = this.keyAlgo.encode(d, d2);
                final int n = this.index.getInt(l * 4L);
                double d3 = this.nodeAccess.getLatitude(n);
                double d4 = this.nodeAccess.getLongitude(n);
                object = new QueryResult(d, d2);
                ((QueryResult)object).setClosestNode(n);
                ((QueryResult)object).setQueryDistance(this.distCalc.calcNormalizedDist(d, d2, d3, d4));
                this.goFurtherHook(n);
                new BreadthFirstSearch((QueryResult)object){
                    final /* synthetic */ QueryResult val$res;
                    {
                        this.val$res = queryResult;
                    }

                    @Override
                    protected GHBitSet createBitSet() {
                        return new GHTBitSet(10);
                    }

                    @Override
                    protected boolean goFurther(int n3) {
                        int n2 = n;
                        boolean bl = true;
                        if (n3 == n2) {
                            return true;
                        }
                        Location2IDQuadtree.this.goFurtherHook(n3);
                        double d3 = Location2IDQuadtree.this.nodeAccess.getLatitude(n3);
                        double d22 = Location2IDQuadtree.this.nodeAccess.getLongitude(n3);
                        d22 = Location2IDQuadtree.this.distCalc.calcNormalizedDist(d, d2, d3, d22);
                        if (d22 < this.val$res.getQueryDistance()) {
                            this.val$res.setQueryDistance(d22);
                            this.val$res.setClosestNode(n3);
                            return true;
                        }
                        if (!(d22 < Location2IDQuadtree.this.maxRasterWidth2InMeterNormed)) {
                            bl = false;
                        }
                        return bl;
                    }
                }.start(this.graph.createEdgeExplorer(), n);
                ((QueryResult)object).setQueryDistance(this.distCalc.calcDenormalizedDist(((QueryResult)object).getQueryDistance()));
                return object;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("edge filters are not yet implemented for ");
            ((StringBuilder)object).append("Location2IDQuadtree");
            throw new UnsupportedOperationException(((StringBuilder)object).toString());
        }
        throw new IllegalStateException("You need to create a new LocationIndex instance as it is already closed");
    }

    @Override
    public void flush() {
        this.index.setHeader(0, 174507);
        this.index.setHeader(4, this.latSize);
        this.index.setHeader(8, this.lonSize);
        this.index.setHeader(12, this.graph.getNodes());
        this.index.flush();
    }

    @Override
    public long getCapacity() {
        return this.index.getCapacity() / 4L;
    }

    protected double getMaxRasterWidthMeter() {
        return this.distCalc.calcDenormalizedDist(this.maxRasterWidth2InMeterNormed) / 2.0;
    }

    double getNormedDist(int n, int n2) {
        int n3 = this.lonSize;
        int n4 = n / n3;
        int n5 = n2 / n3;
        n = n2 % n3 - n % n3;
        n2 = n5 - n4;
        return n * n + n2 * n2;
    }

    public void goFurtherHook(int n) {
    }

    void initAlgo(int n, int n2) {
        this.latSize = n;
        this.lonSize = n2;
        BBox bBox = this.graph.getBounds();
        this.keyAlgo = new LinearKeyAlgo(n, n2).setBounds(bBox);
        double d = Math.max(this.distCalc.calcDist(bBox.minLat, bBox.minLon, bBox.minLat, bBox.maxLon), this.distCalc.calcDist(bBox.minLat, bBox.minLon, bBox.maxLat, bBox.minLon));
        this.maxRasterWidth2InMeterNormed = this.distCalc.calcNormalizedDist(d / Math.sqrt(this.getCapacity()) * 2.0);
    }

    @Override
    public boolean isClosed() {
        return this.index.isClosed();
    }

    @Override
    public boolean loadExisting() {
        if (!this.index.loadExisting()) {
            return false;
        }
        if (this.index.getHeader(0) == 174507) {
            int n = this.index.getHeader(4);
            int n2 = this.index.getHeader(8);
            int n3 = this.index.getHeader(12);
            if (n3 == this.graph.getNodes()) {
                this.initAlgo(n, n2);
                return true;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("index was created from a different graph with ");
            stringBuilder.append(n3);
            stringBuilder.append(". Current nodes:");
            stringBuilder.append(this.graph.getNodes());
            throw new IllegalStateException(stringBuilder.toString());
        }
        throw new IllegalStateException("incorrect loc2id index version");
    }

    @Override
    public LocationIndex prepareIndex() {
        this.initBuffer();
        this.initAlgo(this.latSize, this.lonSize);
        Object object = new StopWatch().start();
        GHBitSet gHBitSet = this.fillQuadtree(this.latSize * this.lonSize);
        int n = gHBitSet.getCardinality();
        float f = ((StopWatch)object).stop().getSeconds();
        object = new StopWatch().start();
        int n2 = this.fillEmptyIndices(gHBitSet);
        float f2 = ((StopWatch)object).stop().getSeconds();
        gHBitSet = this.logger;
        object = new StringBuilder();
        ((StringBuilder)object).append("filled quadtree index array in ");
        ((StringBuilder)object).append(f);
        ((StringBuilder)object).append("s. size is ");
        ((StringBuilder)object).append(this.getCapacity());
        ((StringBuilder)object).append(" (");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append("). filled empty ");
        ((StringBuilder)object).append(n2);
        ((StringBuilder)object).append(" in ");
        ((StringBuilder)object).append(f2);
        ((StringBuilder)object).append("s");
        gHBitSet.info(((StringBuilder)object).toString());
        this.flush();
        return this;
    }

    @Override
    public LocationIndex setApproximation(boolean bl) {
        this.distCalc = bl ? Helper.DIST_PLANE : Helper.DIST_EARTH;
        return this;
    }

    @Override
    public LocationIndex setResolution(int n) {
        this.initLatLonSize(n);
        return this;
    }

    @Override
    public void setSegmentSize(int n) {
        this.index.setSegmentSize(n);
    }
}

