/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.coll.GHTBitSet;
import com.graphhopper.geohash.SpatialKeyAlgo;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.BresenhamLine;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.PointEmitter;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationIndexTree
implements LocationIndex {
    private static final Comparator<QueryResult> QR_COMPARATOR = new Comparator<QueryResult>(){

        @Override
        public int compare(QueryResult queryResult, QueryResult queryResult2) {
            return Double.compare(queryResult.getQueryDistance(), queryResult2.getQueryDistance());
        }
    };
    static final int START_POINTER = 1;
    private final int MAGIC_INT;
    private long[] bitmasks;
    final DataAccess dataAccess;
    private double deltaLat;
    private double deltaLon;
    protected DistanceCalc distCalc;
    private int[] entries;
    private double equalNormedDelta;
    protected final Graph graph;
    private int initSizeLeafEntries = 4;
    private boolean initialized = false;
    protected SpatialKeyAlgo keyAlgo;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    int maxRegionSearch = 4;
    private int minResolutionInMeter = 300;
    private final NodeAccess nodeAccess;
    private DistanceCalc preciseDistCalc;
    private byte[] shifts;

    public LocationIndexTree(Graph graph, Directory directory) {
        this.distCalc = Helper.DIST_PLANE;
        this.preciseDistCalc = Helper.DIST_EARTH;
        if (!(graph instanceof CHGraph)) {
            this.MAGIC_INT = 96230;
            this.graph = graph;
            this.nodeAccess = graph.getNodeAccess();
            this.dataAccess = directory.find("location_index");
            return;
        }
        throw new IllegalArgumentException("Use base graph for LocationIndexTree instead of CHGraph");
    }

    private long getBitmask(int n) {
        long l = (1L << n) - 1L;
        if (l > 0L) {
            return l;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid bitmask:");
        stringBuilder.append(l);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private byte getShift(int n) {
        byte by = (byte)Math.round(Math.log(n) / Math.log(2.0));
        if (by > 0) {
            return by;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid shift:");
        stringBuilder.append(by);
        throw new IllegalStateException(stringBuilder.toString());
    }

    private LocationIndexTree initEntries(int[] nArray) {
        if (nArray.length >= 1) {
            this.entries = nArray;
            int n = nArray.length;
            this.shifts = new byte[n];
            this.bitmasks = new long[n];
            int n2 = nArray[0];
            for (int i = 0; i < n; ++i) {
                if (n2 >= nArray[i]) {
                    n2 = nArray[i];
                    this.shifts[i] = this.getShift(nArray[i]);
                    this.bitmasks[i] = this.getBitmask(this.shifts[i]);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("entries should decrease or stay but was:");
                stringBuilder.append(Arrays.toString(nArray));
                throw new IllegalStateException(stringBuilder.toString());
            }
            return this;
        }
        throw new IllegalStateException("depth needs to be at least 1");
    }

    int calcChecksum() {
        return this.graph.getNodes();
    }

    final double calcMinDistance(double d, double d2, GHIntHashSet object) {
        object = object.iterator();
        double d3 = Double.MAX_VALUE;
        while (object.hasNext()) {
            int n = ((IntCursor)object.next()).value;
            double d4 = this.nodeAccess.getLat(n);
            double d5 = this.nodeAccess.getLon(n);
            if (!((d5 = this.distCalc.calcDist(d, d2, d4, d5)) < d3)) continue;
            d3 = d5;
        }
        return d3;
    }

    final double calculateRMin(double d, double d2) {
        return this.calculateRMin(d, d2, 0);
    }

    final double calculateRMin(double d, double d2, int n) {
        GHPoint gHPoint = new GHPoint(d, d2);
        long l = this.keyAlgo.encode(gHPoint);
        GHPoint gHPoint2 = new GHPoint();
        this.keyAlgo.decode(l, gHPoint2);
        d = gHPoint2.lat;
        double d3 = (double)n + 0.5;
        d -= this.deltaLat * d3;
        double d4 = gHPoint2.lat + this.deltaLat * d3;
        d2 = gHPoint2.lon - this.deltaLon * d3;
        d3 = gHPoint2.lon + d3 * this.deltaLon;
        double d5 = gHPoint.lat;
        double d6 = gHPoint.lat;
        double d7 = gHPoint.lon;
        double d8 = gHPoint.lon;
        d = d5 - d < d4 - d6 ? this.distCalc.calcDist(gHPoint.lat, gHPoint.lon, d, gHPoint.lon) : this.distCalc.calcDist(gHPoint.lat, gHPoint.lon, d4, gHPoint.lon);
        d2 = d7 - d2 < d3 - d8 ? this.distCalc.calcDist(gHPoint.lat, gHPoint.lon, gHPoint.lat, d2) : this.distCalc.calcDist(gHPoint.lat, gHPoint.lon, gHPoint.lat, d3);
        return Math.min(d, d2);
    }

    @Override
    public void close() {
        this.dataAccess.close();
    }

    @Override
    public LocationIndexTree create(long l) {
        throw new UnsupportedOperationException("Not supported. Use prepareIndex instead.");
    }

    final long createReverseKey(double d, double d2) {
        return BitUtil.BIG.reverse(this.keyAlgo.encode(d, d2), this.keyAlgo.getBits());
    }

    final long createReverseKey(long l) {
        return BitUtil.BIG.reverse(l, this.keyAlgo.getBits());
    }

    final void fillIDs(long l, int n, GHIntHashSet gHIntHashSet, int n2) {
        long l2 = (long)n << 2;
        if (n2 == this.entries.length) {
            n = this.dataAccess.getInt(l2);
            if (n < 0) {
                gHIntHashSet.add(-(n + 1));
            } else {
                long l3 = n;
                l = l2;
                while ((l += 4L) < l3 * 4L) {
                    gHIntHashSet.add(this.dataAccess.getInt(l));
                }
            }
            return;
        }
        n = (int)(this.bitmasks[n2] & l);
        if ((n = this.dataAccess.getInt(l2 + (long)(n << 2))) > 0) {
            this.fillIDs(l >>> this.shifts[n2], n, gHIntHashSet, n2 + 1);
        }
    }

    @Override
    public QueryResult findClosest(final double d, final double d2, EdgeFilter edgeFilter) {
        if (!this.isClosed()) {
            GHIntHashSet gHIntHashSet = new GHIntHashSet();
            QueryResult queryResult = new QueryResult(d, d2);
            for (int i = 0; i < this.maxRegionSearch; ++i) {
                GHIntHashSet gHIntHashSet2 = new GHIntHashSet();
                boolean bl = this.findNetworkEntries(d, d2, gHIntHashSet2, i);
                gHIntHashSet2.removeAll((IntLookupContainer)gHIntHashSet);
                gHIntHashSet.addAll((IntContainer)gHIntHashSet2);
                gHIntHashSet2.forEach(new IntPredicate(new GHTBitSet(new GHIntHashSet((IntContainer)gHIntHashSet2)), edgeFilter, queryResult, this.graph.createEdgeExplorer()){
                    final /* synthetic */ GHBitSet val$checkBitset;
                    final /* synthetic */ QueryResult val$closestMatch;
                    final /* synthetic */ EdgeFilter val$edgeFilter;
                    final /* synthetic */ EdgeExplorer val$explorer;
                    {
                        this.val$checkBitset = gHBitSet;
                        this.val$edgeFilter = edgeFilter;
                        this.val$closestMatch = queryResult;
                        this.val$explorer = edgeExplorer;
                    }

                    public boolean apply(int n) {
                        new XFirstSearchCheck(d, d2, this.val$checkBitset, this.val$edgeFilter){

                            @Override
                            protected boolean check(int n, double d, int n2, EdgeIteratorState edgeIteratorState, QueryResult.Position position) {
                                if (d < val$closestMatch.getQueryDistance()) {
                                    val$closestMatch.setQueryDistance(d);
                                    val$closestMatch.setClosestNode(n);
                                    val$closestMatch.setClosestEdge(edgeIteratorState.detach(false));
                                    val$closestMatch.setWayIndex(n2);
                                    val$closestMatch.setSnappedPosition(position);
                                    return true;
                                }
                                return false;
                            }

                            @Override
                            protected double getQueryDistance() {
                                return val$closestMatch.getQueryDistance();
                            }
                        }.start(this.val$explorer, n);
                        return true;
                    }
                });
                if (bl && queryResult.isValid()) break;
            }
            if (queryResult.isValid()) {
                queryResult.setQueryDistance(this.distCalc.calcDenormalizedDist(queryResult.getQueryDistance()));
                queryResult.calcSnappedPoint(this.distCalc);
            }
            return queryResult;
        }
        throw new IllegalStateException("You need to create a new LocationIndex instance as it is already closed");
    }

    public List<QueryResult> findNClosest(final double d, final double d2, EdgeFilter object, double d3) {
        d3 = this.distCalc.calcNormalizedDist(d3);
        ArrayList<QueryResult> arrayList = new ArrayList<QueryResult>();
        Object object2 = new GHIntHashSet();
        for (int i = 0; i < 2; ++i) {
            this.findNetworkEntries(d, d2, (GHIntHashSet)((Object)object2), i);
            object2.forEach(new IntPredicate(new GHTBitSet(new GHIntHashSet((IntContainer)object2)), (EdgeFilter)object, d3, arrayList, this.graph.createEdgeExplorer((EdgeFilter)object)){
                final /* synthetic */ EdgeFilter val$edgeFilter;
                final /* synthetic */ GHBitSet val$exploredNodes;
                final /* synthetic */ EdgeExplorer val$explorer;
                final /* synthetic */ List val$queryResults;
                final /* synthetic */ double val$returnAllResultsWithin;
                {
                    this.val$exploredNodes = gHBitSet;
                    this.val$edgeFilter = edgeFilter;
                    this.val$returnAllResultsWithin = d3;
                    this.val$queryResults = list;
                    this.val$explorer = edgeExplorer;
                }

                public boolean apply(int n) {
                    new XFirstSearchCheck(d, d2, this.val$exploredNodes, this.val$edgeFilter){

                        /*
                         * Unable to fully structure code
                         */
                        @Override
                        protected boolean check(int var1_1, double var2_2, int var4_3, EdgeIteratorState var5_4, QueryResult.Position var6_5) {
                            if (var2_2 < val$returnAllResultsWithin || val$queryResults.isEmpty() || ((QueryResult)val$queryResults.get(0)).getQueryDistance() > var2_2) {
                                var7_6 = -1;
                                var8_7 = 0;
                                while (true) {
                                    var9_8 = var7_6;
                                    if (var8_7 >= val$queryResults.size()) break;
                                    var10_9 = (QueryResult)val$queryResults.get(var8_7);
                                    if (!(var10_9.getQueryDistance() > val$returnAllResultsWithin)) {
                                        if (var10_9.getClosestEdge().getEdge() == var5_4.getEdge()) {
                                            if (var10_9.getQueryDistance() < var2_2) {
                                                return true;
                                            } else {
                                                ** GOTO lbl-1000
                                            }
                                        }
                                    } else lbl-1000:
                                    // 3 sources

                                    {
                                        var9_8 = var8_7;
                                        break;
                                    }
                                    ++var8_7;
                                }
                                var10_9 = new QueryResult(this.queryLat, this.queryLon);
                                var10_9.setQueryDistance(var2_2);
                                var10_9.setClosestNode(var1_1);
                                var10_9.setClosestEdge(var5_4.detach(false));
                                var10_9.setWayIndex(var4_3);
                                var10_9.setSnappedPosition(var6_5);
                                if (var9_8 < 0) {
                                    val$queryResults.add(var10_9);
                                } else {
                                    val$queryResults.set(var9_8, var10_9);
                                }
                            }
                            return true;
                        }

                        @Override
                        protected double getQueryDistance() {
                            return Double.MAX_VALUE;
                        }
                    }.start(this.val$explorer, n);
                    return true;
                }
            });
        }
        Collections.sort(arrayList, QR_COMPARATOR);
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (QueryResult)object2.next();
            if (((QueryResult)object).isValid()) {
                ((QueryResult)object).setQueryDistance(this.distCalc.calcDenormalizedDist(((QueryResult)object).getQueryDistance()));
                ((QueryResult)object).calcSnappedPoint(this.distCalc);
                continue;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Invalid QueryResult should not happen here: ");
            ((StringBuilder)object2).append(object);
            throw new IllegalStateException(((StringBuilder)object2).toString());
        }
        return arrayList;
    }

    public final boolean findNetworkEntries(double d, double d2, GHIntHashSet gHIntHashSet, int n) {
        double d3;
        double d4;
        double d5;
        int n2;
        int n3;
        for (n3 = n2 = -n; n3 <= n; ++n3) {
            d5 = d + (double)n3 * this.deltaLat;
            d4 = n;
            d3 = this.deltaLon;
            this.findNetworkEntriesSingleRegion(gHIntHashSet, d5, d2 - d4 * d3);
            if (n <= 0) continue;
            this.findNetworkEntriesSingleRegion(gHIntHashSet, d5, d2 + d4 * d3);
        }
        for (n3 = n2 + 1; n3 <= n - 1; ++n3) {
            d4 = d2 + (double)n3 * this.deltaLon;
            d3 = n;
            d5 = this.deltaLat;
            this.findNetworkEntriesSingleRegion(gHIntHashSet, d - d3 * d5, d4);
            this.findNetworkEntriesSingleRegion(gHIntHashSet, d + d3 * d5, d4);
        }
        if (n % 2 != 0 && !gHIntHashSet.isEmpty()) {
            d4 = this.calculateRMin(d, d2, n);
            if (this.calcMinDistance(d, d2, gHIntHashSet) < d4) {
                return true;
            }
        }
        return false;
    }

    public final void findNetworkEntriesSingleRegion(GHIntHashSet gHIntHashSet, double d, double d2) {
        this.fillIDs(this.createReverseKey(d, d2), 1, gHIntHashSet, 0);
    }

    @Override
    public void flush() {
        this.dataAccess.setHeader(0, this.MAGIC_INT);
        this.dataAccess.setHeader(4, this.calcChecksum());
        this.dataAccess.setHeader(8, this.minResolutionInMeter);
        this.dataAccess.flush();
    }

    @Override
    public long getCapacity() {
        return this.dataAccess.getCapacity();
    }

    GHPoint getCenter(double d, double d2) {
        GHPoint gHPoint = new GHPoint(d, d2);
        long l = this.keyAlgo.encode(gHPoint);
        gHPoint = new GHPoint();
        this.keyAlgo.decode(l, gHPoint);
        return gHPoint;
    }

    public double getDeltaLat() {
        return this.deltaLat;
    }

    public double getDeltaLon() {
        return this.deltaLon;
    }

    IntArrayList getEntries() {
        return IntArrayList.from((int[])this.entries);
    }

    public int getMinResolutionInMeter() {
        return this.minResolutionInMeter;
    }

    InMemConstructionIndex getPrepareInMemIndex() {
        InMemConstructionIndex inMemConstructionIndex = new InMemConstructionIndex(this.entries[0]);
        inMemConstructionIndex.prepare();
        return inMemConstructionIndex;
    }

    @Override
    public boolean isClosed() {
        return this.dataAccess.isClosed();
    }

    @Override
    public boolean loadExisting() {
        if (!this.initialized) {
            if (!this.dataAccess.loadExisting()) {
                return false;
            }
            if (this.dataAccess.getHeader(0) == this.MAGIC_INT) {
                if (this.dataAccess.getHeader(4) == this.calcChecksum()) {
                    this.setMinResolutionInMeter(this.dataAccess.getHeader(8));
                    this.prepareAlgo();
                    this.initialized = true;
                    return true;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("location index was opened with incorrect graph: ");
                stringBuilder.append(this.dataAccess.getHeader(4));
                stringBuilder.append(" vs. ");
                stringBuilder.append(this.calcChecksum());
                throw new IllegalStateException(stringBuilder.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("incorrect location index version, expected:");
            stringBuilder.append(this.MAGIC_INT);
            throw new IllegalStateException(stringBuilder.toString());
        }
        throw new IllegalStateException("Call loadExisting only once");
    }

    void prepareAlgo() {
        this.equalNormedDelta = this.distCalc.calcNormalizedDist(0.1);
        BBox bBox = this.graph.getBounds();
        if (this.graph.getNodes() != 0) {
            if (bBox.isValid()) {
                int n;
                double d = Math.min(Math.abs(bBox.maxLat), Math.abs(bBox.minLat));
                d = Math.max((bBox.maxLat - bBox.minLat) / 360.0 * 4.003017359204114E7, (bBox.maxLon - bBox.minLon) / 360.0 * this.preciseDistCalc.calcCircumference(d)) / (double)this.minResolutionInMeter;
                Object object = new IntArrayList();
                d = d * d / 4.0;
                while (true) {
                    n = 64;
                    if (!(d > 1.0)) break;
                    if (!(d >= 64.0)) {
                        if (d >= 16.0) {
                            n = 16;
                        } else {
                            if (!(d >= 4.0)) break;
                            n = 4;
                        }
                    }
                    object.add(n);
                    d /= (double)n;
                }
                object.add(4);
                this.initEntries(object.toArray());
                long l = 1L;
                int n2 = 0;
                for (n = 0; n < ((IntArrayList)(object = (Object)this.shifts)).length; ++n) {
                    n2 += object[n];
                    l *= (long)this.entries[n];
                }
                if (n2 <= 64) {
                    this.keyAlgo = new SpatialKeyAlgo(n2).bounds(bBox);
                    l = Math.round(Math.sqrt(l));
                    d = bBox.maxLat;
                    double d2 = bBox.minLat;
                    double d3 = l;
                    this.deltaLat = (d - d2) / d3;
                    this.deltaLon = (bBox.maxLon - bBox.minLon) / d3;
                    return;
                }
                throw new IllegalStateException("sum of all shifts does not fit into a long variable");
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot create location index when graph has invalid bounds: ");
            stringBuilder.append(bBox);
            throw new IllegalStateException(stringBuilder.toString());
        }
        throw new IllegalStateException("Cannot create location index of empty graph!");
    }

    @Override
    public LocationIndex prepareIndex() {
        if (!this.initialized) {
            StopWatch stopWatch = new StopWatch().start();
            this.prepareAlgo();
            InMemConstructionIndex inMemConstructionIndex = this.getPrepareInMemIndex();
            this.dataAccess.create(65536L);
            try {
                inMemConstructionIndex.store(inMemConstructionIndex.root, 1);
                this.flush();
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Problem while storing location index. ");
                stringBuilder.append(Helper.getMemInfo());
                throw new IllegalStateException(stringBuilder.toString(), exception);
            }
            float f = (float)inMemConstructionIndex.size / (float)inMemConstructionIndex.leafs;
            this.initialized = true;
            Logger logger = this.logger;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("location index created in ");
            stringBuilder.append(stopWatch.stop().getSeconds());
            stringBuilder.append("s, size:");
            stringBuilder.append(Helper.nf(inMemConstructionIndex.size));
            stringBuilder.append(", leafs:");
            stringBuilder.append(Helper.nf(inMemConstructionIndex.leafs));
            stringBuilder.append(", precision:");
            stringBuilder.append(this.minResolutionInMeter);
            stringBuilder.append(", depth:");
            stringBuilder.append(this.entries.length);
            stringBuilder.append(", checksum:");
            stringBuilder.append(this.calcChecksum());
            stringBuilder.append(", entries:");
            stringBuilder.append(Arrays.toString(this.entries));
            stringBuilder.append(", entriesPerLeaf:");
            stringBuilder.append(f);
            logger.info(stringBuilder.toString());
            return this;
        }
        throw new IllegalStateException("Call prepareIndex only once");
    }

    @Override
    public LocationIndex setApproximation(boolean bl) {
        this.distCalc = bl ? Helper.DIST_PLANE : Helper.DIST_EARTH;
        return this;
    }

    public LocationIndexTree setMaxRegionSearch(int n) {
        if (n >= 1) {
            int n2 = n;
            if (n % 2 == 1) {
                n2 = n + 1;
            }
            this.maxRegionSearch = n2;
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Region of location index must be at least 1 but was ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public LocationIndexTree setMinResolutionInMeter(int n) {
        this.minResolutionInMeter = n;
        return this;
    }

    @Override
    public LocationIndex setResolution(int n) {
        if (n > 0) {
            this.setMinResolutionInMeter(n);
            return this;
        }
        throw new IllegalStateException("Negative precision is not allowed!");
    }

    @Override
    public void setSegmentSize(int n) {
        this.dataAccess.setSegmentSize(n);
    }

    class InMemConstructionIndex {
        int leafs;
        InMemTreeEntry root;
        int size;

        public InMemConstructionIndex(int n) {
            this.root = new InMemTreeEntry(n);
        }

        void addNode(final int n, int n2, double d, double d2, double d3, double d4) {
            PointEmitter pointEmitter = new PointEmitter(){

                @Override
                public void set(double d, double d2) {
                    long l = LocationIndexTree.this.keyAlgo.encode(d, d2);
                    long l2 = LocationIndexTree.this.createReverseKey(l);
                    InMemConstructionIndex inMemConstructionIndex = InMemConstructionIndex.this;
                    inMemConstructionIndex.addNode(inMemConstructionIndex.root, n, 0, l2, l);
                }
            };
            if (!LocationIndexTree.this.distCalc.isCrossBoundary(d2, d4)) {
                BresenhamLine.calcPoints(d, d2, d3, d4, pointEmitter, LocationIndexTree.this.graph.getBounds().minLat, LocationIndexTree.this.graph.getBounds().minLon, LocationIndexTree.this.deltaLat, LocationIndexTree.this.deltaLon);
            }
        }

        void addNode(InMemEntry inMemEntry, int n, int n2, long l, long l2) {
            if (inMemEntry.isLeaf()) {
                ((InMemLeafEntry)inMemEntry).addNode(n);
            } else {
                int n3 = (int)(LocationIndexTree.this.bitmasks[n2] & l);
                byte by = LocationIndexTree.this.shifts[n2];
                InMemTreeEntry inMemTreeEntry = (InMemTreeEntry)inMemEntry;
                inMemEntry = inMemTreeEntry.getSubEntry(n3);
                ++n2;
                if (inMemEntry == null) {
                    inMemEntry = n2 == LocationIndexTree.this.entries.length ? new InMemLeafEntry(LocationIndexTree.this.initSizeLeafEntries, l2) : new InMemTreeEntry(LocationIndexTree.this.entries[n2]);
                    inMemTreeEntry.setSubEntry(n3, inMemEntry);
                }
                this.addNode(inMemEntry, n, n2, l >>> by, l2);
            }
        }

        void fillLayer(Collection<InMemEntry> collection, int n, int n2, Collection<InMemEntry> object) {
            Iterator<InMemEntry> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (n == n2) {
                    collection.add((InMemEntry)object);
                    continue;
                }
                if (!(object instanceof InMemTreeEntry)) continue;
                this.fillLayer(collection, n, n2 + 1, ((InMemTreeEntry)object).getSubEntriesForDebug());
            }
        }

        Collection<InMemEntry> getEntriesOf(int n) {
            ArrayList<InMemEntry> arrayList = new ArrayList<InMemEntry>();
            this.fillLayer(arrayList, n, 0, this.root.getSubEntriesForDebug());
            return arrayList;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void prepare() {
            AllEdgesIterator allEdgesIterator = LocationIndexTree.this.graph.getAllEdges();
            while (true) {
                Object object;
                double d2;
                double d;
                int n2;
                int n;
                try {
                    if (!allEdgesIterator.next()) return;
                    n = allEdgesIterator.getBaseNode();
                    n2 = allEdgesIterator.getAdjNode();
                    d = LocationIndexTree.this.nodeAccess.getLatitude(n);
                    d2 = LocationIndexTree.this.nodeAccess.getLongitude(n);
                    object = allEdgesIterator.fetchWayGeometry(0);
                    int n3 = ((PointList)object).getSize();
                    for (int i = 0; i < n3; ++i) {
                        double d3 = ((PointList)object).getLatitude(i);
                        double d4 = ((PointList)object).getLongitude(i);
                        this.addNode(n, n2, d, d2, d3, d4);
                        d = d3;
                        d2 = d4;
                    }
                }
                catch (Exception exception) {
                    Logger logger = LocationIndexTree.this.logger;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Problem! base:");
                    ((StringBuilder)object).append(allEdgesIterator.getBaseNode());
                    ((StringBuilder)object).append(", adj:");
                    ((StringBuilder)object).append(allEdgesIterator.getAdjNode());
                    ((StringBuilder)object).append(", edge:");
                    ((StringBuilder)object).append(allEdgesIterator.getEdge());
                    logger.error(((StringBuilder)object).toString(), (Throwable)exception);
                    return;
                }
                {
                    this.addNode(n, n2, d, d2, LocationIndexTree.this.nodeAccess.getLatitude(n2), LocationIndexTree.this.nodeAccess.getLongitude(n2));
                    continue;
                }
                break;
            }
        }

        String print() {
            StringBuilder stringBuilder = new StringBuilder();
            this.print(this.root, stringBuilder, 0L, 0);
            return stringBuilder.toString();
        }

        void print(InMemEntry inMemEntry, StringBuilder stringBuilder, long l, int n) {
            boolean bl = inMemEntry.isLeaf();
            int n2 = 0;
            int n3 = 0;
            if (bl) {
                InMemLeafEntry inMemLeafEntry = (InMemLeafEntry)inMemEntry;
                n = LocationIndexTree.this.keyAlgo.getBits();
                stringBuilder.append(BitUtil.BIG.toBitString(BitUtil.BIG.reverse(l, n), n));
                stringBuilder.append("  ");
                inMemEntry = inMemLeafEntry.getResults();
                for (n = n3; n < inMemEntry.size(); ++n) {
                    stringBuilder.append(inMemLeafEntry.get(n));
                    stringBuilder.append(',');
                }
                stringBuilder.append('\n');
            } else {
                inMemEntry = (InMemTreeEntry)inMemEntry;
                byte by = LocationIndexTree.this.shifts[n];
                for (n3 = n2; n3 < ((InMemTreeEntry)inMemEntry).subEntries.length; ++n3) {
                    InMemEntry inMemEntry2 = ((InMemTreeEntry)inMemEntry).subEntries[n3];
                    if (inMemEntry2 == null) continue;
                    this.print(inMemEntry2, stringBuilder, l << by | (long)n3, n + 1);
                }
            }
        }

        int store(InMemEntry inMemEntry, int n) {
            int n2;
            long l = (long)n * 4L;
            boolean bl = inMemEntry.isLeaf();
            int n3 = 0;
            if (bl) {
                int n4 = (inMemEntry = ((InMemLeafEntry)inMemEntry).getResults()).size();
                if (n4 == 0) {
                    return n;
                }
                this.size += n4;
                n2 = n + 1;
                ++this.leafs;
                LocationIndexTree.this.dataAccess.ensureCapacity((long)(n2 + n4 + 1) * 4L);
                n = n2;
                if (n4 == 1) {
                    LocationIndexTree.this.dataAccess.setInt(l, -inMemEntry.get(0) - 1);
                } else {
                    while (n3 < n4) {
                        LocationIndexTree.this.dataAccess.setInt((long)n * 4L, inMemEntry.get(n3));
                        ++n3;
                        ++n;
                    }
                    LocationIndexTree.this.dataAccess.setInt(l, n);
                    n2 = n;
                }
            } else {
                InMemTreeEntry inMemTreeEntry = (InMemTreeEntry)inMemEntry;
                int n5 = inMemTreeEntry.subEntries.length;
                n += n5;
                n3 = 0;
                while (true) {
                    n2 = n;
                    if (n3 >= n5) break;
                    inMemEntry = inMemTreeEntry.subEntries[n3];
                    if (inMemEntry != null) {
                        LocationIndexTree.this.dataAccess.ensureCapacity((long)(n + 1) * 4L);
                        n2 = this.store(inMemEntry, n);
                        if (n2 == n) {
                            LocationIndexTree.this.dataAccess.setInt(l, 0);
                        } else {
                            LocationIndexTree.this.dataAccess.setInt(l, n);
                        }
                        n = n2;
                    }
                    ++n3;
                    l += 4L;
                }
            }
            return n2;
        }
    }

    static interface InMemEntry {
        public boolean isLeaf();
    }

    static class InMemLeafEntry
    extends SortedIntSet
    implements InMemEntry {
        public InMemLeafEntry(int n, long l) {
            super(n);
        }

        public boolean addNode(int n) {
            return this.addOnce(n);
        }

        IntArrayList getResults() {
            return this;
        }

        @Override
        public final boolean isLeaf() {
            return true;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("LEAF  ");
            stringBuilder.append(super.toString());
            return stringBuilder.toString();
        }
    }

    static class InMemTreeEntry
    implements InMemEntry {
        InMemEntry[] subEntries;

        public InMemTreeEntry(int n) {
            this.subEntries = new InMemEntry[n];
        }

        public Collection<InMemEntry> getSubEntriesForDebug() {
            ArrayList<InMemEntry> arrayList = new ArrayList<InMemEntry>();
            for (InMemEntry inMemEntry : this.subEntries) {
                if (inMemEntry == null) continue;
                arrayList.add(inMemEntry);
            }
            return arrayList;
        }

        public InMemEntry getSubEntry(int n) {
            return this.subEntries[n];
        }

        @Override
        public final boolean isLeaf() {
            return false;
        }

        public void setSubEntry(int n, InMemEntry inMemEntry) {
            this.subEntries[n] = inMemEntry;
        }

        public String toString() {
            return "TREE";
        }
    }

    static class SortedIntSet
    extends IntArrayList {
        public SortedIntSet() {
        }

        public SortedIntSet(int n) {
            super(n);
        }

        public boolean addOnce(int n) {
            int n2 = Arrays.binarySearch(this.buffer, 0, this.size(), n);
            if (n2 >= 0) {
                return false;
            }
            this.insert(-n2 - 1, n);
            return true;
        }
    }

    protected abstract class XFirstSearchCheck
    extends BreadthFirstSearch {
        final GHBitSet checkBitset;
        double currLat;
        double currLon;
        int currNode;
        double currNormedDist;
        final EdgeFilter edgeFilter;
        boolean goFurther = true;
        final double queryLat;
        final double queryLon;

        public XFirstSearchCheck(double d, double d2, GHBitSet gHBitSet, EdgeFilter edgeFilter) {
            this.queryLat = d;
            this.queryLon = d2;
            this.checkBitset = gHBitSet;
            this.edgeFilter = edgeFilter;
        }

        protected abstract boolean check(int var1, double var2, int var4, EdgeIteratorState var5, QueryResult.Position var6);

        @Override
        protected boolean checkAdjacent(EdgeIteratorState edgeIteratorState) {
            this.goFurther = false;
            if (!this.edgeFilter.accept(edgeIteratorState)) {
                return true;
            }
            int n = this.currNode;
            if (this.check(n, this.currNormedDist, 0, edgeIteratorState, QueryResult.Position.TOWER) && this.currNormedDist <= LocationIndexTree.this.equalNormedDelta) {
                return false;
            }
            int n2 = edgeIteratorState.getAdjNode();
            double d = LocationIndexTree.this.nodeAccess.getLatitude(n2);
            double d2 = LocationIndexTree.this.nodeAccess.getLongitude(n2);
            if ((d2 = LocationIndexTree.this.distCalc.calcNormalizedDist(d, d2, this.queryLat, this.queryLon)) < this.currNormedDist) {
                n = n2;
            }
            double d3 = this.currLat;
            d = this.currLon;
            PointList pointList = edgeIteratorState.fetchWayGeometry(2);
            int n3 = pointList.getSize();
            for (n2 = 0; n2 < n3; ++n2) {
                double d4 = pointList.getLatitude(n2);
                double d5 = pointList.getLongitude(n2);
                QueryResult.Position position = QueryResult.Position.EDGE;
                if (!LocationIndexTree.this.distCalc.isCrossBoundary(d, d5)) {
                    if (LocationIndexTree.this.distCalc.validEdgeDistance(this.queryLat, this.queryLon, d3, d, d4, d5)) {
                        d = LocationIndexTree.this.distCalc.calcNormalizedEdgeDistance(this.queryLat, this.queryLon, d3, d, d4, d5);
                        this.check(n, d, n2, edgeIteratorState, position);
                    } else {
                        int n4 = n2 + 1;
                        if (n4 == n3) {
                            position = QueryResult.Position.TOWER;
                            d = d2;
                        } else {
                            d = LocationIndexTree.this.distCalc.calcNormalizedDist(this.queryLat, this.queryLon, d4, d5);
                            position = QueryResult.Position.PILLAR;
                        }
                        this.check(n, d, n4, edgeIteratorState, position);
                    }
                    if (d <= LocationIndexTree.this.equalNormedDelta) {
                        return false;
                    }
                }
                d = d5;
                d3 = d4;
            }
            boolean bl = this.getQueryDistance() > LocationIndexTree.this.equalNormedDelta;
            return bl;
        }

        @Override
        protected GHBitSet createBitSet() {
            return this.checkBitset;
        }

        protected abstract double getQueryDistance();

        @Override
        protected boolean goFurther(int n) {
            this.currNode = n;
            this.currLat = LocationIndexTree.this.nodeAccess.getLatitude(n);
            this.currLon = LocationIndexTree.this.nodeAccess.getLongitude(n);
            this.currNormedDist = LocationIndexTree.this.distCalc.calcNormalizedDist(this.queryLat, this.queryLon, this.currLat, this.currLon);
            return this.goFurther;
        }
    }
}

