/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;

public class AngleCalc {
    private static final double PI3_4 = 2.356194490192345;
    private static final double PI_2 = 1.5707963267948966;
    private static final double PI_4 = 0.7853981633974483;

    static final double atan2(double d, double d2) {
        double d3 = Math.abs(d) + 1.0E-10;
        if (d2 < 0.0) {
            d2 = (d2 + d3) / (d3 - d2);
            d3 = 2.356194490192345;
        } else {
            d2 = (d2 - d3) / (d2 + d3);
            d3 = 0.7853981633974483;
        }
        d2 = d3 + (0.1963 * d2 * d2 - 0.9817) * d2;
        if (d < 0.0) {
            return -d2;
        }
        return d2;
    }

    public double alignOrientation(double d, double d2) {
        double d3;
        if (d >= 0.0) {
            d3 = d2;
            if (d2 < d - Math.PI) {
                d3 = d2 + Math.PI * 2;
            }
        } else {
            d3 = d2;
            if (d2 > d + Math.PI) {
                d3 = d2 - Math.PI * 2;
            }
        }
        return d3;
    }

    String azimuth2compassPoint(double d) {
        String string2 = "N";
        if (!(d < 22.5)) {
            if (d < 67.5) {
                string2 = "NE";
            } else if (d < 112.5) {
                string2 = "E";
            } else if (d < 157.5) {
                string2 = "SE";
            } else if (d < 202.5) {
                string2 = "S";
            } else if (d < 247.5) {
                string2 = "SW";
            } else if (d < 292.5) {
                string2 = "W";
            } else if (d < 337.5) {
                string2 = "NW";
            }
        }
        return string2;
    }

    public double calcAzimuth(double d, double d2, double d3, double d4) {
        d = d2 = 1.5707963267948966 - this.calcOrientation(d, d2, d3, d4);
        if (d2 < 0.0) {
            d = d2 + Math.PI * 2;
        }
        return Math.toDegrees(Helper.round4(d)) % 360.0;
    }

    public double calcOrientation(double d, double d2, double d3, double d4) {
        return this.calcOrientation(d, d2, d3, d4, true);
    }

    public double calcOrientation(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = Math.cos(Math.toRadians((d + d3) / 2.0));
        if (bl) {
            return Math.atan2(d3 - d, d5 * (d4 - d2));
        }
        return AngleCalc.atan2(d3 - d, d5 * (d4 - d2));
    }

    public double convertAzimuth2xaxisAngle(double d) {
        if (Double.compare(d, 360.0) <= 0 && Double.compare(d, 0.0) >= 0) {
            double d2;
            d = d2 = 1.5707963267948966 - d / 180.0 * Math.PI;
            if (d2 < -Math.PI) {
                d = d2 + Math.PI * 2;
            }
            d2 = d;
            if (d > Math.PI) {
                d2 = d - Math.PI * 2;
            }
            return d2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Azimuth ");
        stringBuilder.append(d);
        stringBuilder.append(" must be in (0, 360)");
        throw new IllegalArgumentException(stringBuilder.toString());
    }
}

