/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.BitUtilBig;
import com.graphhopper.util.BitUtilLittle;
import java.nio.ByteOrder;

public abstract class BitUtil {
    public static final BitUtil BIG;
    public static final BitUtil LITTLE;

    static {
        LITTLE = new BitUtilLittle();
        BIG = new BitUtilBig();
    }

    public static BitUtil get(ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return BIG;
        }
        return LITTLE;
    }

    public final long combineIntsToLong(int n, int n2) {
        long l = n2;
        return (long)n & 0xFFFFFFFFL | l << 32;
    }

    public abstract byte[] fromBitString(String var1);

    public final long fromBitString2Long(String string2) {
        if (string2.length() <= 64) {
            long l = 0L;
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                long l2;
                l = l2 = l << 1;
                if (string2.charAt(i) == '0') continue;
                l = l2 | 1L;
            }
            return l << 64 - n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Strings needs to fit into a 'long' but length was ");
        stringBuilder.append(string2.length());
        throw new UnsupportedOperationException(stringBuilder.toString());
    }

    public final void fromDouble(byte[] byArray, double d) {
        this.fromDouble(byArray, d, 0);
    }

    public final void fromDouble(byte[] byArray, double d, int n) {
        this.fromLong(byArray, Double.doubleToRawLongBits(d), n);
    }

    public final byte[] fromDouble(double d) {
        byte[] byArray = new byte[8];
        this.fromDouble(byArray, d, 0);
        return byArray;
    }

    public final void fromFloat(byte[] byArray, float f) {
        this.fromFloat(byArray, f, 0);
    }

    public final void fromFloat(byte[] byArray, float f, int n) {
        this.fromInt(byArray, Float.floatToRawIntBits(f), n);
    }

    public final byte[] fromFloat(float f) {
        byte[] byArray = new byte[4];
        this.fromFloat(byArray, f, 0);
        return byArray;
    }

    public final void fromInt(byte[] byArray, int n) {
        this.fromInt(byArray, n, 0);
    }

    public abstract void fromInt(byte[] var1, int var2, int var3);

    public final byte[] fromInt(int n) {
        byte[] byArray = new byte[4];
        this.fromInt(byArray, n, 0);
        return byArray;
    }

    public final void fromLong(byte[] byArray, long l) {
        this.fromLong(byArray, l, 0);
    }

    public abstract void fromLong(byte[] var1, long var2, int var4);

    public final byte[] fromLong(long l) {
        byte[] byArray = new byte[8];
        this.fromLong(byArray, l, 0);
        return byArray;
    }

    public final void fromShort(byte[] byArray, short s) {
        this.fromShort(byArray, s, 0);
    }

    public abstract void fromShort(byte[] var1, short var2, int var3);

    public final byte[] fromShort(short s) {
        byte[] byArray = new byte[4];
        this.fromShort(byArray, s, 0);
        return byArray;
    }

    public final int getIntHigh(long l) {
        return (int)(l >> 32);
    }

    public final int getIntLow(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public final long reverse(long l, int n) {
        long l2 = 0L;
        long l3 = l;
        l = l2;
        while (true) {
            l2 = l;
            if (n <= 0) break;
            l = l << 1 | 1L & l3;
            --n;
            if (l3 == 0L) {
                l2 = l << n;
                break;
            }
            l3 >>>= 1;
        }
        return l2;
    }

    public final long reverseLeft(long l, int n) {
        long l2;
        int n2 = 64 - n;
        long l3 = 1L << n2;
        long l4 = 0L;
        while (true) {
            l2 = l4;
            if (n <= 0) break;
            l2 = l4;
            if ((l & l3) != 0L) {
                l2 = l4 | 1L;
            }
            --n;
            if ((l3 <<= 1) == 0L) {
                l2 <<= n2;
                break;
            }
            l4 = l2 << 1;
        }
        return l2;
    }

    public final String toBitString(long l) {
        return this.toBitString(l, 64);
    }

    public String toBitString(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            if ((Long.MIN_VALUE & l) == 0L) {
                stringBuilder.append('0');
            } else {
                stringBuilder.append('1');
            }
            l <<= 1;
        }
        return stringBuilder.toString();
    }

    public abstract String toBitString(byte[] var1);

    public final double toDouble(byte[] byArray) {
        return this.toDouble(byArray, 0);
    }

    public final double toDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(this.toLong(byArray, n));
    }

    public final float toFloat(byte[] byArray) {
        return this.toFloat(byArray, 0);
    }

    public final float toFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(this.toInt(byArray, n));
    }

    public final int toInt(byte[] byArray) {
        return this.toInt(byArray, 0);
    }

    public abstract int toInt(byte[] var1, int var2);

    public String toLastBitString(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            if ((l & 1L << n - 1) == 0L) {
                stringBuilder.append('0');
            } else {
                stringBuilder.append('1');
            }
            l <<= 1;
        }
        return stringBuilder.toString();
    }

    public abstract long toLong(int var1, int var2);

    public final long toLong(byte[] byArray) {
        return this.toLong(byArray, 0);
    }

    public abstract long toLong(byte[] var1, int var2);

    public final short toShort(byte[] byArray) {
        return this.toShort(byArray, 0);
    }

    public abstract short toShort(byte[] var1, int var2);
}

