/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;

public class DistanceCalcEarth
implements DistanceCalc {
    public static final double C = 4.003017359204114E7;
    public static final double KM_MILE = 1.609344;
    public static final double R = 6371000.0;
    public static final double R_EQ = 6378137.0;

    private double calcShrinkFactor(double d, double d2) {
        return Math.cos(Math.toRadians((d + d2) / 2.0));
    }

    @Override
    public double calcCircumference(double d) {
        return Math.cos(Math.toRadians(d)) * 4.003017359204114E7;
    }

    @Override
    public GHPoint calcCrossingPointToEdge(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.calcShrinkFactor(d3, d5);
        double d8 = d4 * d7;
        d6 = d6 * d7 - d8;
        if ((d5 -= d3) == 0.0) {
            return new GHPoint(d3, d2);
        }
        if (d6 == 0.0) {
            return new GHPoint(d, d4);
        }
        d = ((d2 * d7 - d8) * d6 + (d - d3) * d5) / (d6 * d6 + d5 * d5);
        return new GHPoint(d3 + d * d5, (d8 + d6 * d) / d7);
    }

    @Override
    public double calcDenormalizedDist(double d) {
        return Math.asin(Math.sqrt(d)) * 1.2742E7;
    }

    @Override
    public double calcDist(double d, double d2, double d3, double d4) {
        return Math.asin(Math.sqrt(this.calcNormalizedDist(d, d2, d3, d4))) * 1.2742E7;
    }

    @Override
    public double calcNormalizedDist(double d) {
        d = Math.sin(d / 2.0 / 6371000.0);
        return d * d;
    }

    @Override
    public double calcNormalizedDist(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(Math.toRadians(d3 - d) / 2.0);
        d2 = Math.sin(Math.toRadians(d4 - d2) / 2.0);
        return d5 * d5 + d2 * d2 * Math.cos(Math.toRadians(d)) * Math.cos(Math.toRadians(d3));
    }

    @Override
    public double calcNormalizedEdgeDistance(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.calcNormalizedEdgeDistanceNew(d, d2, d3, d4, d5, d6, false);
    }

    public double calcNormalizedEdgeDistanceNew(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        double d7;
        double d8;
        double d9;
        block2: {
            block3: {
                d9 = this.calcShrinkFactor(d3, d5);
                d8 = d4 * d9;
                d6 = d6 * d9 - d8;
                d7 = d5 - d3;
                d5 = 0.0;
                if (d7 == 0.0) {
                    return this.calcNormalizedDist(d3, d2, d, d2);
                }
                if (d6 == 0.0) {
                    return this.calcNormalizedDist(d, d4, d, d2);
                }
                d4 = ((d2 * d9 - d8) * d6 + (d - d3) * d7) / (d6 * d6 + d7 * d7);
                if (!bl) break block2;
                if (!(d4 > 1.0)) break block3;
                d4 = 1.0;
                break block2;
            }
            if (!(d4 < 0.0)) break block2;
            d4 = d5;
        }
        return this.calcNormalizedDist(d3 + d4 * d7, (d8 + d6 * d4) / d9, d, d2);
    }

    @Override
    public BBox createBBox(double d, double d2, double d3) {
        if (!(d3 <= 0.0)) {
            double d4 = 360.0 / (this.calcCircumference(d) / d3);
            d3 = 360.0 / (4.003017359204114E7 / d3);
            return new BBox(d2 - d4, d2 + d4, d - d3, d + d3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Distance must not be zero or negative! ");
        stringBuilder.append(d3);
        stringBuilder.append(" lat,lon:");
        stringBuilder.append(d);
        stringBuilder.append(",");
        stringBuilder.append(d2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public boolean isCrossBoundary(double d, double d2) {
        boolean bl = Math.abs(d - d2) > 300.0;
        return bl;
    }

    public boolean isDateLineCrossOver(double d, double d2) {
        boolean bl = Math.abs(d - d2) > 180.0;
        return bl;
    }

    @Override
    public GHPoint projectCoordinate(double d, double d2, double d3, double d4) {
        double d5 = Math.toRadians(d);
        d = Math.toRadians(d2);
        d4 = Math.toRadians(d4);
        d2 = Math.asin(Math.sin(d5) * Math.cos(d3 /= 6371000.0) + Math.cos(d5) * Math.sin(d3) * Math.cos(d4));
        d3 = Math.atan2(Math.sin(d4) * Math.sin(d3) * Math.cos(d5), Math.cos(d3) - Math.sin(d5) * Math.sin(d2));
        return new GHPoint(Math.toDegrees(d2), Math.toDegrees((d + d3 + Math.PI * 3) % (Math.PI * 2) - Math.PI));
    }

    public String toString() {
        return "EXACT";
    }

    @Override
    public boolean validEdgeDistance(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = this.calcShrinkFactor(d3, d5);
        boolean bl = ((d2 = d8 * d2) - (d4 *= d8)) * (d7 = (d6 *= d8) - d4) + (d - d3) * (d8 = d5 - d3) > 0.0 && (d6 - d2) * d7 + (d5 - d) * d8 > 0.0;
        return bl;
    }
}

