/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import com.graphhopper.util.ProgressListener;
import com.graphhopper.util.Unzipper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class Downloader {
    private String acceptEncoding = "gzip, deflate";
    private String referrer = "http://graphhopper.com";
    private int timeout = 4000;
    private final String userAgent;

    public Downloader(String string2) {
        this.userAgent = string2;
    }

    public static void main(String[] stringArray) throws IOException {
        new Downloader("GraphHopper Downloader").downloadAndUnzip("http://graphhopper.com/public/maps/0.1/europe_germany_berlin.ghz", "somefolder", new ProgressListener(){

            @Override
            public void update(long l) {
                PrintStream printStream = System.out;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("progress:");
                stringBuilder.append(l);
                printStream.println(stringBuilder.toString());
            }
        });
    }

    public HttpURLConnection createConnection(String object) throws IOException {
        object = (HttpURLConnection)new URL((String)object).openConnection();
        ((URLConnection)object).setDoInput(true);
        ((URLConnection)object).setUseCaches(true);
        ((URLConnection)object).setRequestProperty("Referrer", this.referrer);
        ((URLConnection)object).setRequestProperty("User-Agent", this.userAgent);
        ((URLConnection)object).setRequestProperty("Accept-Encoding", this.acceptEncoding);
        ((URLConnection)object).setReadTimeout(this.timeout);
        ((URLConnection)object).setConnectTimeout(this.timeout);
        return object;
    }

    public void downloadAndUnzip(String object, String string2, final ProgressListener progressListener) throws IOException {
        object = this.createConnection((String)object);
        final int n = ((URLConnection)object).getContentLength();
        object = this.fetch((HttpURLConnection)object, false);
        new Unzipper().unzip((InputStream)object, new File(string2), new ProgressListener(){

            @Override
            public void update(long l) {
                progressListener.update((int)(l * 100L / (long)n));
            }
        });
    }

    public String downloadAsString(String string2, boolean bl) throws IOException {
        return Helper.isToString(this.fetch(this.createConnection(string2), bl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void downloadFile(String object, String object2) throws IOException {
        object = this.fetch(this.createConnection((String)object), false);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((String)object2), 8192);
        object2 = new BufferedInputStream((InputStream)object, 8192);
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = ((InputStream)object2).read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            return;
        }
        finally {
            Helper.close((Closeable)object);
            Helper.close(bufferedOutputStream);
            Helper.close((Closeable)object2);
        }
    }

    public InputStream fetch(String string2) throws IOException {
        return this.fetch(this.createConnection(string2), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream fetch(HttpURLConnection object, boolean bl) throws IOException {
        ((URLConnection)object).connect();
        Object object2 = bl && ((HttpURLConnection)object).getResponseCode() >= 400 && ((HttpURLConnection)object).getErrorStream() != null ? ((HttpURLConnection)object).getErrorStream() : ((URLConnection)object).getInputStream();
        if (object2 == null) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Stream is null. Message:");
            ((StringBuilder)object2).append(((HttpURLConnection)object).getResponseMessage());
            throw new IOException(((StringBuilder)object2).toString());
        }
        try {
            String string2 = ((URLConnection)object).getContentEncoding();
            if (string2 != null && string2.equalsIgnoreCase("gzip")) {
                return new GZIPInputStream((InputStream)object2);
            }
            object = object2;
            if (string2 == null) return object;
            object = object2;
            if (!string2.equalsIgnoreCase("deflate")) return object;
            object = new Inflater(true);
            return new InflaterInputStream((InputStream)object2, (Inflater)object);
        }
        catch (IOException iOException) {
            return object2;
        }
    }

    public Downloader setReferrer(String string2) {
        this.referrer = string2;
        return this;
    }

    public Downloader setTimeout(int n) {
        this.timeout = n;
        return this;
    }
}

