/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.GHRequest;
import com.graphhopper.GraphHopper;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.EdgeExplorer;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineWarmUp {
    private static Logger LOGGER = LoggerFactory.getLogger(EngineWarmUp.class);

    public static void warmUp(GraphHopper graphHopper, int n) {
        GraphHopperStorage graphHopperStorage = graphHopper.getGraphHopperStorage();
        if (graphHopperStorage != null) {
            try {
                if (graphHopperStorage.isCHPossible()) {
                    EngineWarmUp.warmUpCHSubNetwork(graphHopper, n);
                } else {
                    EngineWarmUp.warmUpNonCHSubNetwork(graphHopper, n);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Problem while sending warm up queries", (Throwable)exception);
            }
            return;
        }
        throw new IllegalArgumentException("The storage of GraphHopper must not be empty");
    }

    private static void warmUpCHSubNetwork(GraphHopper graphHopper, int n) {
        GraphHopperStorage graphHopperStorage = graphHopper.getGraphHopperStorage();
        Random random = new Random(0L);
        for (int i = 0; i < n; ++i) {
            int n2 = random.nextInt(graphHopper.getMaxVisitedNodes() + 1);
            int n3 = random.nextInt(graphHopper.getMaxVisitedNodes() + 1);
            graphHopper.route(new GHRequest(graphHopperStorage.getNodeAccess().getLatitude(n2), graphHopperStorage.getNodeAccess().getLongitude(n2), graphHopperStorage.getNodeAccess().getLatitude(n3), graphHopperStorage.getNodeAccess().getLongitude(n3)));
        }
    }

    private static void warmUpNonCHSubNetwork(final GraphHopper graphHopper, int n) {
        GraphHopperStorage graphHopperStorage = graphHopper.getGraphHopperStorage();
        Random random = new Random(0L);
        EdgeExplorer edgeExplorer = graphHopperStorage.getBaseGraph().createEdgeExplorer();
        for (int i = 0; i < n; ++i) {
            new BreadthFirstSearch(){
                int counter = 0;

                @Override
                public boolean goFurther(int n) {
                    n = this.counter;
                    boolean bl = true;
                    this.counter = ++n;
                    if (n >= graphHopper.getMaxVisitedNodes()) {
                        bl = false;
                    }
                    return bl;
                }
            }.start(edgeExplorer, random.nextInt(graphHopperStorage.getBaseGraph().getNodes() + 1));
        }
    }
}

