/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.coll.GHIntArrayList;
import com.graphhopper.routing.util.AllCHEdgesIterator;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.GraphStorage;
import com.graphhopper.storage.MMapDirectory;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.DepthFirstSearch;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class GHUtility {
    public static Set<Integer> asSet(int ... nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            hashSet.add(nArray[i]);
        }
        return hashSet;
    }

    public static Graph copyTo(Graph graph, Graph graph2) {
        Object object = graph.getAllEdges();
        while (object.next()) {
            object.copyPropertiesTo(graph2.edge(object.getBaseNode(), object.getAdjNode()));
        }
        object = graph.getNodeAccess();
        NodeAccess nodeAccess = graph2.getNodeAccess();
        int n = graph.getNodes();
        for (int i = 0; i < n; ++i) {
            if (nodeAccess.is3D()) {
                nodeAccess.setNode(i, object.getLatitude(i), object.getLongitude(i), object.getElevation(i));
                continue;
            }
            nodeAccess.setNode(i, object.getLatitude(i), object.getLongitude(i));
        }
        return graph2;
    }

    public static int count(EdgeIterator edgeIterator) {
        int n = 0;
        while (edgeIterator.next()) {
            ++n;
        }
        return n;
    }

    public static int createEdgeKey(int n, int n2, int n3, boolean bl) {
        n3 <<= 1;
        if (bl) {
            if (n <= n2) {
                ++n3;
            }
            return n3;
        }
        int n4 = n3;
        if (n > n2) {
            n4 = n3 + 1;
        }
        return n4;
    }

    public static EdgeIteratorState createMockedEdgeIteratorState(final double d, final long l) {
        return new DisabledEdgeIterator(){

            @Override
            public boolean getBool(int n, boolean bl) {
                return bl;
            }

            @Override
            public double getDistance() {
                return d;
            }

            @Override
            public long getFlags() {
                return l;
            }
        };
    }

    static Graph createSortedGraph(Graph object, Graph graph, IntIndexedContainer intIndexedContainer) {
        int n;
        int n2;
        Object object2 = object.getAllEdges();
        while (object2.next()) {
            n2 = intIndexedContainer.get(object2.getBaseNode());
            n = intIndexedContainer.get(object2.getAdjNode());
            if (n2 < 0 || n < 0) continue;
            object2.copyPropertiesTo(graph.edge(n2, n));
        }
        n2 = object.getNodes();
        object = object.getNodeAccess();
        object2 = graph.getNodeAccess();
        for (n = 0; n < n2; ++n) {
            int n3 = intIndexedContainer.get(n);
            if (object2.is3D()) {
                object2.setNode(n3, object.getLatitude(n), object.getLongitude(n), object.getElevation(n));
                continue;
            }
            object2.setNode(n3, object.getLatitude(n), object.getLongitude(n));
        }
        return graph;
    }

    public static int getAdjNode(Graph graph, int n, int n2) {
        if (EdgeIterator.Edge.isValid(n)) {
            return graph.getEdgeIteratorState(n, n2).getAdjNode();
        }
        return n2;
    }

    public static EdgeIteratorState getEdge(Graph object, int n, int n2) {
        object = object.createEdgeExplorer().setBaseNode(n);
        while (object.next()) {
            if (object.getAdjNode() != n2) continue;
            return object;
        }
        return null;
    }

    public static int getEdgeFromEdgeKey(int n) {
        return n / 2;
    }

    public static List<Integer> getEdgeIds(EdgeIterator edgeIterator) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (edgeIterator.next()) {
            arrayList.add(edgeIterator.getEdge());
        }
        return arrayList;
    }

    public static Set<Integer> getNeighbors(EdgeIterator edgeIterator) {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        while (edgeIterator.next()) {
            linkedHashSet.add(edgeIterator.getAdjNode());
        }
        return linkedHashSet;
    }

    public static String getNodeInfo(CHGraph object, int n, EdgeFilter object2) {
        object2 = object.createEdgeExplorer((EdgeFilter)object2).setBaseNode(n);
        Object object3 = object.getNodeAccess();
        object = new StringBuilder();
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(":");
        ((StringBuilder)object).append(object3.getLatitude(n));
        ((StringBuilder)object).append(",");
        ((StringBuilder)object).append(object3.getLongitude(n));
        ((StringBuilder)object).append("\n");
        object = ((StringBuilder)object).toString();
        while (object2.next()) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object);
            ((StringBuilder)object3).append("  ->");
            ((StringBuilder)object3).append(object2.getAdjNode());
            ((StringBuilder)object3).append("(");
            ((StringBuilder)object3).append(object2.getSkippedEdge1());
            ((StringBuilder)object3).append(",");
            ((StringBuilder)object3).append(object2.getSkippedEdge2());
            ((StringBuilder)object3).append(") ");
            ((StringBuilder)object3).append(object2.getEdge());
            ((StringBuilder)object3).append(" \t");
            ((StringBuilder)object3).append(BitUtil.BIG.toBitString(object2.getFlags(), 8));
            ((StringBuilder)object3).append("\n");
            object = ((StringBuilder)object3).toString();
        }
        return object;
    }

    public static String getNodeInfo(Graph object, int n, EdgeFilter object2) {
        object2 = object.createEdgeExplorer((EdgeFilter)object2).setBaseNode(n);
        Object object3 = object.getNodeAccess();
        object = new StringBuilder();
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(":");
        ((StringBuilder)object).append(object3.getLatitude(n));
        ((StringBuilder)object).append(",");
        ((StringBuilder)object).append(object3.getLongitude(n));
        ((StringBuilder)object).append("\n");
        object = ((StringBuilder)object).toString();
        while (object2.next()) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object);
            ((StringBuilder)object3).append("  ->");
            ((StringBuilder)object3).append(object2.getAdjNode());
            ((StringBuilder)object3).append(" (");
            ((StringBuilder)object3).append(object2.getDistance());
            ((StringBuilder)object3).append(") pillars:");
            ((StringBuilder)object3).append(object2.fetchWayGeometry(0).getSize());
            ((StringBuilder)object3).append(", edgeId:");
            ((StringBuilder)object3).append(object2.getEdge());
            ((StringBuilder)object3).append("\t");
            ((StringBuilder)object3).append(BitUtil.BIG.toBitString(object2.getFlags(), 8));
            ((StringBuilder)object3).append("\n");
            object = ((StringBuilder)object3).toString();
        }
        return object;
    }

    public static List<String> getProblems(Graph object) {
        ArrayList<String> arrayList = new ArrayList();
        int n = object.getNodes();
        NodeAccess nodeAccess = object.getNodeAccess();
        int n2 = 0;
        int n3 = 0;
        try {
            object = object.createEdgeExplorer();
        }
        catch (Exception exception) {
            arrayList = new StringBuilder();
            ((StringBuilder)((Object)arrayList)).append("problem with node ");
            ((StringBuilder)((Object)arrayList)).append(n2);
            throw new RuntimeException(((StringBuilder)((Object)arrayList)).toString(), exception);
        }
        while (n3 < n) {
            Object object2;
            n2 = n3;
            double d = nodeAccess.getLatitude(n3);
            if (d > 90.0 || d < -90.0) {
                n2 = n3;
                n2 = n3;
                object2 = new StringBuilder();
                n2 = n3;
                ((StringBuilder)object2).append("latitude is not within its bounds ");
                n2 = n3;
                ((StringBuilder)object2).append(d);
                n2 = n3;
                arrayList.add(((StringBuilder)object2).toString());
            }
            n2 = n3;
            d = nodeAccess.getLongitude(n3);
            if (d > 180.0 || d < -180.0) {
                n2 = n3;
                n2 = n3;
                object2 = new StringBuilder();
                n2 = n3;
                ((StringBuilder)object2).append("longitude is not within its bounds ");
                n2 = n3;
                ((StringBuilder)object2).append(d);
                n2 = n3;
                arrayList.add(((StringBuilder)object2).toString());
            }
            n2 = n3;
            object2 = object.setBaseNode(n3);
            while (true) {
                StringBuilder stringBuilder;
                block37: {
                    n2 = n3++;
                    if (!object2.next()) break;
                    n2 = n3;
                    int n4 = object2.getAdjNode();
                    if (n4 < n) break block37;
                    n2 = n3;
                    n2 = n3;
                    stringBuilder = new StringBuilder();
                    n2 = n3;
                    stringBuilder.append("edge of ");
                    n2 = n3;
                    stringBuilder.append(n3);
                    n2 = n3;
                    stringBuilder.append(" has a node ");
                    n2 = n3;
                    stringBuilder.append(object2.getAdjNode());
                    n2 = n3;
                    stringBuilder.append(" greater or equal to getNodes");
                    n2 = n3;
                    arrayList.add(stringBuilder.toString());
                }
                n2 = n3;
                if (object2.getAdjNode() >= 0) continue;
                n2 = n3;
                n2 = n3;
                stringBuilder = new StringBuilder();
                n2 = n3;
                stringBuilder.append("edge of ");
                n2 = n3;
                stringBuilder.append(n3);
                n2 = n3;
                stringBuilder.append(" has a negative node ");
                n2 = n3;
                stringBuilder.append(object2.getAdjNode());
                n2 = n3;
                arrayList.add(stringBuilder.toString());
                continue;
                break;
            }
        }
        return arrayList;
    }

    static Directory guessDirectory(GraphStorage graphStorage) {
        if (!(graphStorage.getDirectory() instanceof MMapDirectory)) {
            return new RAMDirectory(graphStorage.getDirectory().getLocation(), ((GHDirectory)graphStorage.getDirectory()).isStoring());
        }
        throw new IllegalStateException("not supported yet: mmap will overwrite existing storage at the same location");
    }

    public static boolean isSameEdgeKeys(int n, int n2) {
        boolean bl = n / 2 == n2 / 2;
        return bl;
    }

    public static GraphHopperStorage newStorage(GraphHopperStorage graphHopperStorage) {
        Directory directory = GHUtility.guessDirectory(graphHopperStorage);
        boolean bl = graphHopperStorage.getNodeAccess().is3D();
        return new GraphHopperStorage(graphHopperStorage.getCHWeightings(), directory, graphHopperStorage.getEncodingManager(), bl, graphHopperStorage.getExtension()).create(graphHopperStorage.getNodes());
    }

    public static void printEdgeInfo(Graph object, FlagEncoder flagEncoder) {
        Object object2 = System.out;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("-- Graph nodes:");
        charSequence.append(object.getNodes());
        charSequence.append(" edges:");
        charSequence.append(object.getAllEdges().length());
        charSequence.append(" ---");
        ((PrintStream)object2).println(charSequence.toString());
        AllEdgesIterator allEdgesIterator = object.getAllEdges();
        while (allEdgesIterator.next()) {
            object = allEdgesIterator instanceof AllCHEdgesIterator && ((AllCHEdgesIterator)allEdgesIterator).isShortcut() ? "sc" : "  ";
            boolean bl = allEdgesIterator.isForward(flagEncoder);
            object2 = "   ";
            charSequence = bl ? "fwd" : "   ";
            if (allEdgesIterator.isBackward(flagEncoder)) {
                object2 = "bwd";
            }
            PrintStream printStream = System.out;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)object);
            stringBuilder.append(" ");
            stringBuilder.append(allEdgesIterator);
            stringBuilder.append(" ");
            stringBuilder.append((String)charSequence);
            stringBuilder.append(" ");
            stringBuilder.append((String)object2);
            stringBuilder.append(" ");
            stringBuilder.append(allEdgesIterator.getDistance());
            printStream.println(stringBuilder.toString());
        }
    }

    public static void printGraphForUnitTest(Graph graph, FlagEncoder flagEncoder) {
        GHUtility.printGraphForUnitTest(graph, flagEncoder, new BBox(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    public static void printGraphForUnitTest(Graph object, FlagEncoder flagEncoder, BBox bBox) {
        NodeAccess nodeAccess = object.getNodeAccess();
        for (int i = 0; i < object.getNodes(); ++i) {
            if (!bBox.contains(nodeAccess.getLat(i), nodeAccess.getLon(i))) continue;
            System.out.printf(Locale.ROOT, "na.setNode(%d, %f, %f);\n", i, nodeAccess.getLat(i), nodeAccess.getLon(i));
        }
        object = object.getAllEdges();
        while (object.next()) {
            if (!bBox.contains(nodeAccess.getLat(object.getBaseNode()), nodeAccess.getLon(object.getBaseNode())) || !bBox.contains(nodeAccess.getLat(object.getAdjNode()), nodeAccess.getLon(object.getAdjNode()))) continue;
            GHUtility.printUnitTestEdge(flagEncoder, (EdgeIteratorState)object);
        }
    }

    public static void printInfo(final Graph graph, int n, final int n2, final EdgeFilter edgeFilter) {
        new BreadthFirstSearch(){
            int counter = 0;

            @Override
            protected boolean goFurther(int n) {
                System.out.println(GHUtility.getNodeInfo(graph, n, edgeFilter));
                n = this.counter;
                this.counter = n + 1;
                boolean bl = n <= n2;
                return bl;
            }
        }.start(graph.createEdgeExplorer(), n);
    }

    private static void printUnitTestEdge(FlagEncoder object, EdgeIteratorState edgeIteratorState) {
        boolean bl = edgeIteratorState.isForward((FlagEncoder)object);
        boolean bl2 = edgeIteratorState.isBackward((FlagEncoder)object);
        if (!bl && !bl2) {
            return;
        }
        int n = bl ? edgeIteratorState.getBaseNode() : edgeIteratorState.getAdjNode();
        int n2 = bl ? edgeIteratorState.getAdjNode() : edgeIteratorState.getBaseNode();
        PrintStream printStream = System.out;
        Locale locale = Locale.ROOT;
        double d = edgeIteratorState.getDistance();
        object = bl && bl2 ? "true" : "false";
        printStream.printf(locale, "graph.edge(%d, %d, %f, %s);\n", n, n2, d, object);
    }

    public static int reverseEdgeKey(int n) {
        n = n % 2 == 0 ? ++n : --n;
        return n;
    }

    public static Graph shuffle(Graph graph, Graph graph2) {
        int n = graph.getNodes();
        GHIntArrayList gHIntArrayList = new GHIntArrayList(n);
        gHIntArrayList.fill(n, -1);
        for (int i = 0; i < n; ++i) {
            gHIntArrayList.set(i, i);
        }
        gHIntArrayList.shuffle(new Random());
        return GHUtility.createSortedGraph(graph, graph2, (IntIndexedContainer)gHIntArrayList);
    }

    public static Graph sortDFS(Graph graph, Graph graph2) {
        int n = graph.getNodes();
        final GHIntArrayList gHIntArrayList = new GHIntArrayList(n);
        gHIntArrayList.fill(n, -1);
        final GHBitSetImpl gHBitSetImpl = new GHBitSetImpl(n);
        final AtomicInteger atomicInteger = new AtomicInteger(-1);
        EdgeExplorer edgeExplorer = graph.createEdgeExplorer();
        int n2 = 0;
        while (n2 >= 0 && n2 < n) {
            new DepthFirstSearch(){

                @Override
                protected GHBitSet createBitSet() {
                    return gHBitSetImpl;
                }

                @Override
                protected boolean goFurther(int n) {
                    gHIntArrayList.set(n, atomicInteger.incrementAndGet());
                    return super.goFurther(n);
                }
            }.start(edgeExplorer, n2);
            n2 = gHBitSetImpl.nextClear(n2 + 1);
        }
        return GHUtility.createSortedGraph(graph, graph2, (IntIndexedContainer)gHIntArrayList);
    }

    public static class DisabledEdgeIterator
    implements CHEdgeIterator {
        @Override
        public EdgeIteratorState copyPropertiesTo(EdgeIteratorState edgeIteratorState) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIterator detach(boolean bl) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public PointList fetchWayGeometry(int n) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getAdditionalField() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getAdjNode() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getBaseNode() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public boolean getBool(int n, boolean bl) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public double getDistance() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getEdge() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public long getFlags() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getMergeStatus(long l) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getSkippedEdge1() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getSkippedEdge2() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public double getWeight() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public boolean isBackward(FlagEncoder flagEncoder) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public boolean isForward(FlagEncoder flagEncoder) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public boolean isShortcut() {
            return false;
        }

        @Override
        public boolean next() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setAdditionalField(int n) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setDistance(double d) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setFlags(long l) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setName(String string2) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public void setSkippedEdges(int n, int n2) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setWayGeometry(PointList pointList) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public CHEdgeIteratorState setWeight(double d) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }
    }
}

