/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MiniPerfTest {
    private int counts = 100;
    private int dummySum;
    private double fullTime = 0.0;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private double max;
    private double min = Double.MAX_VALUE;

    public abstract int doCalc(boolean var1, int var2);

    public double getMax() {
        return this.max / 1000000.0;
    }

    public double getMean() {
        return this.getSum() / (double)this.counts;
    }

    public double getMin() {
        return this.min / 1000000.0;
    }

    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sum:");
        stringBuilder.append(this.nf(this.getSum() / 1000.0));
        stringBuilder.append("s, time/call:");
        stringBuilder.append(this.nf(this.getMean() / 1000.0));
        stringBuilder.append("s");
        return stringBuilder.toString();
    }

    public double getSum() {
        return this.fullTime / 1000000.0;
    }

    public String nf(Number number) {
        return new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.ROOT)).format(number);
    }

    public MiniPerfTest setIterations(int n) {
        this.counts = n;
        return this;
    }

    public MiniPerfTest start() {
        int n;
        int n2 = Math.max(1, this.counts / 3);
        for (n = 0; n < n2; ++n) {
            this.dummySum += this.doCalc(true, n);
        }
        long l = System.nanoTime();
        for (n = 0; n < this.counts; ++n) {
            long l2 = System.nanoTime();
            this.dummySum += this.doCalc(false, n);
            double d = System.nanoTime() - l2;
            if (d < this.min) {
                this.min = d;
            }
            if (!(d > this.max)) continue;
            this.max = d;
        }
        this.fullTime = System.nanoTime() - l;
        Logger logger = this.logger;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("dummySum:");
        stringBuilder.append(this.dummySum);
        logger.info(stringBuilder.toString());
        return this;
    }
}

