/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.PathWrapper;
import com.graphhopper.routing.Path;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PathSimplification;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import com.graphhopper.util.ViaInstruction;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PathMerger {
    private static final DouglasPeucker DP = new DouglasPeucker();
    private boolean calcPoints = true;
    private DouglasPeucker douglasPeucker = DP;
    private boolean enableInstructions = true;
    private double favoredHeading;
    private PathDetailsBuilderFactory pathBuilderFactory;
    private List<String> requestedPathDetails = Collections.EMPTY_LIST;
    private boolean simplifyResponse = true;

    public PathMerger() {
        this.favoredHeading = Double.NaN;
    }

    private void calcAscendDescend(PathWrapper pathWrapper, PointList pointList) {
        double d = pointList.getElevation(0);
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 1; i < pointList.size(); ++i) {
            double d4 = pointList.getElevation(i);
            double d5 = Math.abs(d4 - d);
            if (d4 > d) {
                d2 += d5;
            } else {
                d3 += d5;
            }
            d = d4;
        }
        pathWrapper.setAscend(d2);
        pathWrapper.setDescend(d3);
    }

    private InstructionList updateInstructionsWithContext(InstructionList instructionList) {
        for (int i = 0; i < instructionList.size() - 1; ++i) {
            Instruction instruction;
            double d;
            Instruction instruction2 = instructionList.get(i);
            if (i == 0 && !Double.isNaN(this.favoredHeading) && instruction2.extraInfo.containsKey("heading") && (d = Math.abs((Double)instruction2.extraInfo.get("heading") - this.favoredHeading) % 360.0) > 170.0 && d < 190.0) {
                instruction2.setSign(-98);
            }
            if (instruction2.getSign() != 5 || (instruction = instructionList.get(i + 1)).getSign() != 0 || !instruction2.extraInfo.containsKey("last_heading") || !instruction.extraInfo.containsKey("heading") || !((d = Math.abs((Double)instruction2.extraInfo.get("last_heading") - (Double)instruction.extraInfo.get("heading")) % 360.0) > 179.0) || !(d < 181.0)) continue;
            instruction.setSign(-98);
        }
        return instructionList;
    }

    public void doWork(PathWrapper pathWrapper, List<Path> object, Translation translation) {
        InstructionList instructionList = new InstructionList(translation);
        Iterable<GHPoint3D> iterable = PointList.EMPTY;
        ArrayList<String> arrayList = new ArrayList<String>();
        double d = 0.0;
        long l = 0L;
        int n = 0;
        int n2 = 1;
        double d2 = 0.0;
        for (int i = 0; i < object.size(); ++i) {
            int n3;
            block14: {
                Object object2;
                Path path;
                block16: {
                    block15: {
                        block13: {
                            path = object.get(i);
                            if (path.isFound()) break block13;
                            n2 = 0;
                            n3 = n;
                            break block14;
                        }
                        arrayList.addAll(path.getDescription());
                        l += path.getTime();
                        d += path.getDistance();
                        d2 += path.getWeight();
                        if (this.enableInstructions && !((AbstractCollection)(object2 = path.calcInstructions(translation))).isEmpty()) {
                            instructionList.addAll(object2);
                            n3 = i + 1;
                            if (n3 < object.size()) {
                                object2 = new ViaInstruction(instructionList.get(instructionList.size() - 1));
                                ((ViaInstruction)object2).setViaCount(n3);
                                instructionList.replaceLast((Instruction)object2);
                            }
                        }
                        if (this.calcPoints) break block15;
                        object2 = iterable;
                        n3 = n;
                        if (!this.enableInstructions) break block16;
                    }
                    PointList pointList = path.calcPoints();
                    object2 = iterable;
                    if (iterable.isEmpty()) {
                        object2 = new PointList(pointList.size(), pointList.is3D());
                    }
                    if (i + 1 < object.size()) {
                        pointList.removeLastPoint();
                    }
                    ((PointList)object2).add(pointList);
                    pathWrapper.addPathDetails(path.calcDetails(this.requestedPathDetails, this.pathBuilderFactory, n));
                    n3 = ((PointList)object2).size();
                }
                n = n2 != 0 && path.isFound() ? 1 : 0;
                n2 = n;
                iterable = object2;
            }
            n = n3;
        }
        if (!iterable.isEmpty()) {
            object = new StringBuilder();
            ((StringBuilder)object).append(pathWrapper.getDebugInfo());
            ((StringBuilder)object).append(", simplify (");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append("->");
            ((StringBuilder)object).append(iterable.getSize());
            ((StringBuilder)object).append(")");
            pathWrapper.addDebugInfo(((StringBuilder)object).toString());
            if (iterable.is3D) {
                this.calcAscendDescend(pathWrapper, (PointList)iterable);
            }
        }
        if (this.enableInstructions) {
            pathWrapper.setInstructions(this.updateInstructionsWithContext(instructionList));
        }
        if (n2 == 0) {
            pathWrapper.addError(new ConnectionNotFoundException("Connection between locations not found", Collections.<String, Object>emptyMap()));
        }
        pathWrapper.setDescription(arrayList).setPoints((PointList)iterable).setRouteWeight(d2).setDistance(d).setTime(l);
        if (n2 != 0 && this.simplifyResponse && (this.calcPoints || this.enableInstructions)) {
            new PathSimplification(pathWrapper, this.douglasPeucker, this.enableInstructions).simplify();
        }
    }

    public PathMerger setCalcPoints(boolean bl) {
        this.calcPoints = bl;
        return this;
    }

    public PathMerger setDouglasPeucker(DouglasPeucker douglasPeucker) {
        this.douglasPeucker = douglasPeucker;
        return this;
    }

    public PathMerger setEnableInstructions(boolean bl) {
        this.enableInstructions = bl;
        return this;
    }

    public void setFavoredHeading(double d) {
        this.favoredHeading = d;
    }

    public PathMerger setPathDetailsBuilders(PathDetailsBuilderFactory pathDetailsBuilderFactory, List<String> list) {
        this.pathBuilderFactory = pathDetailsBuilderFactory;
        this.requestedPathDetails = list;
        return this;
    }

    public PathMerger setSimplifyResponse(boolean bl) {
        this.simplifyResponse = bl;
        return this;
    }
}

