/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalc3D;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.ShallowImmutablePointList;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PointList
implements Iterable<GHPoint3D>,
PointAccess {
    private static final double DEFAULT_PRECISION = 1.0E-6;
    public static final PointList EMPTY = new PointList(0, true){

        @Override
        public void add(double d, double d2, double d3) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public double calcDistance(DistanceCalc distanceCalc) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public void clear() {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public PointList clone(boolean bl) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public PointList copy(int n, int n2) {
            throw new RuntimeException("cannot copy EMPTY PointList");
        }

        @Override
        public double getEle(int n) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public double getElevation(int n) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public double getLat(int n) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public double getLatitude(int n) {
            throw new RuntimeException("cannot access EMPTY PointList");
        }

        @Override
        public double getLon(int n) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public double getLongitude(int n) {
            throw new RuntimeException("cannot access EMPTY PointList");
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public boolean is3D() {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void parse2DJSON(String string2) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public void removeLastPoint() {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public void reverse() {
            throw new UnsupportedOperationException("cannot change EMPTY PointList");
        }

        @Override
        public void set(int n, double d, double d2, double d3) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public void setElevation(int n, double d) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public GHPoint3D toGHPoint(int n) {
            throw new UnsupportedOperationException("cannot access EMPTY PointList");
        }

        @Override
        public void trimToSize(int n) {
            throw new RuntimeException("cannot change EMPTY PointList");
        }
    };
    static final String ERR_MSG = "Tried to access PointList with too big index!";
    private static final DistanceCalc3D distCalc3D = new DistanceCalc3D();
    private double[] elevations;
    protected boolean is3D;
    private boolean isImmutable = false;
    private double[] latitudes;
    private double[] longitudes;
    protected int size = 0;

    public PointList() {
        this(10, false);
    }

    public PointList(int n, boolean bl) {
        this.latitudes = new double[n];
        this.longitudes = new double[n];
        this.is3D = bl;
        if (bl) {
            this.elevations = new double[n];
        }
    }

    private void ensureMutability() {
        if (!this.isImmutable()) {
            return;
        }
        throw new IllegalStateException("You cannot change an immutable PointList");
    }

    public static boolean equalsEps(double d, double d2) {
        return PointList.equalsEps(d, d2, 1.0E-6);
    }

    public static boolean equalsEps(double d, double d2, double d3) {
        boolean bl = Math.abs(d - d2) < d3;
        return bl;
    }

    public static PointList from(LineString coordinateArray) {
        PointList pointList = new PointList();
        for (Coordinate coordinate : coordinateArray.getCoordinates()) {
            pointList.add(new GHPoint(coordinate.y, coordinate.x));
        }
        return pointList;
    }

    public static PointList fromLineString(LineString cloneable2) {
        PointList pointList = new PointList();
        for (Coordinate coordinate : ((LineString)cloneable2).getCoordinates()) {
            pointList.add(new GHPoint(coordinate.y, coordinate.x));
        }
        return pointList;
    }

    private void incCap(int n) {
        int n2;
        double[] dArray = this.latitudes;
        if (n <= dArray.length) {
            return;
        }
        n = n2 = n * 2;
        if (n2 < 15) {
            n = 15;
        }
        this.latitudes = Arrays.copyOf(dArray, n);
        this.longitudes = Arrays.copyOf(this.longitudes, n);
        if (this.is3D) {
            this.elevations = Arrays.copyOf(this.elevations, n);
        }
    }

    public static final double round2(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public static final double round6(double d) {
        return (double)Math.round(d * 1000000.0) / 1000000.0;
    }

    public void add(double d, double d2) {
        if (!this.is3D) {
            this.add(d, d2, Double.NaN);
            return;
        }
        throw new IllegalStateException("Cannot add point without elevation data in 3D mode");
    }

    public void add(double d, double d2, double d3) {
        Object object;
        block4: {
            int n;
            block3: {
                block2: {
                    this.ensureMutability();
                    n = this.size + 1;
                    this.incCap(n);
                    object = this.latitudes;
                    int n2 = this.size;
                    object[n2] = d;
                    this.longitudes[n2] = d2;
                    if (!this.is3D) break block2;
                    this.elevations[n2] = d3;
                    break block3;
                }
                if (!Double.isNaN(d3)) break block4;
            }
            this.size = n;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("This is a 2D list we cannot store elevation: ");
        ((StringBuilder)object).append(d3);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public void add(PointAccess pointAccess, int n) {
        if (this.is3D) {
            this.add(pointAccess.getLatitude(n), pointAccess.getLongitude(n), pointAccess.getElevation(n));
        } else {
            this.add(pointAccess.getLatitude(n), pointAccess.getLongitude(n));
        }
    }

    public void add(PointList pointList) {
        this.ensureMutability();
        int n = this.size + pointList.getSize();
        this.incCap(n);
        for (int i = 0; i < pointList.getSize(); ++i) {
            int n2 = this.size + i;
            this.latitudes[n2] = pointList.getLatitude(i);
            this.longitudes[n2] = pointList.getLongitude(i);
            if (!this.is3D) continue;
            this.elevations[n2] = pointList.getElevation(i);
        }
        this.size = n;
    }

    public void add(GHPoint gHPoint) {
        if (this.is3D) {
            this.add(gHPoint.lat, gHPoint.lon, ((GHPoint3D)gHPoint).ele);
        } else {
            this.add(gHPoint.lat, gHPoint.lon);
        }
    }

    public double calcDistance(DistanceCalc distanceCalc) {
        double d;
        double d2 = Double.NaN;
        double d3 = 0.0;
        double d4 = d = Double.NaN;
        for (int i = 0; i < this.size(); ++i) {
            double d5 = d3;
            if (i > 0) {
                d5 = this.is3D() ? distCalc3D.calcDist(d, d4, d2, this.getLat(i), this.getLon(i), this.getEle(i)) : distanceCalc.calcDist(d, d4, this.getLat(i), this.getLon(i));
                d5 = d3 + d5;
            }
            d = this.getLat(i);
            d4 = this.getLon(i);
            if (this.is3D()) {
                d2 = this.getEle(i);
            }
            d3 = d5;
        }
        return d3;
    }

    public void clear() {
        this.ensureMutability();
        this.size = 0;
    }

    public PointList clone(boolean bl) {
        int n;
        PointList pointList = new PointList(this.getSize(), this.is3D());
        boolean bl2 = this.is3D();
        if (bl2) {
            for (n = 0; n < this.getSize(); ++n) {
                pointList.add(this.getLatitude(n), this.getLongitude(n), this.getElevation(n));
            }
        } else {
            for (n = 0; n < this.getSize(); ++n) {
                pointList.add(this.getLatitude(n), this.getLongitude(n));
            }
        }
        if (bl) {
            pointList.reverse();
        }
        return pointList;
    }

    public PointList copy(int n, int n2) {
        if (n <= n2) {
            if (n >= 0 && n2 <= this.getSize()) {
                PointList pointList;
                PointList pointList2;
                if (this instanceof ShallowImmutablePointList) {
                    pointList2 = (ShallowImmutablePointList)this;
                    pointList = pointList2.wrappedPointList;
                    n += pointList2.fromOffset;
                    n2 += pointList2.fromOffset;
                } else {
                    pointList = this;
                }
                pointList2 = new PointList(n2 -= n, this.is3D());
                pointList2.size = n2;
                pointList2.isImmutable = this.isImmutable();
                System.arraycopy(pointList.latitudes, n, pointList2.latitudes, 0, n2);
                System.arraycopy(pointList.longitudes, n, pointList2.longitudes, 0, n2);
                if (this.is3D()) {
                    System.arraycopy(pointList.elevations, n, pointList2.elevations, 0, n2);
                }
                return pointList2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Illegal interval: ");
            stringBuilder.append(n);
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append(", size:");
            stringBuilder.append(this.getSize());
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        throw new IllegalArgumentException("from must be smaller or equal to end");
    }

    @Override
    public void ensureNode(int n) {
        this.incCap(n + 1);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        object = (PointList)object;
        if (this.isEmpty() && ((PointList)object).isEmpty()) {
            return true;
        }
        if (this.getSize() == ((PointList)object).getSize() && this.is3D() == ((PointList)object).is3D()) {
            for (int i = 0; i < this.size(); ++i) {
                if (!PointList.equalsEps(this.getLatitude(i), ((PointList)object).getLatitude(i))) {
                    return false;
                }
                if (!PointList.equalsEps(this.getLongitude(i), ((PointList)object).getLongitude(i))) {
                    return false;
                }
                if (!this.is3D() || PointList.equalsEps(this.getElevation(i), ((PointList)object).getElevation(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    int getCapacity() {
        return this.latitudes.length;
    }

    @Override
    public int getDimension() {
        if (this.is3D) {
            return 3;
        }
        return 2;
    }

    @Override
    public double getEle(int n) {
        return this.getElevation(n);
    }

    @Override
    public double getElevation(int n) {
        if (n < this.size) {
            if (!this.is3D) {
                return Double.NaN;
            }
            return this.elevations[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tried to access PointList with too big index! index:");
        stringBuilder.append(n);
        stringBuilder.append(", size:");
        stringBuilder.append(this.size);
        throw new ArrayIndexOutOfBoundsException(stringBuilder.toString());
    }

    @Override
    public double getLat(int n) {
        return this.getLatitude(n);
    }

    @Override
    public double getLatitude(int n) {
        if (n < this.size) {
            return this.latitudes[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tried to access PointList with too big index! index:");
        stringBuilder.append(n);
        stringBuilder.append(", size:");
        stringBuilder.append(this.size);
        throw new ArrayIndexOutOfBoundsException(stringBuilder.toString());
    }

    @Override
    public double getLon(int n) {
        return this.getLongitude(n);
    }

    @Override
    public double getLongitude(int n) {
        if (n < this.size) {
            return this.longitudes[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tried to access PointList with too big index! index:");
        stringBuilder.append(n);
        stringBuilder.append(", size:");
        stringBuilder.append(this.size);
        throw new ArrayIndexOutOfBoundsException(stringBuilder.toString());
    }

    public int getSize() {
        return this.size();
    }

    public int hashCode() {
        int n = 5;
        for (int i = 0; i < this.getSize(); ++i) {
            n = (n * 73 + (int)Math.round(this.getLatitude(i) * 1000000.0)) * 73 + (int)Math.round(this.getLongitude(i) * 1000000.0);
        }
        return n * 73 + this.getSize();
    }

    @Override
    public boolean is3D() {
        return this.is3D;
    }

    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public Iterator<GHPoint3D> iterator() {
        return new Iterator<GHPoint3D>(){
            int counter = 0;

            @Override
            public boolean hasNext() {
                boolean bl = this.counter < PointList.this.getSize();
                return bl;
            }

            @Override
            public GHPoint3D next() {
                if (this.counter < PointList.this.getSize()) {
                    GHPoint3D gHPoint3D = PointList.this.toGHPoint(this.counter);
                    ++this.counter;
                    return gHPoint3D;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public void makeImmutable() {
        this.isImmutable = true;
    }

    public void parse2DJSON(String stringArray) {
        for (String string2 : stringArray.split("\\[")) {
            if (string2.trim().length() == 0) continue;
            String[] stringArray2 = string2.split(",");
            this.add(Double.parseDouble(stringArray2[1].replace("]", "").trim()), Double.parseDouble(stringArray2[0].trim()), Double.NaN);
        }
    }

    public void removeLastPoint() {
        int n = this.size;
        if (n != 0) {
            this.size = n - 1;
            return;
        }
        throw new IllegalStateException("Cannot remove last point from empty PointList");
    }

    public void reverse() {
        this.ensureMutability();
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int n2 = this.size - i - 1;
            double[] dArray = this.latitudes;
            double d = dArray[i];
            dArray[i] = dArray[n2];
            dArray[n2] = d;
            dArray = this.longitudes;
            d = dArray[i];
            dArray[i] = dArray[n2];
            dArray[n2] = d;
            if (!this.is3D) continue;
            dArray = this.elevations;
            d = dArray[i];
            dArray[i] = dArray[n2];
            dArray[n2] = d;
        }
    }

    public void set(int n, double d, double d2, double d3) {
        block2: {
            block5: {
                block4: {
                    block3: {
                        this.ensureMutability();
                        if (n >= this.size) break block2;
                        this.latitudes[n] = d;
                        this.longitudes[n] = d2;
                        if (!this.is3D) break block3;
                        this.elevations[n] = d3;
                        break block4;
                    }
                    if (!Double.isNaN(d3)) break block5;
                }
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("This is a 2D list we cannot store elevation: ");
            stringBuilder.append(d3);
            throw new IllegalStateException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("index has to be smaller than size ");
        stringBuilder.append(this.size);
        throw new ArrayIndexOutOfBoundsException(stringBuilder.toString());
    }

    public void setElevation(int n, double d) {
        if (n < this.size) {
            if (this.is3D) {
                this.elevations[n] = d;
                return;
            }
            throw new IllegalStateException("This is a 2D PointList, you cannot set it's elevation");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tried to access PointList with too big index! index:");
        stringBuilder.append(n);
        stringBuilder.append(", size:");
        stringBuilder.append(this.size);
        throw new ArrayIndexOutOfBoundsException(stringBuilder.toString());
    }

    @Override
    public void setNode(int n, double d, double d2) {
        this.set(n, d, d2, Double.NaN);
    }

    @Override
    public void setNode(int n, double d, double d2, double d3) {
        this.set(n, d, d2, d3);
    }

    public PointList shallowCopy(int n, int n2, boolean bl) {
        if (bl) {
            this.makeImmutable();
        }
        return new ShallowImmutablePointList(n, n2, this);
    }

    public int size() {
        return this.size;
    }

    public GHPoint3D toGHPoint(int n) {
        return new GHPoint3D(this.getLatitude(n), this.getLongitude(n), this.getElevation(n));
    }

    public LineString toLineString(boolean bl) {
        GeometryFactory geometryFactory = new GeometryFactory();
        int n = this.getSize() == 1 ? 2 : this.getSize();
        Coordinate[] coordinateArray = new Coordinate[n];
        for (n = 0; n < this.getSize(); ++n) {
            Coordinate coordinate = bl ? new Coordinate(PointList.round6(this.getLongitude(n)), PointList.round6(this.getLatitude(n)), PointList.round2(this.getElevation(n))) : new Coordinate(PointList.round6(this.getLongitude(n)), PointList.round6(this.getLatitude(n)));
            coordinateArray[n] = coordinate;
        }
        if (this.getSize() == 1) {
            coordinateArray[1] = coordinateArray[0];
        }
        return geometryFactory.createLineString(coordinateArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getSize(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('(');
            stringBuilder.append(this.getLatitude(i));
            stringBuilder.append(',');
            stringBuilder.append(this.getLongitude(i));
            if (this.is3D()) {
                stringBuilder.append(',');
                stringBuilder.append(this.getElevation(i));
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public void trimToSize(int n) {
        this.ensureMutability();
        if (n <= this.size) {
            this.size = n;
            return;
        }
        throw new IllegalArgumentException("new size needs be smaller than old size");
    }
}

