/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import java.util.HashMap;
import java.util.Map;

public class RoundaboutInstruction
extends Instruction {
    private int clockwise = 0;
    private int exitNumber = 0;
    private boolean exited = false;
    private double radian = Double.NaN;

    public RoundaboutInstruction(int n, String string2, InstructionAnnotation instructionAnnotation, PointList pointList) {
        super(n, string2, instructionAnnotation, pointList);
    }

    public int getExitNumber() {
        if (this.exited && this.exitNumber == 0) {
            throw new IllegalStateException("RoundaboutInstruction must contain exitNumber>0");
        }
        return this.exitNumber;
    }

    @Override
    public Map<String, Object> getExtraInfoJSON() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("exit_number", this.getExitNumber());
        hashMap.put("exited", this.exited);
        double d = this.getTurnAngle();
        if (!Double.isNaN(d)) {
            hashMap.put("turn_angle", Helper.round(d, 2));
        }
        return hashMap;
    }

    public double getTurnAngle() {
        if (Math.abs(this.clockwise) != 1) {
            return Double.NaN;
        }
        return (double)this.clockwise * Math.PI - this.radian;
    }

    @Override
    public String getTurnDescription(Translation object) {
        if (this.rawName) {
            return this.getName();
        }
        String string2 = this.getName();
        int n = this.getSign();
        if (n == 6) {
            object = !this.exited ? object.tr("roundabout_enter", new Object[0]) : (Helper.isEmpty(string2) ? object.tr("roundabout_exit", this.getExitNumber()) : object.tr("roundabout_exit_onto", this.getExitNumber(), string2));
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append("no roundabout indication");
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public RoundaboutInstruction increaseExitNumber() {
        ++this.exitNumber;
        return this;
    }

    public boolean isExited() {
        return this.exited;
    }

    public RoundaboutInstruction setDirOfRotation(double d) {
        int n = this.clockwise;
        int n2 = 1;
        int n3 = 1;
        if (n == 0) {
            if (!(d > 0.0)) {
                n3 = -1;
            }
            this.clockwise = n3;
        } else {
            n3 = d > 0.0 ? n2 : -1;
            if (n != n3) {
                this.clockwise = 2;
            }
        }
        return this;
    }

    public RoundaboutInstruction setExitNumber(int n) {
        this.exitNumber = n;
        return this;
    }

    public RoundaboutInstruction setExited() {
        this.exited = true;
        return this;
    }

    public RoundaboutInstruction setRadian(double d) {
        this.radian = d;
        return this;
    }
}

