/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.PointList;

public final class ShallowImmutablePointList
extends PointList {
    private static final String IMMUTABLE_ERR = "This class is immutable, you are not allowed to change it";
    final int fromOffset;
    final int toOffset;
    final PointList wrappedPointList;

    public ShallowImmutablePointList(int n, int n2, PointList object) {
        if (n <= n2) {
            if (n >= 0 && n2 <= ((PointList)object).getSize()) {
                this.fromOffset = n;
                this.toOffset = n2;
                this.wrappedPointList = object;
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Illegal interval: ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(", ");
            ((StringBuilder)object).append(n2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        throw new IllegalArgumentException("from must be smaller or equal to end");
    }

    @Override
    public void add(double d, double d2, double d3) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void add(PointList pointList) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void ensureNode(int n) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public int getDimension() {
        return this.wrappedPointList.getDimension();
    }

    @Override
    public double getElevation(int n) {
        if (n <= this.getSize()) {
            return this.wrappedPointList.getElevation(this.fromOffset + n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tried to access PointList with too big index! index:");
        stringBuilder.append(n);
        stringBuilder.append(", size:");
        stringBuilder.append(this.getSize());
        throw new ArrayIndexOutOfBoundsException(stringBuilder.toString());
    }

    @Override
    public double getLatitude(int n) {
        if (n <= this.getSize()) {
            return this.wrappedPointList.getLatitude(this.fromOffset + n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tried to access PointList with too big index! index:");
        stringBuilder.append(n);
        stringBuilder.append(", size:");
        stringBuilder.append(this.getSize());
        throw new ArrayIndexOutOfBoundsException(stringBuilder.toString());
    }

    @Override
    public double getLongitude(int n) {
        if (n <= this.getSize()) {
            return this.wrappedPointList.getLongitude(this.fromOffset + n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tried to access PointList with too big index! index:");
        stringBuilder.append(n);
        stringBuilder.append(", size:");
        stringBuilder.append(this.getSize());
        throw new ArrayIndexOutOfBoundsException(stringBuilder.toString());
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public boolean is3D() {
        return this.wrappedPointList.is3D();
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public boolean isImmutable() {
        return this.wrappedPointList.isImmutable();
    }

    @Override
    public void makeImmutable() {
        this.wrappedPointList.makeImmutable();
    }

    @Override
    public void parse2DJSON(String string2) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void removeLastPoint() {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void reverse() {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void set(int n, double d, double d2, double d3) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void setElevation(int n, double d) {
        this.wrappedPointList.setElevation(this.fromOffset + n, d);
    }

    @Override
    public void setNode(int n, double d, double d2) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public void setNode(int n, double d, double d2, double d3) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }

    @Override
    public int size() {
        return this.toOffset - this.fromOffset;
    }

    @Override
    public void trimToSize(int n) {
        throw new UnsupportedOperationException(IMMUTABLE_ERR);
    }
}

