/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import java.util.Arrays;

public class SimpleIntDeque {
    private int[] arr;
    private int endIndexPlusOne;
    private int frontIndex;
    private float growFactor;

    public SimpleIntDeque() {
        this(100, 2.0f);
    }

    public SimpleIntDeque(int n) {
        this(n, 2.0f);
    }

    public SimpleIntDeque(int n, float f) {
        if ((int)((float)n * f) > n) {
            this.growFactor = f;
            this.arr = new int[n];
            return;
        }
        throw new RuntimeException("initial size or increasing grow-factor too low!");
    }

    int getCapacity() {
        return this.arr.length;
    }

    public int getSize() {
        return this.endIndexPlusOne - this.frontIndex;
    }

    public boolean isEmpty() {
        boolean bl = this.frontIndex >= this.endIndexPlusOne;
        return bl;
    }

    public int pop() {
        int[] nArray = this.arr;
        int n = this.frontIndex;
        int n2 = nArray[n];
        this.frontIndex = ++n;
        if (n > (int)((float)nArray.length / this.growFactor)) {
            this.endIndexPlusOne = n = this.getSize();
            nArray = new int[n + 10];
            System.arraycopy(this.arr, this.frontIndex, nArray, 0, n);
            this.arr = nArray;
            this.frontIndex = 0;
        }
        return n2;
    }

    public void push(int n) {
        int n2 = this.endIndexPlusOne;
        int[] nArray = this.arr;
        if (n2 >= nArray.length) {
            this.arr = Arrays.copyOf(nArray, (int)((float)nArray.length * this.growFactor));
        }
        nArray = this.arr;
        n2 = this.endIndexPlusOne;
        nArray[n2] = n;
        this.endIndexPlusOne = n2 + 1;
    }

    public void setGrowFactor(float f) {
        this.growFactor = f;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.frontIndex; i < this.endIndexPlusOne; ++i) {
            if (i > this.frontIndex) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.arr[i]);
        }
        return stringBuilder.toString();
    }
}

