/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import com.graphhopper.util.Translation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TranslationMap {
    private static final List<String> LOCALES = Arrays.asList("ar", "ast", "bg", "ca", "cs_CZ", "da_DK", "de_DE", "el", "eo", "es", "en_US", "fa", "fil", "fi", "fr_FR", "fr_CH", "gl", "he", "hr_HR", "hsb", "hu_HU", "it", "ja", "ko", "lt_LT", "ne", "nl", "pl_PL", "pt_BR", "pt_PT", "ro", "ru", "sk", "sl_SI", "sr_RS", "sv_SE", "tr", "uk", "vi_VI", "zh_CN", "zh_HK");
    private final Map<String, Translation> translations = new HashMap<String, Translation>();

    public static int countOccurence(String string2, String string3) {
        if (Helper.isEmpty(string2)) {
            return 0;
        }
        return string2.trim().split(string3).length;
    }

    private void postImportHook() {
        Map<String, String> map = this.get("en").asMap();
        StringBuilder stringBuilder = new StringBuilder();
        for (Translation translation : this.translations.values()) {
            Map<String, String> map2 = translation.asMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string2 = map2.get(entry.getKey());
                if (Helper.isEmpty(string2)) {
                    map2.put(entry.getKey(), entry.getValue());
                    continue;
                }
                int n = TranslationMap.countOccurence(entry.getValue(), "\\%");
                if (n != TranslationMap.countOccurence(string2, "\\%")) {
                    stringBuilder.append(translation.getLocale());
                    stringBuilder.append(" - error in ");
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append("->");
                    stringBuilder.append(string2);
                    stringBuilder.append("\n");
                    continue;
                }
                Object[] objectArray = new String[n];
                Arrays.fill(objectArray, "tmp");
                try {
                    String.format(Locale.ROOT, string2, objectArray);
                }
                catch (Exception exception) {
                    stringBuilder.append(translation.getLocale());
                    stringBuilder.append(" - error ");
                    stringBuilder.append(exception.getMessage());
                    stringBuilder.append("in ");
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append("->");
                    stringBuilder.append(string2);
                    stringBuilder.append("\n");
                }
            }
        }
        if (stringBuilder.length() <= 0) {
            return;
        }
        System.out.println(stringBuilder);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void add(Translation translation) {
        Locale locale = translation.getLocale();
        this.translations.put(locale.toString(), translation);
        if (!locale.getCountry().isEmpty() && !this.translations.containsKey(translation.getLanguage())) {
            this.translations.put(translation.getLanguage(), translation);
        }
        if ("iw".equals(locale.getLanguage())) {
            this.translations.put("he", translation);
        }
        if ("in".equals(locale.getLanguage())) {
            this.translations.put("id", translation);
        }
    }

    public TranslationMap doImport() {
        try {
            for (String string2 : LOCALES) {
                TranslationHashMap translationHashMap = new TranslationHashMap(Helper.getLocale(string2));
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                stringBuilder.append(".txt");
                translationHashMap.doImport(TranslationMap.class.getResourceAsStream(stringBuilder.toString()));
                this.add(translationHashMap);
            }
            this.postImportHook();
            return this;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public TranslationMap doImport(File file) {
        try {
            for (String string2 : LOCALES) {
                TranslationHashMap translationHashMap = new TranslationHashMap(Helper.getLocale(string2));
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                stringBuilder.append(".txt");
                File file2 = new File(file, stringBuilder.toString());
                FileInputStream fileInputStream = new FileInputStream(file2);
                translationHashMap.doImport(fileInputStream);
                this.add(translationHashMap);
            }
            this.postImportHook();
            return this;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Translation get(String object) {
        String string2 = ((String)object).replace("-", "_");
        Translation translation = this.translations.get(string2);
        object = translation;
        if (string2.contains("_")) {
            object = translation;
            if (translation == null) {
                object = this.translations.get(string2.substring(0, 2));
            }
        }
        return object;
    }

    public Translation getWithFallBack(Locale object) {
        Translation translation = this.get(((Locale)object).toString());
        Object object2 = translation;
        if (translation == null) {
            object2 = object = this.get(((Locale)object).getLanguage());
            if (object == null) {
                object2 = this.get("en");
            }
        }
        return object2;
    }

    public String toString() {
        return this.translations.toString();
    }

    public static class TranslationHashMap
    implements Translation {
        final Locale locale;
        private final Map<String, String> map = new HashMap<String, String>();

        public TranslationHashMap(Locale locale) {
            this.locale = locale;
        }

        @Override
        public Map<String, String> asMap() {
            return this.map;
        }

        public void clear() {
            this.map.clear();
        }

        public TranslationHashMap doImport(InputStream object) {
            if (object != null) {
                int n;
                Object object2;
                try {
                    object2 = new InputStreamReader((InputStream)object, Helper.UTF_CS);
                    object2 = Helper.readFile((Reader)object2).iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        if (((String)object).isEmpty() || ((String)object).startsWith("//") || ((String)object).startsWith("#") || (n = ((String)object).indexOf(61)) < 0) continue;
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                {
                    CharSequence charSequence = ((String)object).substring(0, n);
                    if (!((String)charSequence).isEmpty()) {
                        if (((String)(object = ((String)object).substring(n + 1))).isEmpty()) continue;
                        this.put((String)charSequence, (String)object);
                        continue;
                    }
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("No key provided:");
                    ((StringBuilder)charSequence).append((String)object);
                    object2 = new IllegalStateException(((StringBuilder)charSequence).toString());
                    throw object2;
                }
                return this;
            }
            throw new IllegalStateException("No input stream found in class path!?");
        }

        @Override
        public String getLanguage() {
            return this.locale.getLanguage();
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }

        public TranslationHashMap put(String string2, String string3) {
            String string4 = this.map.put(Helper.toLowerCase(string2), string3);
            if (string4 == null) {
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot overwrite key ");
            stringBuilder.append(string2);
            stringBuilder.append(" with ");
            stringBuilder.append(string3);
            stringBuilder.append(", was: ");
            stringBuilder.append(string4);
            throw new IllegalStateException(stringBuilder.toString());
        }

        public String toString() {
            return this.map.toString();
        }

        @Override
        public String tr(String string2, Object ... objectArray) {
            String string3 = this.map.get(Helper.toLowerCase(string2));
            if (Helper.isEmpty(string3)) {
                return string2;
            }
            return String.format(Locale.ROOT, string3, objectArray);
        }
    }
}

