/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;

public class ViaInstruction
extends Instruction {
    private int viaPosition = -1;

    public ViaInstruction(Instruction instruction) {
        this(instruction.getName(), instruction.getAnnotation(), instruction.getPoints());
        this.setDistance(instruction.getDistance());
        this.setTime(instruction.getTime());
        this.extraInfo = instruction.extraInfo;
    }

    public ViaInstruction(String string2, InstructionAnnotation instructionAnnotation, PointList pointList) {
        super(5, string2, instructionAnnotation, pointList);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public String getTurnDescription(Translation translation) {
        if (this.rawName) {
            return this.getName();
        }
        return translation.tr("stopover", this.viaPosition);
    }

    public int getViaCount() {
        int n = this.viaPosition;
        if (n >= 0) {
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Uninitialized via count in instruction ");
        stringBuilder.append(this.getName());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void setViaCount(int n) {
        this.viaPosition = n;
    }
}

