/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.coll.MapEntry;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.details.PathDetailsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractPathDetailsBuilder
implements PathDetailsBuilder {
    private PathDetail currentDetail;
    private boolean isOpen = false;
    private final String name;
    private List<PathDetail> pathDetails = new ArrayList<PathDetail>();

    public AbstractPathDetailsBuilder(String string2) {
        this.name = string2;
    }

    @Override
    public Map.Entry<String, List<PathDetail>> build() {
        return new MapEntry<String, List<PathDetail>>(this.getName(), this.pathDetails);
    }

    @Override
    public void endInterval(int n) {
        if (this.isOpen) {
            this.currentDetail.setLast(n);
            this.pathDetails.add(this.currentDetail);
        }
        this.isOpen = false;
    }

    protected abstract Object getCurrentValue();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void startInterval(int n) {
        Object object = this.getCurrentValue();
        if (!this.isOpen) {
            this.currentDetail = object = new PathDetail(object);
            ((PathDetail)object).setFirst(n);
            this.isOpen = true;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PathDetailsBuilder is already in an open state with value: ");
        stringBuilder.append(this.currentDetail.getValue());
        stringBuilder.append(" trying to open a new one with value: ");
        stringBuilder.append(object);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public String toString() {
        return this.getName();
    }
}

