/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class AverageSpeedDetails
extends AbstractPathDetailsBuilder {
    private double curAvgSpeed = -1.0;
    private final FlagEncoder encoder;

    public AverageSpeedDetails(FlagEncoder flagEncoder) {
        super("average_speed");
        this.encoder = flagEncoder;
    }

    @Override
    public Object getCurrentValue() {
        return this.curAvgSpeed;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edgeIteratorState) {
        if (Math.abs(this.encoder.getSpeed(edgeIteratorState.getFlags()) - this.curAvgSpeed) > 1.0E-4) {
            this.curAvgSpeed = this.encoder.getSpeed(edgeIteratorState.getFlags());
            return true;
        }
        return false;
    }
}

