/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.Helper;
import com.graphhopper.util.NumHelper;
import com.graphhopper.util.shapes.Circle;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Shape;
import java.util.ArrayList;
import java.util.List;

public class BBox
implements Shape,
Cloneable {
    private final boolean elevation;
    public double maxEle;
    public double maxLat;
    public double maxLon;
    public double minEle;
    public double minLat;
    public double minLon;

    public BBox(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, Double.NaN, Double.NaN, false);
    }

    public BBox(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d3, d4, d5, d6, true);
    }

    public BBox(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.elevation = bl;
        this.maxLat = d4;
        this.minLon = d;
        this.minLat = d3;
        this.maxLon = d2;
        this.minEle = d5;
        this.maxEle = d6;
    }

    public BBox(double[] dArray) {
        this(dArray[0], dArray[2], dArray[1], dArray[3]);
    }

    public static BBox createInverse(boolean bl) {
        if (bl) {
            return new BBox(Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, true);
        }
        return new BBox(Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.NaN, Double.NaN, false);
    }

    public static BBox parseBBoxString(String string2) {
        Object object = string2.split(",");
        if (((String[])object).length == 4) {
            return new BBox(Double.parseDouble(object[0]), Double.parseDouble((String)object[1]), Double.parseDouble((String)object[2]), Double.parseDouble((String)object[3]));
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("BBox should have 4 parts but was ");
        ((StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public static BBox parseTwoPoints(String string2) {
        Object object = string2.split(",");
        if (((String[])object).length == 4) {
            double d;
            double d2 = Double.parseDouble(object[0]);
            double d3 = Double.parseDouble((String)object[1]);
            double d4 = Double.parseDouble((String)object[2]);
            double d5 = Double.parseDouble((String)object[3]);
            if (!(d2 > d4)) {
                d = d2;
                d2 = d4;
                d4 = d;
            }
            if (!(d3 > d5)) {
                d = d3;
                d3 = d5;
                d5 = d;
            }
            return new BBox(d5, d3, d4, d2);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("BBox should have 4 parts but was ");
        ((StringBuilder)object).append(string2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public double calculateArea() {
        double d = (this.maxLat + this.minLat) / 2.0;
        double d2 = Helper.DIST_PLANE.calcDist(d, this.minLon, d, this.maxLon);
        DistancePlaneProjection distancePlaneProjection = Helper.DIST_PLANE;
        d = this.minLat;
        double d3 = this.minLon;
        return d2 * distancePlaneProjection.calcDist(d, d3, this.maxLat, d3);
    }

    public BBox calculateIntersection(BBox bBox) {
        if (!this.intersect(bBox)) {
            return null;
        }
        return new BBox(Math.max(this.minLon, bBox.minLon), Math.min(this.maxLon, bBox.maxLon), Math.max(this.minLat, bBox.minLat), Math.min(this.maxLat, bBox.maxLat));
    }

    public BBox clone() {
        return new BBox(this.minLon, this.maxLon, this.minLat, this.maxLat, this.minEle, this.maxEle, this.elevation);
    }

    @Override
    public boolean contains(double d, double d2) {
        boolean bl = d <= this.maxLat && d >= this.minLat && d2 <= this.maxLon && d2 >= this.minLon;
        return bl;
    }

    public boolean contains(BBox bBox) {
        boolean bl = this.maxLat >= bBox.maxLat && this.minLat <= bBox.minLat && this.maxLon >= bBox.maxLon && this.minLon <= bBox.minLon;
        return bl;
    }

    public boolean contains(Circle circle) {
        return this.contains(circle.getBounds());
    }

    @Override
    public boolean contains(Shape shape) {
        if (shape instanceof BBox) {
            return this.contains((BBox)shape);
        }
        if (shape instanceof Circle) {
            return this.contains((Circle)shape);
        }
        throw new UnsupportedOperationException("unsupported shape");
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null) {
            return false;
        }
        object = (BBox)object;
        boolean bl2 = bl;
        if (NumHelper.equalsEps(this.minLat, ((BBox)object).minLat)) {
            bl2 = bl;
            if (NumHelper.equalsEps(this.maxLat, ((BBox)object).maxLat)) {
                bl2 = bl;
                if (NumHelper.equalsEps(this.minLon, ((BBox)object).minLon)) {
                    bl2 = bl;
                    if (NumHelper.equalsEps(this.maxLon, ((BBox)object).maxLon)) {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    @Override
    public BBox getBounds() {
        return this;
    }

    @Override
    public GHPoint getCenter() {
        return new GHPoint((this.maxLat + this.minLat) / 2.0, (this.maxLon + this.minLon) / 2.0);
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public int hashCode() {
        return (((51 + (int)(Double.doubleToLongBits(this.minLon) ^ Double.doubleToLongBits(this.minLon) >>> 32)) * 17 + (int)(Double.doubleToLongBits(this.maxLon) ^ Double.doubleToLongBits(this.maxLon) >>> 32)) * 17 + (int)(Double.doubleToLongBits(this.minLat) ^ Double.doubleToLongBits(this.minLat) >>> 32)) * 17 + (int)(Double.doubleToLongBits(this.maxLat) ^ Double.doubleToLongBits(this.maxLat) >>> 32);
    }

    public boolean intersect(BBox bBox) {
        boolean bl = this.minLon < bBox.maxLon && this.minLat < bBox.maxLat && bBox.minLon < this.maxLon && bBox.minLat < this.maxLat;
        return bl;
    }

    public boolean intersect(Circle circle) {
        return circle.intersect(this);
    }

    @Override
    public boolean intersect(Shape shape) {
        if (shape instanceof BBox) {
            return this.intersect((BBox)shape);
        }
        if (shape instanceof Circle) {
            return ((Circle)shape).intersect(this);
        }
        throw new UnsupportedOperationException("unsupported shape");
    }

    public boolean isValid() {
        double d = this.minLon;
        double d2 = this.maxLon;
        boolean bl = false;
        if (d >= d2) {
            return false;
        }
        if (this.minLat >= this.maxLat) {
            return false;
        }
        if (this.elevation) {
            d2 = this.minEle;
            d = this.maxEle;
            if (d2 > d) {
                return false;
            }
            if (Double.compare(d, -1.7976931348623157E308) == 0 || Double.compare(this.minEle, Double.MAX_VALUE) == 0) {
                return false;
            }
        }
        boolean bl2 = bl;
        if (Double.compare(this.maxLat, -1.7976931348623157E308) != 0) {
            bl2 = bl;
            if (Double.compare(this.minLat, Double.MAX_VALUE) != 0) {
                bl2 = bl;
                if (Double.compare(this.maxLon, -1.7976931348623157E308) != 0) {
                    bl2 = bl;
                    if (Double.compare(this.minLon, Double.MAX_VALUE) != 0) {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    public List<Double> toGeoJson() {
        ArrayList<Double> arrayList = new ArrayList<Double>(4);
        arrayList.add(Helper.round6(this.minLon));
        arrayList.add(Helper.round6(this.minLat));
        if (this.elevation) {
            arrayList.add(Helper.round2(this.minEle));
        }
        arrayList.add(Helper.round6(this.maxLon));
        arrayList.add(Helper.round6(this.maxLat));
        if (this.elevation) {
            arrayList.add(Helper.round2(this.maxEle));
        }
        return arrayList;
    }

    public String toLessPrecisionString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((float)this.minLon);
        stringBuilder.append(",");
        stringBuilder.append((float)this.maxLon);
        stringBuilder.append(",");
        stringBuilder.append((float)this.minLat);
        stringBuilder.append(",");
        stringBuilder.append((float)this.maxLat);
        return stringBuilder.toString();
    }

    public String toString() {
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(this.minLon);
        ((StringBuilder)charSequence).append(",");
        ((StringBuilder)charSequence).append(this.maxLon);
        ((StringBuilder)charSequence).append(",");
        ((StringBuilder)charSequence).append(this.minLat);
        ((StringBuilder)charSequence).append(",");
        ((StringBuilder)charSequence).append(this.maxLat);
        String string2 = ((StringBuilder)charSequence).toString();
        charSequence = string2;
        if (this.elevation) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(",");
            ((StringBuilder)charSequence).append(this.minEle);
            ((StringBuilder)charSequence).append(",");
            ((StringBuilder)charSequence).append(this.maxEle);
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public void update(double d, double d2) {
        if (d > this.maxLat) {
            this.maxLat = d;
        }
        if (d < this.minLat) {
            this.minLat = d;
        }
        if (d2 > this.maxLon) {
            this.maxLon = d2;
        }
        if (d2 < this.minLon) {
            this.minLon = d2;
        }
    }

    public void update(double d, double d2, double d3) {
        if (this.elevation) {
            if (d3 > this.maxEle) {
                this.maxEle = d3;
            }
            if (d3 < this.minEle) {
                this.minEle = d3;
            }
            this.update(d, d2);
            return;
        }
        throw new IllegalStateException("No BBox with elevation to update");
    }
}

