/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Shape;

public class Polygon
implements Shape {
    private final double epsilon;
    private final double[] lat;
    private final double[] lon;
    private double maxLat;
    private double maxLon;
    private double minLat;
    private double minLon;

    public Polygon(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, 0.0);
    }

    public Polygon(double[] dArray, double[] dArray2, double d) {
        if (dArray.length == dArray2.length) {
            if (dArray.length != 0) {
                double d2;
                double d3;
                this.lat = dArray;
                this.lon = dArray2;
                for (int i = 0; i < dArray.length; ++i) {
                    if (i == 0) {
                        this.minLat = dArray[i];
                        this.maxLat = dArray[i];
                        this.minLon = dArray2[i];
                        this.maxLon = dArray2[i];
                        continue;
                    }
                    if (dArray[i] < this.minLat) {
                        this.minLat = dArray[i];
                    } else if (dArray[i] > this.maxLat) {
                        this.maxLat = dArray[i];
                    }
                    if (dArray2[i] < this.minLon) {
                        this.minLon = dArray2[i];
                        continue;
                    }
                    if (!(dArray2[i] > this.maxLon)) continue;
                    this.maxLon = dArray2[i];
                }
                this.minLat = d3 = this.minLat - d;
                this.minLon -= d;
                this.maxLat = d2 = this.maxLat + d;
                this.maxLon += d;
                this.epsilon = (d2 - d3) / 10.0;
                return;
            }
            throw new IllegalArgumentException("Points must not be empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Points must be of equal length but was ");
        stringBuilder.append(dArray.length);
        stringBuilder.append(" vs. ");
        stringBuilder.append(dArray2.length);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static Polygon create(com.vividsolutions.jts.geom.Polygon polygon) {
        double[] dArray = new double[polygon.getNumPoints()];
        double[] dArray2 = new double[polygon.getNumPoints()];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            dArray[i] = polygon.getCoordinates()[i].y;
            dArray2[i] = polygon.getCoordinates()[i].x;
        }
        return new Polygon(dArray, dArray2);
    }

    private boolean edgesAreIntersecting(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d4 - d2;
        double d10 = d - d3;
        double d11 = d3 * d2 - d * d4;
        double d12 = d9 * d5 + d10 * d6 + d11;
        d11 = d9 * d7 + d10 * d8 + d11;
        if (d12 > 0.0 && d11 > 0.0) {
            return false;
        }
        if (d12 < 0.0 && d11 < 0.0) {
            return false;
        }
        d12 = d8 - d6;
        d11 = d5 - d7;
        d5 = d7 * d6 - d5 * d8;
        d = d12 * d + d11 * d2 + d5;
        d2 = d12 * d3 + d11 * d4 + d5;
        if (d > 0.0 && d2 > 0.0) {
            return false;
        }
        if (d < 0.0 && d2 < 0.0) {
            return false;
        }
        return d9 * d11 - d12 * d10 != 0.0;
    }

    public static Polygon parsePoints(String object, double d) {
        String[] stringArray = ((String)object).split(",");
        if (stringArray.length % 2 != 1) {
            double[] dArray = new double[stringArray.length / 2];
            object = new double[stringArray.length / 2];
            for (int i = 0; i < stringArray.length; ++i) {
                if (i % 2 == 0) {
                    dArray[i / 2] = Double.parseDouble(stringArray[i]);
                    continue;
                }
                object[(i - 1) / 2] = Double.parseDouble(stringArray[i]);
            }
            return new Polygon(dArray, (double[])object, d);
        }
        throw new IllegalArgumentException("incorrect polygon specified");
    }

    @Override
    public double calculateArea() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean contains(double d, double d2) {
        double d3;
        double d4;
        Object object = this;
        double d5 = ((Polygon)object).minLat;
        int n = 0;
        if (!(d < d5 || d > (d4 = ((Polygon)object).maxLat) || d2 < (d3 = ((Polygon)object).minLon) || d2 > ((Polygon)object).maxLon)) {
            double d6 = d5 / 2.0;
            double d7 = ((Polygon)object).epsilon;
            int n2 = ((Polygon)object).lat.length;
            boolean bl = false;
            while (true) {
                object = this;
                if (n >= n2) break;
                double[] dArray = ((Polygon)object).lon;
                d5 = dArray[n];
                object = ((Polygon)object).lat;
                Object object2 = object[n];
                int n3 = ++n % n2;
                boolean bl2 = bl;
                if (this.edgesAreIntersecting(d3 - d7, d4 - d6, d2, d, d5, (double)object2, dArray[n3], (double)object[n3])) {
                    bl2 = bl ^ true;
                }
                bl = bl2;
            }
            return bl;
        }
        return false;
    }

    public boolean contains(GHPoint gHPoint) {
        return this.contains(gHPoint.lat, gHPoint.lon);
    }

    @Override
    public boolean contains(Shape shape) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BBox getBounds() {
        return new BBox(this.minLon, this.maxLon, this.minLat, this.maxLat);
    }

    @Override
    public GHPoint getCenter() {
        return new GHPoint((this.maxLat + this.minLat) / 2.0, (this.maxLon + this.minLon) / 2.0);
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    @Override
    public boolean intersect(Shape shape) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("polygon (");
        stringBuilder.append(this.lat.length);
        stringBuilder.append(" points)");
        return stringBuilder.toString();
    }
}

