/*
 * Decompiled with CFR 0.152.
 */
package com.james.easyclass;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.util.Log;
import com.james.utils.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ImageManager {
    private static ImageManager imageManager;
    private final String SD_PATH = Environment.getExternalStorageDirectory().getAbsolutePath();
    private final String TAG;
    private Map<String, SoftReference<BitmapInfo>> cache = Collections.synchronizedMap(new HashMap());
    private Context mContext;
    private File mFile;
    private String mPath;

    public ImageManager() {
        this.TAG = "ImageManager";
    }

    public static byte[] bitmap2Bytes(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream)) {
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public static Bitmap bytes2Bitamp(byte[] object, int n) {
        if (((byte[])object).length == 0) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = n;
        options.inPurgeable = true;
        object = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
        options = new Matrix();
        options.reset();
        options.setRotate(90.0f, (float)(object.getWidth() / 2), (float)(object.getWidth() / 2));
        options = Bitmap.createBitmap((Bitmap)object, (int)0, (int)0, (int)object.getWidth(), (int)object.getHeight(), (Matrix)options, (boolean)true);
        object.recycle();
        return options;
    }

    public static Bitmap bytes2Bitmap(byte[] byArray) {
        return ImageManager.bytes2Bitamp(byArray, 1);
    }

    private static int caculate(Context context, Object object, Class<?> clazz, BitmapFactory.Options options, int n, int n2) {
        int n3;
        int n4;
        int n5;
        block14: {
            block15: {
                block13: {
                    n5 = 1;
                    n4 = 1;
                    n3 = n5;
                    if (!clazz.equals(String.class)) break block13;
                    n3 = n5;
                    BitmapFactory.decodeFile((String)((String)object), (BitmapFactory.Options)options);
                    break block14;
                }
                n3 = n5;
                if (!clazz.equals(byte[].class)) break block15;
                n3 = n5;
                BitmapFactory.decodeByteArray((byte[])((byte[])object), (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
                break block14;
            }
            n3 = n5;
            if (!clazz.equals(Integer.class)) break block14;
            n3 = n5;
            BitmapFactory.decodeResource((Resources)context.getResources(), (int)((Integer)object), (BitmapFactory.Options)options);
        }
        n3 = n5;
        int n6 = options.outWidth;
        n3 = n5;
        try {
            n5 = options.outHeight;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (true) {
            n3 = n4;
            if (n6 < n) break;
            if (n5 < n2) {
                n3 = n4;
                break;
            }
            n3 = n4;
            n6 /= 2;
            n3 = n4++;
            n5 /= 2;
            continue;
            break;
        }
        return n3;
    }

    private static int caculate(Object object, Class<?> clazz, BitmapFactory.Options options, int n, int n2) {
        return ImageManager.caculate(null, object, clazz, options, n, n2);
    }

    public static ImageManager getDefault(Context context) {
        if (imageManager == null) {
            imageManager = ImageManager.getInstance(context, null);
        }
        ImageManager.init(null);
        return imageManager;
    }

    public static ImageManager getDefault(Context context, String string2) {
        if (imageManager == null) {
            imageManager = new ImageManager();
        }
        ImageManager.imageManager.mContext = context;
        ImageManager.init(string2);
        return imageManager;
    }

    public static ImageManager getInstance(Context context) {
        if (imageManager == null) {
            imageManager = ImageManager.getInstance(context, null);
        }
        ImageManager.init(null);
        return imageManager;
    }

    public static ImageManager getInstance(Context context, String string2) {
        if (imageManager == null) {
            imageManager = new ImageManager();
        }
        ImageManager.imageManager.mContext = context;
        ImageManager.init(string2);
        return imageManager;
    }

    public static int getLog2(int n) {
        n /= 2;
        int n2 = 0;
        while (n > 1) {
            ++n2;
            n /= 2;
        }
        return n2 + 1;
    }

    private static BitmapFactory.Options getOption() {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        return options;
    }

    public static Bitmap getOvalImage(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = !bitmap.isMutable() ? Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : bitmap;
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        float f = (float)Math.min(bitmap.getWidth(), bitmap.getHeight()) / 2.0f;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawCircle((float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f, f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return bitmap2;
    }

    public static Bitmap getRoundedCornerImage(Bitmap bitmap) {
        return ImageManager.getRoundedCornerImage(bitmap, 7.0f);
    }

    public static Bitmap getRoundedCornerImage(Bitmap bitmap, float f) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = !bitmap.isMutable() ? Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : bitmap;
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float f2 = (float)bitmap.getWidth() / f;
        f = (float)bitmap.getHeight() / f;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, f2, f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return bitmap2;
    }

    public static int getSampleSize(String string2, int n, int n2) {
        BitmapFactory.Options options = ImageManager.getOption();
        return ImageManager.caculate(string2, string2.getClass(), options, n, n2);
    }

    public static int getSampleSize(byte[] byArray, int n, int n2) {
        BitmapFactory.Options options = ImageManager.getOption();
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
        return ImageManager.caculate(byArray, byArray.getClass(), options, n, n2);
    }

    private static void init(String charSequence) {
        Object object = charSequence;
        if (charSequence == null) {
            object = "";
        }
        charSequence = object;
        if (!((String)object).startsWith(ImageManager.imageManager.SD_PATH)) {
            charSequence = object;
            if (!((String)object).startsWith("/")) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("/");
                ((StringBuilder)charSequence).append((String)object);
                charSequence = ((StringBuilder)charSequence).toString();
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(ImageManager.imageManager.SD_PATH);
            ((StringBuilder)object).append((String)charSequence);
            charSequence = ((StringBuilder)object).toString();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("filePath: ");
        ((StringBuilder)object).append((String)charSequence);
        LogUtils.i("ImageManager", ((StringBuilder)object).toString());
        object = imageManager;
        if (((ImageManager)object).mFile == null) {
            ((ImageManager)object).mPath = charSequence;
            ((ImageManager)object).mFile = new File(ImageManager.imageManager.mPath);
        } else if (!((ImageManager)object).mPath.equalsIgnoreCase((String)charSequence)) {
            object = imageManager;
            ((ImageManager)object).mPath = charSequence;
            ((ImageManager)object).mFile = new File(ImageManager.imageManager.mPath);
        }
    }

    public static Bitmap overlayBitmaps(Bitmap bitmap, Bitmap bitmap2, int n, int n2, int n3, int n4) {
        Bitmap bitmap3 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap3);
        if (bitmap != null) {
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            if (bitmap2 != null) {
                bitmap = new Rect();
                bitmap.left = n;
                bitmap.top = n2;
                bitmap.right = n3;
                bitmap.bottom = n4;
                canvas.drawBitmap(bitmap2, null, (Rect)bitmap, null);
            }
        }
        return bitmap3;
    }

    public static Bitmap resize(Bitmap bitmap, float f) {
        if (bitmap == null) {
            return bitmap;
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(f, f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix, (boolean)true);
    }

    public static Bitmap resize(Bitmap bitmap, int n, int n2) {
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        Matrix matrix = new Matrix();
        matrix.postScale(f, f2);
        matrix = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n3, (int)n4, (Matrix)matrix, (boolean)true);
        bitmap.recycle();
        return matrix;
    }

    public static Bitmap roundTo2N(Bitmap bitmap) {
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        double d = ImageManager.getLog2(n * 2);
        double d2 = ImageManager.getLog2(n2 * 2);
        float f = (float)Math.pow(2.0, (int)d) / (float)n;
        float f2 = (float)Math.pow(2.0, (int)d2) / (float)n2;
        Matrix matrix = new Matrix();
        matrix.postScale(f, f2);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix, (boolean)true);
    }

    public Bitmap drawableToBitmap(Drawable drawable2) {
        int n = drawable2.getIntrinsicWidth();
        int n2 = drawable2.getIntrinsicHeight();
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)config);
        config = new Canvas(bitmap);
        drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        drawable2.draw((Canvas)config);
        return bitmap;
    }

    public Bitmap get(int n) {
        return this.get(String.valueOf(n));
    }

    public Bitmap get(String string2) {
        SoftReference<BitmapInfo> softReference = this.cache.get(string2);
        if (softReference != null) {
            if (softReference.get() == null) {
                this.cache.remove(string2);
                return null;
            }
            Bitmap bitmap = softReference.get().bitmap;
            if (bitmap != null && !bitmap.isRecycled()) {
                return bitmap;
            }
            if (softReference.get().type == 4097) {
                return this.loadBitmapFromSD(true, string2);
            }
            if (softReference.get().type == 4098) {
                return this.getBitmapById(true, Integer.parseInt(string2));
            }
            if (softReference.get().type == 4099) {
                return this.getBitmapByName(true, string2);
            }
        }
        return null;
    }

    public Bitmap getBitmapById(int n) {
        return this.getBitmapById(false, n, 1);
    }

    public Bitmap getBitmapById(int n, int n2) {
        return this.getBitmapById(false, n, n2);
    }

    public Bitmap getBitmapById(boolean bl, int n) {
        return this.getBitmapById(bl, n, 1);
    }

    public Bitmap getBitmapById(boolean bl, int n, int n2) {
        Bitmap bitmap;
        if (!bl && (bitmap = this.get(n)) != null && !bitmap.isRecycled()) {
            return bitmap;
        }
        bitmap = new BitmapFactory.Options();
        bitmap.inPreferredConfig = Bitmap.Config.RGB_565;
        bitmap.inPurgeable = true;
        bitmap.inInputShareable = true;
        bitmap.inSampleSize = n2;
        bitmap = BitmapFactory.decodeStream((InputStream)this.mContext.getResources().openRawResource(n), null, (BitmapFactory.Options)bitmap);
        this.put(n, 4098, bitmap);
        return bitmap;
    }

    public Bitmap getBitmapByName(String string2) {
        return this.getBitmapByName(false, string2, 1);
    }

    public Bitmap getBitmapByName(String string2, int n) {
        return this.getBitmapByName(false, string2, n);
    }

    public Bitmap getBitmapByName(boolean bl, String string2) {
        return this.getBitmapByName(bl, string2, 1);
    }

    public Bitmap getBitmapByName(boolean bl, String string2, int n) {
        Bitmap bitmap;
        if (!bl && (bitmap = this.get(string2)) != null && !bitmap.isRecycled()) {
            return bitmap;
        }
        int n2 = this.mContext.getResources().getIdentifier(string2, "drawable", this.mContext.getPackageName());
        string2 = new BitmapFactory.Options();
        ((BitmapFactory.Options)string2).inPreferredConfig = Bitmap.Config.RGB_565;
        ((BitmapFactory.Options)string2).inPurgeable = true;
        ((BitmapFactory.Options)string2).inInputShareable = true;
        ((BitmapFactory.Options)string2).inSampleSize = n;
        string2 = BitmapFactory.decodeStream((InputStream)this.mContext.getResources().openRawResource(n2), null, (BitmapFactory.Options)string2);
        this.put(n2, 4099, (Bitmap)string2);
        return string2;
    }

    public int getSampleSize(int n, int n2, int n3) {
        BitmapFactory.Options options = ImageManager.getOption();
        BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)n, (BitmapFactory.Options)options);
        return ImageManager.caculate(this.mContext, n, Integer.class, options, n2, n3);
    }

    public Bitmap loadBitmapFromSD(String string2) {
        return this.loadBitmapFromSD(false, string2, 1);
    }

    public Bitmap loadBitmapFromSD(String string2, int n) {
        return this.loadBitmapFromSD(false, string2, n);
    }

    public Bitmap loadBitmapFromSD(boolean bl, String string2) {
        return this.loadBitmapFromSD(bl, string2, 1);
    }

    public Bitmap loadBitmapFromSD(boolean bl, String object, int n) {
        Object object2;
        if (!bl && (object2 = this.get((String)object)) != null && !object2.isRecycled()) {
            return object2;
        }
        if (this.mFile != null) {
            object2 = object;
            if (!((String)object).startsWith("/")) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("/");
                ((StringBuilder)object2).append((String)object);
                object2 = ((StringBuilder)object2).toString();
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(this.mFile.toString());
            ((StringBuilder)object).append((String)object2);
            String string2 = ((StringBuilder)object).toString();
            object = new File(string2);
            String string3 = this.TAG;
            Object object3 = new StringBuilder();
            ((StringBuilder)object3).append("loadBitmapFromSD: ");
            ((StringBuilder)object3).append(string2);
            Log.d((String)string3, (String)((StringBuilder)object3).toString());
            if (((File)object).exists()) {
                try {
                    object3 = new FileInputStream((File)object);
                    object = new BitmapFactory.Options();
                    ((BitmapFactory.Options)object).inPurgeable = true;
                    ((BitmapFactory.Options)object).inSampleSize = n;
                    object = BitmapFactory.decodeStream((InputStream)object3, null, (BitmapFactory.Options)object);
                    ((FileInputStream)object3).close();
                    this.put((String)object2, 4097, (Bitmap)object);
                    return object;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
        }
        Log.e((String)this.TAG, (String)"file path is null, please add code 'getInstance(...)'");
        return null;
    }

    public void put(int n, int n2, Bitmap bitmap) {
        this.put(String.valueOf(n), n2, bitmap);
    }

    public void put(String string2, int n, Bitmap bitmap) {
        this.cache.put(string2, new SoftReference<BitmapInfo>(new BitmapInfo(n, bitmap)));
    }

    public void recycle(Bitmap ... bitmapArray) {
        block0: for (Bitmap bitmap : bitmapArray) {
            if (bitmap == null) continue;
            for (String string2 : this.cache.keySet()) {
                string2 = this.cache.get((Object)string2).get().bitmap;
                if (!bitmap.equals(string2)) continue;
                string2.recycle();
                continue block0;
            }
        }
    }

    public Bitmap reload(Bitmap bitmap) {
        String object3 = this.TAG;
        Object object = new StringBuilder();
        ((StringBuilder)object).append("bitmap is null: ");
        boolean bl = bitmap == null;
        ((StringBuilder)object).append(bl);
        Log.v((String)object3, (String)((StringBuilder)object).toString());
        if (bitmap == null) {
            return null;
        }
        String string2 = this.TAG;
        object = new StringBuilder();
        ((StringBuilder)object).append("bitmap.isRecycled(): ");
        ((StringBuilder)object).append(bitmap.isRecycled());
        Log.v((String)string2, (String)((StringBuilder)object).toString());
        if (!bitmap.isRecycled()) {
            return bitmap;
        }
        for (Map.Entry entry : this.cache.entrySet()) {
            if (!bitmap.equals(((BitmapInfo)((SoftReference)entry.getValue()).get()).bitmap)) continue;
            Log.v((String)this.TAG, (String)"bitmap hit");
            return this.get((String)entry.getKey());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveBitmapToSD(String object, Bitmap object2, Bitmap.CompressFormat object3) {
        if (this.mFile == null) {
            Log.e((String)this.TAG, (String)"file path is null, please add code 'getDefault(...)'");
            return;
        }
        Object object4 = object;
        if (!((String)object).startsWith("/")) {
            object4 = new StringBuilder();
            ((StringBuilder)object4).append("/");
            ((StringBuilder)object4).append((String)object);
            object4 = ((StringBuilder)object4).toString();
        }
        if (!this.mFile.exists()) {
            this.mFile.mkdirs();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(this.mFile.toString());
        ((StringBuilder)object).append((String)object4);
        object = ((StringBuilder)object).toString();
        String string2 = this.TAG;
        object4 = new StringBuilder();
        ((StringBuilder)object4).append("saveBitmapToSD ");
        ((StringBuilder)object4).append((String)object);
        Log.d((String)string2, (String)((StringBuilder)object4).toString());
        object = new File((String)object);
        try {
            object4 = new ByteArrayOutputStream();
            if (!object2.compress((Bitmap.CompressFormat)object3, 100, (OutputStream)object4)) return;
            object2 = new ByteArrayInputStream(((ByteArrayOutputStream)object4).toByteArray());
            object3 = new FileOutputStream((File)object);
            object = new byte[8192];
            while (true) {
                int n;
                if ((n = ((InputStream)object2).read((byte[])object, 0, 8192)) <= 0) {
                    ((FileOutputStream)object3).close();
                    ((InputStream)object2).close();
                    Log.d((String)this.TAG, (String)"photoFile copy OK");
                    return;
                }
                ((FileOutputStream)object3).write((byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveDrawableToSD(String object, Drawable object2) {
        if (this.mFile == null) {
            Log.e((String)this.TAG, (String)"file path is null, please add code 'getDefault(...)'");
            return;
        }
        Object object3 = object;
        if (!((String)object).startsWith("/")) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("/");
            ((StringBuilder)object3).append((String)object);
            object3 = ((StringBuilder)object3).toString();
        }
        object = this.TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("saveDrawableToSD ");
        stringBuilder.append(this.SD_PATH);
        stringBuilder.append(this.mPath);
        stringBuilder.append((String)object3);
        Log.d((String)object, (String)stringBuilder.toString());
        if (!this.mFile.exists()) {
            this.mFile.mkdirs();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(this.mFile.toString());
        ((StringBuilder)object).append((String)object3);
        object3 = new File(((StringBuilder)object).toString());
        try {
            int n = object2.getIntrinsicWidth();
            int n2 = object2.getIntrinsicHeight();
            object = object2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
            object = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)object);
            stringBuilder = new Canvas((Bitmap)object);
            object2.setBounds(0, 0, object2.getIntrinsicWidth(), object2.getIntrinsicHeight());
            object2.draw((Canvas)stringBuilder);
            object2 = new ByteArrayOutputStream();
            object.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object2);
            object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
            object2 = new FileOutputStream((File)object3);
            object3 = new byte[8192];
            while (true) {
                if ((n2 = ((InputStream)object).read((byte[])object3, 0, 8192)) <= 0) {
                    ((FileOutputStream)object2).close();
                    ((InputStream)object).close();
                    Log.d((String)this.TAG, (String)"photoFile copy OK");
                    return;
                }
                ((FileOutputStream)object2).write((byte[])object3, 0, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    public static class BitmapInfo {
        public static final int TYPE_FROM_RES_ID = 4098;
        public static final int TYPE_FROM_RES_NAME = 4099;
        public static final int TYPE_FROM_SD_FILE = 4097;
        public Bitmap bitmap;
        public int type;

        public BitmapInfo(int n, Bitmap bitmap) {
            this.bitmap = bitmap;
            this.type = n;
        }
    }
}

