/*
 * Decompiled with CFR 0.152.
 */
package com.james.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Iterator;

public class LogUtils {
    private static TextView debugTextView;
    private static ArrayList<String> logs;
    private static Context sContext;
    private static boolean sIsShowing = false;
    private static boolean show;

    static {
        logs = new ArrayList();
        show = true;
    }

    public static void d(String string2, String string3) {
        if (show) {
            Log.d((String)string2, (String)string3);
        }
    }

    public static void disable() {
        show = false;
    }

    public static void e(String string2, String string3) {
        if (show) {
            Log.e((String)string2, (String)string3);
        }
    }

    public static void enable() {
        show = true;
    }

    public static void i(String string2, String string3) {
        if (show) {
            Log.i((String)string2, (String)string3);
        }
    }

    public static void init(Context context) {
        sContext = context;
    }

    public static boolean isShowing() {
        return sIsShowing;
    }

    public static void showDebugView(boolean bl) {
        Context context = sContext;
        if (context == null) {
            return;
        }
        sIsShowing = bl;
        if (!bl) {
            if (debugTextView != null) {
                ((WindowManager)context.getSystemService("window")).removeView((View)debugTextView);
                debugTextView = null;
            }
            return;
        }
        try {
            context = (WindowManager)context.getSystemService("window");
            if (debugTextView == null) {
                TextView textView;
                debugTextView = textView = new TextView(sContext);
                textView.setTextColor(-16711936);
                debugTextView.setBackgroundColor(-1724697805);
                debugTextView.setTextSize(10.0f);
                textView = new WindowManager.LayoutParams();
                textView.type = 2002;
                textView.format = 1;
                textView.flags = 56;
                textView.gravity = 80;
                textView.width = -1;
                textView.height = -2;
                context.addView((View)debugTextView, (ViewGroup.LayoutParams)textView);
            }
            LogUtils.updateLogText();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateLogText() {
        Object object = debugTextView;
        if (object == null) return;
        if (!object.isShown()) {
            return;
        }
        object = "";
        try {
            Iterator<String> iterator2 = logs.iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    debugTextView.setText((CharSequence)object);
                    return;
                }
                String string2 = iterator2.next();
                if (TextUtils.isEmpty((CharSequence)object)) {
                    object = string2;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)object);
                stringBuilder.append("\n");
                stringBuilder.append(string2);
                object = stringBuilder.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void v(String string2, String string3) {
        if (show) {
            Log.v((String)string2, (String)string3);
        }
    }

    public static void w(String string2, String string3) {
        if (show) {
            Log.w((String)string2, (String)string3);
        }
    }
}

