/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.graphics.Camera;
import android.graphics.Matrix;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.Transformation;
import android.widget.Gallery;
import android.widget.ImageView;

public class AdvancedGallery
extends Gallery {
    private boolean isImageViewOnly;
    private boolean mAlphaMode = false;
    private Camera mCamera = new Camera();
    private boolean mCircleYMode = false;
    private int mCoveflowCenter;
    private int mMaxRotationAngle = 60;
    private int mMaxZoom = -360;
    private boolean mPyrMode = false;
    private boolean mScaleMode = false;
    private int monitorHeight;
    private int monitorWidth;

    public AdvancedGallery(Context context) {
        super(context);
        this.setStaticTransformationsEnabled(true);
        this.isImageViewOnly = true;
        this.setup();
    }

    public AdvancedGallery(Context context, boolean bl) {
        super(context);
        this.setStaticTransformationsEnabled(true);
        this.isImageViewOnly = bl;
        this.setup();
    }

    private int getCenterOfCoverflow() {
        return (this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / 2 + this.getPaddingLeft();
    }

    private int getCenterOfView(View view) {
        return view.getLeft() + view.getWidth() / 2;
    }

    private void setup() {
        this.setSpacing(0);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        this.monitorWidth = displayMetrics.widthPixels;
        this.monitorHeight = displayMetrics.heightPixels;
    }

    private void transformImageBitmap(View view, Transformation transformation, int n) {
        float f;
        this.mCamera.save();
        transformation = transformation.getMatrix();
        int n2 = view.getHeight();
        int n3 = view.getWidth();
        int n4 = Math.abs(n);
        if (this.mAlphaMode && this.isImageViewOnly) {
            ((ImageView)view).setAlpha((int)(255.0 - (double)n4 * 2.5));
        }
        if (this.mScaleMode) {
            f = n4 * 3;
            this.mCamera.translate(0.0f, 0.0f, f);
        }
        if (this.mPyrMode) {
            this.mCamera.translate(0.0f, (float)(-n4), 0.0f);
        }
        if (this.mCircleYMode) {
            this.mCamera.rotateY((float)(-n));
        }
        this.mCamera.getMatrix((Matrix)transformation);
        n = n3 / 2;
        f = -n;
        transformation.preTranslate(f, (float)(-(n2 /= 2)));
        transformation.postTranslate((float)n, (float)n2);
        this.mCamera.restore();
    }

    public boolean getAlphaMode() {
        return this.mAlphaMode;
    }

    protected boolean getChildStaticTransformation(View view, Transformation transformation) {
        int n = this.getCenterOfView(view);
        int n2 = view.getWidth();
        transformation.clear();
        transformation.setTransformationType(2);
        if (Math.abs(n - this.mCoveflowCenter) < n2 / 2) {
            this.transformImageBitmap(view, transformation, 0);
        } else {
            n2 /= 3;
            if (n > this.mCoveflowCenter) {
                this.transformImageBitmap(view, transformation, n2);
            } else {
                this.transformImageBitmap(view, transformation, -n2);
            }
        }
        return true;
    }

    public boolean getCircleYMode() {
        return this.mCircleYMode;
    }

    public int getMaxRotationAngle() {
        return this.mMaxRotationAngle;
    }

    public int getMaxZoom() {
        return this.mMaxZoom;
    }

    public boolean getPyrMode() {
        return this.mPyrMode;
    }

    public boolean getScaleMode() {
        return this.mScaleMode;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.mCoveflowCenter = this.getCenterOfCoverflow();
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void setAlphaMode(boolean bl) {
        this.mAlphaMode = bl;
    }

    public void setCircleYMode(boolean bl) {
        this.mCircleYMode = bl;
    }

    public void setMaxRotationAngle(int n) {
        this.mMaxRotationAngle = n;
    }

    public void setMaxZoom(int n) {
        this.mMaxZoom = n;
    }

    public void setPyrMode(boolean bl) {
        this.mPyrMode = bl;
    }

    public void setScaleMode(boolean bl) {
        this.mScaleMode = bl;
    }
}

