/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.Gallery;
import android.widget.GridView;
import android.widget.ListView;
import java.util.ArrayList;

public abstract class FreeAdapter<T, V extends View>
extends BaseAdapter {
    public static final int TO_HEIGHT = 4097;
    public static final int TO_WIDTH = 4096;
    private ArrayList<T> arrayList;
    protected int defaultSize;
    private Context mContext;
    protected int monitorHeight;
    protected int monitorWidth;
    protected int picSize = 750;

    public FreeAdapter(Context context, int n, ArrayList<T> arrayList) {
        this.mContext = context;
        this.arrayList = arrayList;
        this.setDatum(n);
    }

    public FreeAdapter(Context context, ArrayList<T> arrayList) {
        this.mContext = context;
        this.arrayList = arrayList;
        this.setup();
    }

    public FreeAdapter(Context object2, T[] TArray) {
        this.mContext = object2;
        this.arrayList = new ArrayList();
        for (Object object2 : TArray) {
            this.arrayList.add(object2);
        }
        this.setup();
    }

    private void setup() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        this.monitorWidth = displayMetrics.widthPixels;
        this.monitorHeight = displayMetrics.heightPixels;
        this.defaultSize = this.monitorWidth;
    }

    public void addItem(T t) {
        this.arrayList.add(t);
        this.notifyDataSetChanged();
    }

    public void addItems(ArrayList<T> arrayList) {
        this.arrayList.addAll(arrayList);
        this.notifyDataSetChanged();
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getCount() {
        return this.arrayList.size();
    }

    public T getItem(int n) {
        return this.arrayList.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    public ArrayList<T> getItems() {
        return this.arrayList;
    }

    public View getView(int n, View object, ViewGroup viewGroup) {
        View view = object;
        if (object == null) {
            int n2;
            object = this.initView(n);
            if (object.getLayoutParams() == null) {
                if (viewGroup instanceof ListView) {
                    object.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-2, -2));
                } else if (viewGroup instanceof GridView) {
                    object.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-2, -2));
                } else if (viewGroup instanceof Gallery) {
                    object.setLayoutParams((ViewGroup.LayoutParams)new Gallery.LayoutParams(-2, -2));
                } else {
                    object.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
                }
            }
            if ((n2 = object.getLayoutParams().width) != -2 && n2 != -1) {
                object.getLayoutParams().width = (int)((float)(n2 * this.defaultSize) / (float)this.picSize + 0.5f);
            }
            n2 = object.getLayoutParams().height;
            view = object;
            if (n2 != -2) {
                view = object;
                if (n2 != -1) {
                    object.getLayoutParams().height = (int)((float)(n2 * this.defaultSize) / (float)this.picSize + 0.5f);
                    view = object;
                }
            }
        }
        this.setView(n, view);
        return view;
    }

    public abstract V initView(int var1);

    public void removeItem(int n) {
        this.arrayList.remove(n);
        this.notifyDataSetChanged();
    }

    public void removeItem(T t) {
        this.arrayList.remove(t);
        this.notifyDataSetChanged();
    }

    protected int resize(int n) {
        return (int)((float)(n * this.defaultSize) / (float)this.picSize + 0.5f);
    }

    public void setDatum(int n) {
        this.setPicSize(-1, -1, n);
    }

    public void setItem(int n, T t) {
        this.arrayList.set(n, t);
        this.notifyDataSetChanged();
    }

    public void setPicSize(int n) {
        this.setPicSize(n, -1, 4096);
    }

    public void setPicSize(int n, int n2) {
        this.setPicSize(n, n2, 4096);
    }

    public void setPicSize(int n, int n2, int n3) {
        int n4;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        this.monitorWidth = displayMetrics.widthPixels;
        this.monitorHeight = n4 = displayMetrics.heightPixels;
        if (n3 == 4096) {
            this.defaultSize = this.monitorWidth;
            if (n != -1) {
                this.picSize = n;
            }
        } else if (n3 == 4097) {
            this.defaultSize = n4;
            if (n2 != -1) {
                this.picSize = n2;
            }
        }
    }

    public abstract void setView(int var1, V var2);
}

