/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.io.InputStream;

public class FreeImageView
extends ImageView {
    private Bitmap mCurrentBitmap;
    private int mCurrentResid;
    private FreeScaleType mScaleType;

    public FreeImageView(Context object) {
        super(object);
        object = FreeScaleType.CENTER;
        this.mScaleType = object;
        this.setScaleType((FreeScaleType)((Object)object));
    }

    public static int dip2px(Context context, float f) {
        return (int)(f * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static int px2dip(Context context, float f) {
        return (int)(f / context.getResources().getDisplayMetrics().density + 0.5f);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        Bitmap bitmap = this.mCurrentBitmap;
        if (bitmap != null && !bitmap.isRecycled() && n > 0 && n2 > 0) {
            if (this.mScaleType == FreeScaleType.MATCH_TOP) {
                Bitmap bitmap2 = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap2);
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                bitmap = new Matrix();
                bitmap.setScale((float)bitmap2.getWidth() / (float)this.mCurrentBitmap.getWidth(), (float)bitmap2.getWidth() / (float)this.mCurrentBitmap.getWidth());
                canvas.drawBitmap(this.mCurrentBitmap, (Matrix)bitmap, new Paint());
                super.setImageBitmap(bitmap2);
            } else if (this.mScaleType == FreeScaleType.MATCH_BOTTOM) {
                bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                Matrix matrix = new Matrix();
                matrix.postScale((float)bitmap.getWidth() / (float)this.mCurrentBitmap.getWidth(), (float)bitmap.getWidth() / (float)this.mCurrentBitmap.getWidth());
                matrix.postTranslate(0.0f, (float)bitmap.getHeight() - (float)(this.mCurrentBitmap.getHeight() * bitmap.getWidth()) / (float)this.mCurrentBitmap.getWidth());
                canvas.drawBitmap(this.mCurrentBitmap, matrix, new Paint());
                super.setImageBitmap(bitmap);
            } else if (this.mScaleType == FreeScaleType.MATCH_LEFT) {
                bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                Matrix matrix = new Matrix();
                matrix.postScale((float)bitmap.getHeight() / (float)this.mCurrentBitmap.getHeight(), (float)bitmap.getHeight() / (float)this.mCurrentBitmap.getHeight());
                canvas.drawBitmap(this.mCurrentBitmap, matrix, new Paint());
                super.setImageBitmap(bitmap);
            } else if (this.mScaleType == FreeScaleType.MATCH_RIGHT) {
                bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                Matrix matrix = new Matrix();
                matrix.postScale((float)bitmap.getHeight() / (float)this.mCurrentBitmap.getHeight(), (float)bitmap.getHeight() / (float)this.mCurrentBitmap.getHeight());
                matrix.postTranslate((float)bitmap.getWidth() - (float)(this.mCurrentBitmap.getWidth() * bitmap.getHeight()) / (float)this.mCurrentBitmap.getHeight(), 0.0f);
                canvas.drawBitmap(this.mCurrentBitmap, matrix, new Paint());
                super.setImageBitmap(bitmap);
            }
        }
    }

    public void setImageBitmap(Bitmap bitmap) {
        if (this.mScaleType == FreeScaleType.MATCH_TOP) {
            this.mCurrentBitmap = bitmap;
        } else if (this.mScaleType == FreeScaleType.MATCH_BOTTOM) {
            this.mCurrentBitmap = bitmap;
        } else if (this.mScaleType == FreeScaleType.MATCH_LEFT) {
            this.mCurrentBitmap = bitmap;
        } else if (this.mScaleType == FreeScaleType.MATCH_RIGHT) {
            this.mCurrentBitmap = bitmap;
        } else {
            super.setImageBitmap(bitmap);
        }
    }

    public void setImageResource(int n) {
        if (this.mCurrentResid == n) {
            return;
        }
        this.mCurrentBitmap = null;
        if (this.mScaleType == FreeScaleType.MATCH_TOP) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            this.setImageBitmap(BitmapFactory.decodeStream((InputStream)this.getContext().getResources().openRawResource(n), null, (BitmapFactory.Options)options));
        } else if (this.mScaleType == FreeScaleType.MATCH_BOTTOM) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            this.setImageBitmap(BitmapFactory.decodeStream((InputStream)this.getContext().getResources().openRawResource(n), null, (BitmapFactory.Options)options));
        } else if (this.mScaleType == FreeScaleType.MATCH_LEFT) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            this.setImageBitmap(BitmapFactory.decodeStream((InputStream)this.getContext().getResources().openRawResource(n), null, (BitmapFactory.Options)options));
        } else if (this.mScaleType == FreeScaleType.MATCH_RIGHT) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            this.setImageBitmap(BitmapFactory.decodeStream((InputStream)this.getContext().getResources().openRawResource(n), null, (BitmapFactory.Options)options));
        } else {
            super.setImageResource(n);
        }
    }

    public void setImageSizeInDp(int n, int n2) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            new ViewGroup.LayoutParams(FreeImageView.dip2px(this.getContext(), n), FreeImageView.dip2px(this.getContext(), n2));
        } else {
            layoutParams.width = FreeImageView.dip2px(this.getContext(), n);
            layoutParams.height = FreeImageView.dip2px(this.getContext(), n2);
        }
        this.postInvalidate();
    }

    public void setScaleType(FreeScaleType freeScaleType) {
        this.mScaleType = freeScaleType;
        switch (1.$SwitchMap$com$james$views$FreeImageView$FreeScaleType[freeScaleType.ordinal()]) {
            default: {
                super.setScaleType(ImageView.ScaleType.CENTER);
                break;
            }
            case 8: {
                super.setScaleType(ImageView.ScaleType.MATRIX);
                break;
            }
            case 7: {
                super.setScaleType(ImageView.ScaleType.FIT_XY);
                break;
            }
            case 6: {
                super.setScaleType(ImageView.ScaleType.FIT_START);
                break;
            }
            case 5: {
                super.setScaleType(ImageView.ScaleType.FIT_END);
                break;
            }
            case 4: {
                super.setScaleType(ImageView.ScaleType.FIT_CENTER);
                break;
            }
            case 3: {
                super.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                break;
            }
            case 2: {
                super.setScaleType(ImageView.ScaleType.CENTER_CROP);
                break;
            }
            case 1: {
                super.setScaleType(ImageView.ScaleType.CENTER);
            }
        }
        this.postInvalidate();
    }

    public static final class FreeScaleType
    extends Enum<FreeScaleType> {
        private static final /* synthetic */ FreeScaleType[] $VALUES;
        public static final /* enum */ FreeScaleType CENTER;
        public static final /* enum */ FreeScaleType CENTER_CROP;
        public static final /* enum */ FreeScaleType CENTER_INSIDE;
        public static final /* enum */ FreeScaleType FIT_CENTER;
        public static final /* enum */ FreeScaleType FIT_END;
        public static final /* enum */ FreeScaleType FIT_START;
        public static final /* enum */ FreeScaleType FIT_XY;
        public static final /* enum */ FreeScaleType MATCH_BOTTOM;
        public static final /* enum */ FreeScaleType MATCH_LEFT;
        public static final /* enum */ FreeScaleType MATCH_RIGHT;
        public static final /* enum */ FreeScaleType MATCH_TOP;
        public static final /* enum */ FreeScaleType MATRIX;

        static {
            FreeScaleType freeScaleType;
            FreeScaleType freeScaleType2;
            FreeScaleType freeScaleType3;
            FreeScaleType freeScaleType4;
            FreeScaleType freeScaleType5;
            FreeScaleType freeScaleType6;
            FreeScaleType freeScaleType7;
            FreeScaleType freeScaleType8;
            FreeScaleType freeScaleType9;
            FreeScaleType freeScaleType10;
            FreeScaleType freeScaleType11;
            FreeScaleType freeScaleType12;
            CENTER = freeScaleType12 = new FreeScaleType();
            CENTER_CROP = freeScaleType11 = new FreeScaleType();
            CENTER_INSIDE = freeScaleType10 = new FreeScaleType();
            FIT_CENTER = freeScaleType9 = new FreeScaleType();
            FIT_END = freeScaleType8 = new FreeScaleType();
            FIT_START = freeScaleType7 = new FreeScaleType();
            FIT_XY = freeScaleType6 = new FreeScaleType();
            MATRIX = freeScaleType5 = new FreeScaleType();
            MATCH_TOP = freeScaleType4 = new FreeScaleType();
            MATCH_BOTTOM = freeScaleType3 = new FreeScaleType();
            MATCH_LEFT = freeScaleType2 = new FreeScaleType();
            MATCH_RIGHT = freeScaleType = new FreeScaleType();
            $VALUES = new FreeScaleType[]{freeScaleType12, freeScaleType11, freeScaleType10, freeScaleType9, freeScaleType8, freeScaleType7, freeScaleType6, freeScaleType5, freeScaleType4, freeScaleType3, freeScaleType2, freeScaleType};
        }

        public static FreeScaleType valueOf(String string2) {
            return Enum.valueOf(FreeScaleType.class, string2);
        }

        public static FreeScaleType[] values() {
            return (FreeScaleType[])$VALUES.clone();
        }
    }
}

