/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TabHost;
import android.widget.TabWidget;
import java.util.HashMap;
import java.util.Locale;

public class FreeLayout
extends RelativeLayout {
    public static int HORIZONTAL = 0;
    public static final int TO_HEIGHT = 4097;
    public static final int TO_WIDTH = 4096;
    public static int VERTICAL = 1;
    protected DisplayMetrics dm;
    protected int id = 22423;
    protected int idContent = 24576;
    protected int idHandle = 20480;
    protected int layoutHeight;
    protected int layoutWidth;
    protected Context mContext;
    private OnSizedChangedListener mOnSizedChangedListener;
    private HashMap<View, View> map = new HashMap();
    protected int monitorHeight;
    protected int monitorWidth;
    protected int picSize = 750;
    protected int windowSize;

    public FreeLayout(Context context) {
        super(context);
        this.mContext = context;
        this.dm = new DisplayMetrics();
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics(this.dm);
        this.monitorWidth = this.dm.widthPixels;
        this.monitorHeight = this.dm.heightPixels;
        this.windowSize = this.monitorWidth;
    }

    public FreeLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.dm = new DisplayMetrics();
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics(this.dm);
        this.monitorWidth = this.dm.widthPixels;
        this.monitorHeight = this.dm.heightPixels;
        this.windowSize = this.monitorWidth;
    }

    public FreeLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mContext = context;
        this.dm = new DisplayMetrics();
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics(this.dm);
        this.monitorWidth = this.dm.widthPixels;
        this.monitorHeight = this.dm.heightPixels;
        this.windowSize = this.monitorWidth;
    }

    public static boolean isArab() {
        return Locale.getDefault().getLanguage().equals(new Locale("ar").getLanguage());
    }

    public static int px2dip(Context context, float f) {
        return (int)(f / context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public FreeLayout addFreeHorizontalScrollView(HorizontalScrollView horizontalScrollView, int n, int n2) {
        ++this.id;
        FreeLayout freeLayout = new FreeLayout(horizontalScrollView.getContext());
        freeLayout.setId(this.id);
        freeLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        linearLayout.setOrientation(0);
        horizontalScrollView.setHorizontalScrollBarEnabled(false);
        horizontalScrollView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        if (n != -1 && n != -2) {
            horizontalScrollView.getLayoutParams().width = n = (int)((float)(n * this.windowSize) / (float)this.picSize + 0.5f);
            linearLayout.getLayoutParams().width = n;
            freeLayout.getLayoutParams().width = n;
        }
        if (n2 != -1 && n2 != -2) {
            horizontalScrollView.getLayoutParams().height = n = (int)((float)(n2 * this.windowSize) / (float)this.picSize + 0.5f);
            linearLayout.getLayoutParams().height = n;
            freeLayout.getLayoutParams().height = n;
        }
        linearLayout.addView((View)freeLayout);
        horizontalScrollView.addView((View)linearLayout);
        this.addView((View)horizontalScrollView);
        return freeLayout;
    }

    public FreeLayout addFreeHorizontalScrollView(FreeLayout freeLayout, int n, int n2) {
        int n3;
        this.id = n3 = this.id + 1;
        freeLayout.setId(n3);
        freeLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        linearLayout.setOrientation(0);
        HorizontalScrollView horizontalScrollView = new HorizontalScrollView(this.mContext);
        horizontalScrollView.setHorizontalScrollBarEnabled(false);
        horizontalScrollView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        if (n != -1 && n != -2) {
            horizontalScrollView.getLayoutParams().width = n = (int)((float)(n * this.windowSize) / (float)this.picSize + 0.5f);
            linearLayout.getLayoutParams().width = n;
            freeLayout.getLayoutParams().width = n;
        }
        if (n2 != -1 && n2 != -2) {
            horizontalScrollView.getLayoutParams().height = n = (int)((float)(n2 * this.windowSize) / (float)this.picSize + 0.5f);
            linearLayout.getLayoutParams().height = n;
            freeLayout.getLayoutParams().height = n;
        }
        linearLayout.addView((View)freeLayout);
        horizontalScrollView.addView((View)linearLayout);
        this.addView((View)horizontalScrollView);
        return freeLayout;
    }

    public View addFreeLinearView(LinearLayout linearLayout, View view, int n, int n2) {
        return this.addFreeLinearView(linearLayout, view, n, n2, -1.0f);
    }

    public View addFreeLinearView(LinearLayout linearLayout, View view, int n, int n2, float f) {
        int n3;
        this.id = n3 = this.id + 1;
        view.setId(n3);
        if (f != -1.0f) {
            view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n, n2, f));
        } else {
            view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(n, n2));
        }
        if (n != -1 && n != -2) {
            view.getLayoutParams().width = n = (int)((float)(n * this.windowSize) / (float)this.picSize + 0.5f);
        }
        if (n2 != -1 && n2 != -2) {
            view.getLayoutParams().height = n = (int)((float)(n2 * this.windowSize) / (float)this.picSize + 0.5f);
        }
        linearLayout.addView(view);
        return view;
    }

    public FreeLayout addFreeScrollView(ScrollView scrollView, int n, int n2) {
        ++this.id;
        FreeLayout freeLayout = new FreeLayout(scrollView.getContext());
        freeLayout.setId(this.id);
        freeLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        scrollView.setHorizontalScrollBarEnabled(false);
        scrollView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        if (n != -1 && n != -2) {
            scrollView.getLayoutParams().width = n = (int)((float)(n * this.windowSize) / (float)this.picSize + 0.5f);
            linearLayout.getLayoutParams().width = n;
            freeLayout.getLayoutParams().width = n;
        }
        if (n2 != -1 && n2 != -2) {
            scrollView.getLayoutParams().height = n = (int)((float)(n2 * this.windowSize) / (float)this.picSize + 0.5f);
            linearLayout.getLayoutParams().height = n;
            freeLayout.getLayoutParams().height = n;
        }
        linearLayout.addView((View)freeLayout);
        scrollView.addView((View)linearLayout);
        this.addView((View)scrollView);
        return freeLayout;
    }

    public FreeLayout addFreeScrollView(FreeLayout freeLayout, int n, int n2) {
        int n3;
        this.id = n3 = this.id + 1;
        freeLayout.setId(n3);
        freeLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        ScrollView scrollView = new ScrollView(this.mContext);
        scrollView.setHorizontalScrollBarEnabled(false);
        scrollView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        if (n != -1 && n != -2) {
            scrollView.getLayoutParams().width = n = (int)((float)(n * this.windowSize) / (float)this.picSize + 0.5f);
            linearLayout.getLayoutParams().width = n;
            freeLayout.getLayoutParams().width = n;
        }
        if (n2 != -1 && n2 != -2) {
            scrollView.getLayoutParams().height = n = (int)((float)(n2 * this.windowSize) / (float)this.picSize + 0.5f);
            linearLayout.getLayoutParams().height = n;
            freeLayout.getLayoutParams().height = n;
        }
        linearLayout.addView((View)freeLayout);
        scrollView.addView((View)linearLayout);
        this.addView((View)scrollView);
        return freeLayout;
    }

    public View addFreeView(View view, int n, int n2) {
        return this.addFreeView(view, n, n2, null, null, null, null, null);
    }

    public View addFreeView(View view, int n, int n2, int n3, int n4) {
        ++this.id;
        View view2 = new View(this.mContext);
        view2.setId(this.id);
        int n5 = this.windowSize;
        float f = n * n5;
        n = this.picSize;
        view2.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)(f / (float)n + 0.5f), (int)((float)(n2 * n5) / (float)n + 0.5f)));
        this.addView(view2);
        this.id = n = this.id + 1;
        view.setId(n);
        this.map.put(view, view2);
        view.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n3, n4));
        if (n3 != -1 && n3 != -2) {
            view.getLayoutParams().width = n = (int)((float)(n3 * this.windowSize) / (float)this.picSize + 0.5f);
        }
        if (n4 != -1 && n4 != -2) {
            view.getLayoutParams().height = n = (int)((float)(n4 * this.windowSize) / (float)this.picSize + 0.5f);
        }
        ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(3, view2.getId());
        ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(17, view2.getId());
        this.addView(view);
        if (view.getClass().equals(TabHost.class)) {
            view2 = new LinearLayout(this.mContext);
            view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            view2.setOrientation(1);
            TabWidget tabWidget = new TabWidget(this.mContext);
            tabWidget.setId(16908307);
            tabWidget.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            view2.addView((View)tabWidget);
            tabWidget = new FrameLayout(this.mContext);
            tabWidget.setId(0x1020011);
            view2.addView((View)tabWidget);
            ((TabHost)view).addView(view2);
        }
        return view;
    }

    public View addFreeView(View view, int n, int n2, View view2, int[] nArray) {
        return this.addFreeView(view, n, n2, null, view2, nArray, null, null);
    }

    public View addFreeView(View view, int n, int n2, View view2, int[] nArray, View view3, int[] nArray2) {
        return this.addFreeView(view, n, n2, null, view2, nArray, view3, nArray2);
    }

    public View addFreeView(View view, int n, int n2, int[] nArray) {
        return this.addFreeView(view, n, n2, nArray, null, null, null, null);
    }

    public View addFreeView(View view, int n, int n2, int[] nArray, View view2, int[] nArray2) {
        return this.addFreeView(view, n, n2, nArray, view2, nArray2, null, null);
    }

    public View addFreeView(View view, int n, int n2, int[] object, View view2, int[] nArray, View view3, int[] nArray2) {
        int n3;
        this.id = n3 = this.id + 1;
        view.setId(n3);
        view.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        if (n != -1 && n != -2) {
            view.getLayoutParams().width = n = (int)((float)(n * this.windowSize) / (float)this.picSize + 0.5f);
        }
        if (n2 != -1 && n2 != -2) {
            view.getLayoutParams().height = n = (int)((float)(n2 * this.windowSize) / (float)this.picSize + 0.5f);
        }
        n2 = 0;
        if (object != null) {
            for (n = 0; n < ((int[])object).length; ++n) {
                ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(object[n]);
            }
        }
        if (nArray != null && view2 != null) {
            for (n = 0; n < nArray.length; ++n) {
                ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(nArray[n], view2.getId());
            }
        }
        if (nArray2 != null && view3 != null) {
            for (n = n2; n < nArray2.length; ++n) {
                ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(nArray2[n], view3.getId());
            }
        }
        this.addView(view);
        if (view.getClass().equals(TabHost.class)) {
            object = new LinearLayout(this.mContext);
            object.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            object.setOrientation(1);
            view2 = new TabWidget(this.mContext);
            view2.setId(16908307);
            view2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            object.addView(view2);
            view2 = new FrameLayout(this.mContext);
            view2.setId(0x1020011);
            object.addView(view2);
            ((TabHost)view).addView((View)object);
        }
        return view;
    }

    public int dp2px(float f) {
        return (int)(f * this.getContext().getResources().getDisplayMetrics().density + 0.5f);
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.layoutWidth = this.getWidth();
        this.layoutHeight = this.getHeight();
        OnSizedChangedListener onSizedChangedListener = this.mOnSizedChangedListener;
        if (onSizedChangedListener != null) {
            onSizedChangedListener.onSizedChanged(n, n2, n3, n4);
        }
    }

    public int reverseScale(int n) {
        return n * this.picSize / this.windowSize;
    }

    public void setDatum(int n) {
        this.setPicSize(-1, -1, n);
    }

    public void setFreeLayoutFF() {
        if (this.getLayoutParams() != null) {
            this.getLayoutParams().width = -1;
            this.getLayoutParams().height = -1;
        } else {
            this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        }
    }

    public void setFreeLayoutFW() {
        if (this.getLayoutParams() != null) {
            this.getLayoutParams().width = -1;
            this.getLayoutParams().height = -2;
        } else {
            this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        }
    }

    public void setFreeLayoutWF() {
        if (this.getLayoutParams() != null) {
            this.getLayoutParams().width = -2;
            this.getLayoutParams().height = -1;
        } else {
            this.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
        }
    }

    public void setFreeLayoutWW() {
        if (this.getLayoutParams() != null) {
            this.getLayoutParams().width = -2;
            this.getLayoutParams().height = -2;
        } else {
            this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        }
    }

    public void setFreeView(View view, int n, int n2) {
        this.setFreeView(view, n, n2, null, null, null, null, null);
    }

    public void setFreeView(View view, int n, int n2, int n3, int n4) {
        if (view == null) {
            return;
        }
        FreeLayout freeLayout = (FreeLayout)view.getParent();
        View view2 = freeLayout.map.get(view);
        if (view2 == null) {
            ++freeLayout.id;
            view2 = new View(this.mContext);
            view2.setId(freeLayout.id);
            int n5 = this.windowSize;
            float f = n * n5;
            n = this.picSize;
            view2.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams((int)(f / (float)n + 0.5f), (int)((float)(n2 * n5) / (float)n + 0.5f)));
            n5 = 0;
            n = 0;
            while (true) {
                n2 = n5;
                if (n >= freeLayout.getChildCount()) break;
                if (freeLayout.getChildAt(n).equals(view)) {
                    n2 = n;
                    break;
                }
                ++n;
            }
            freeLayout.addView(view2, n2);
            freeLayout.map.put(view, view2);
        } else {
            view2.getLayoutParams().width = (int)((float)(n * this.windowSize) / (float)this.picSize + 0.5f);
            view2.getLayoutParams().height = (int)((float)(n2 * this.windowSize) / (float)this.picSize + 0.5f);
        }
        view.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n3, n4));
        view.getLayoutParams().width = n3;
        view.getLayoutParams().height = n4;
        if (n3 != -1 && n3 != -2) {
            view.getLayoutParams().width = n = (int)((float)(n3 * this.windowSize) / (float)this.picSize + 0.5f);
        }
        if (n4 != -1 && n4 != -2) {
            view.getLayoutParams().height = n = (int)((float)(n4 * this.windowSize) / (float)this.picSize + 0.5f);
        }
        ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(3, view2.getId());
        ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(17, view2.getId());
        this.requestLayout();
    }

    public void setFreeView(View view, int n, int n2, View view2, int[] nArray) {
        this.setFreeView(view, n, n2, null, view2, nArray, null, null);
    }

    public void setFreeView(View view, int n, int n2, View view2, int[] nArray, View view3, int[] nArray2) {
        this.setFreeView(view, n, n2, null, view2, nArray, view3, nArray2);
    }

    public void setFreeView(View view, int n, int n2, int[] nArray) {
        this.setFreeView(view, n, n2, nArray, null, null, null, null);
    }

    public void setFreeView(View view, int n, int n2, int[] nArray, View view2, int[] nArray2) {
        this.setFreeView(view, n, n2, nArray, view2, nArray2, null, null);
    }

    public void setFreeView(View view, int n, int n2, int[] nArray, View view2, int[] nArray2, View view3, int[] nArray3) {
        if (view == null) {
            return;
        }
        view.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        if (n != -1 && n != -2) {
            view.getLayoutParams().width = n = (int)((float)(n * this.windowSize) / (float)this.picSize + 0.5f);
        }
        if (n2 != -1 && n2 != -2) {
            view.getLayoutParams().height = n = (int)((float)(n2 * this.windowSize) / (float)this.picSize + 0.5f);
        }
        n2 = 0;
        if (nArray != null) {
            for (n = 0; n < nArray.length; ++n) {
                ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(nArray[n]);
            }
        }
        if (nArray2 != null && view2 != null) {
            for (n = 0; n < nArray2.length; ++n) {
                ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(nArray2[n], view2.getId());
            }
        }
        if (nArray3 != null && view3 != null) {
            for (n = n2; n < nArray3.length; ++n) {
                ((RelativeLayout.LayoutParams)view.getLayoutParams()).addRule(nArray3[n], view3.getId());
            }
        }
        this.requestLayout();
    }

    public void setHeightInDp(View view, float f) {
        view.getLayoutParams().height = this.dp2px(f);
    }

    public void setMargin(View view, int n, int n2, int n3, int n4) {
        if (FreeLayout.isArab()) {
            view = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            int n5 = this.windowSize;
            float f = n3 * n5;
            n3 = this.picSize;
            view.setMargins((int)(f / (float)n3 + 0.5f), (int)((float)(n2 * n5) / (float)n3 + 0.5f), (int)((float)(n * n5) / (float)n3 + 0.5f), (int)((float)(n4 * n5) / (float)n3 + 0.5f));
        } else {
            view = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            int n6 = this.windowSize;
            float f = n * n6;
            n = this.picSize;
            view.setMargins((int)(f / (float)n + 0.5f), (int)((float)(n2 * n6) / (float)n + 0.5f), (int)((float)(n3 * n6) / (float)n + 0.5f), (int)((float)(n4 * n6) / (float)n + 0.5f));
        }
    }

    public void setMarginInAbs(View view, int n, int n2, int n3, int n4) {
        if (FreeLayout.isArab()) {
            ((ViewGroup.MarginLayoutParams)view.getLayoutParams()).setMargins(n3, n2, n, n4);
        } else {
            ((ViewGroup.MarginLayoutParams)view.getLayoutParams()).setMargins(n, n2, n3, n4);
        }
    }

    public void setMarginInDp(View view, int n, int n2, int n3, int n4) {
        if (FreeLayout.isArab()) {
            ((ViewGroup.MarginLayoutParams)view.getLayoutParams()).setMargins(this.dp2px(n3), this.dp2px(n2), this.dp2px(n), this.dp2px(n4));
        } else {
            ((ViewGroup.MarginLayoutParams)view.getLayoutParams()).setMargins(this.dp2px(n), this.dp2px(n2), this.dp2px(n3), this.dp2px(n4));
        }
    }

    public void setOnSizedChangedListener(OnSizedChangedListener onSizedChangedListener) {
        this.mOnSizedChangedListener = onSizedChangedListener;
    }

    public void setPadding(View view, int n, int n2, int n3, int n4) {
        if (FreeLayout.isArab()) {
            int n5 = this.windowSize;
            float f = n3 * n5;
            n3 = this.picSize;
            view.setPadding((int)(f / (float)n3 + 0.5f), (int)((float)(n2 * n5) / (float)n3 + 0.5f), (int)((float)(n * n5) / (float)n3 + 0.5f), (int)((float)(n4 * n5) / (float)n3 + 0.5f));
        } else {
            int n6 = this.windowSize;
            float f = n * n6;
            n = this.picSize;
            view.setPadding((int)(f / (float)n + 0.5f), (int)((float)(n2 * n6) / (float)n + 0.5f), (int)((float)(n3 * n6) / (float)n + 0.5f), (int)((float)(n4 * n6) / (float)n + 0.5f));
        }
    }

    public void setPaddingInDp(View view, int n, int n2, int n3, int n4) {
        if (FreeLayout.isArab()) {
            view.setPadding(this.dp2px(n3), this.dp2px(n2), this.dp2px(n), this.dp2px(n4));
        } else {
            view.setPadding(this.dp2px(n), this.dp2px(n2), this.dp2px(n3), this.dp2px(n4));
        }
    }

    public void setPicSize(int n) {
        this.setPicSize(n, -1, 4096);
    }

    public void setPicSize(int n, int n2) {
        this.setPicSize(n, n2, 4096);
    }

    public void setPicSize(int n, int n2, int n3) {
        int n4;
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics(this.dm);
        this.monitorWidth = this.dm.widthPixels;
        this.monitorHeight = n4 = this.dm.heightPixels;
        if (n3 == 4096) {
            this.windowSize = this.monitorWidth;
            if (n != -1) {
                this.picSize = n;
            }
        } else if (n3 == 4097) {
            this.windowSize = n4;
            if (n2 != -1) {
                this.picSize = n2;
            }
        }
    }

    public void setWidthInDp(View view, float f) {
        view.getLayoutParams().width = this.dp2px(f);
    }

    public static interface OnSizedChangedListener {
        public void onSizedChanged(int var1, int var2, int var3, int var4);
    }
}

