/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

public class XmlBuilder {
    public static int HORIZONTAL = 0;
    public static final int TO_HEIGHT = 4097;
    public static final int TO_WIDTH = 4096;
    public static int VERTICAL = 1;
    private static XmlBuilder instance;
    protected DisplayMetrics dm;
    private Context mContext;
    private boolean mIsAutoAdjustText = false;
    private ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            if (Build.VERSION.SDK_INT >= 16) {
                XmlBuilder.this.mView.getViewTreeObserver().removeOnGlobalLayoutListener(XmlBuilder.this.mOnGlobalLayoutListener);
            } else {
                XmlBuilder.this.mView.getViewTreeObserver().removeGlobalOnLayoutListener(XmlBuilder.this.mOnGlobalLayoutListener);
            }
        }
    };
    private View mView;
    protected int monitorHeight;
    protected int monitorWidth;
    protected int picSize = 640;
    protected int windowSize;

    public XmlBuilder(Context context) {
        this.mContext = context;
    }

    private void adjustRecursively(View view) {
        ViewGroup viewGroup;
        for (int i = 0; i < (viewGroup = (ViewGroup)view).getChildCount(); ++i) {
            viewGroup = viewGroup.getChildAt(i);
            this.adjustView((View)viewGroup);
            if (!(viewGroup instanceof ViewGroup)) continue;
            this.adjustRecursively((View)viewGroup);
        }
    }

    private void adjustView(View view) {
        Log.v((String)this.getClass().getSimpleName(), (String)"adjustView");
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        int n = layoutParams.width;
        CharSequence charSequence = this.getClass().getSimpleName();
        CharSequence charSequence2 = new StringBuilder();
        charSequence2.append("layoutParams.width: ");
        charSequence2.append(layoutParams.width);
        Log.v((String)charSequence, (String)charSequence2.toString());
        if (n != -2 && n != -1) {
            layoutParams.width = n * this.windowSize / this.picSize;
        }
        n = layoutParams.height;
        charSequence2 = this.getClass().getSimpleName();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("layoutParams.height: ");
        ((StringBuilder)charSequence).append(layoutParams.height);
        Log.v((String)charSequence2, (String)((StringBuilder)charSequence).toString());
        if (n != -2 && n != -1) {
            layoutParams.height = n * this.windowSize / this.picSize;
        }
        view.setPadding(view.getPaddingLeft() * this.windowSize / this.picSize, view.getPaddingTop() * this.windowSize / this.picSize, view.getPaddingRight() * this.windowSize / this.picSize, view.getPaddingBottom() * this.windowSize / this.picSize);
        if (layoutParams instanceof RelativeLayout.LayoutParams) {
            charSequence = (RelativeLayout.LayoutParams)layoutParams;
            ((RelativeLayout.LayoutParams)charSequence).leftMargin = ((RelativeLayout.LayoutParams)charSequence).leftMargin * this.windowSize / this.picSize;
            ((RelativeLayout.LayoutParams)charSequence).topMargin = ((RelativeLayout.LayoutParams)charSequence).topMargin * this.windowSize / this.picSize;
            ((RelativeLayout.LayoutParams)charSequence).rightMargin = ((RelativeLayout.LayoutParams)charSequence).rightMargin * this.windowSize / this.picSize;
            ((RelativeLayout.LayoutParams)charSequence).bottomMargin = ((RelativeLayout.LayoutParams)charSequence).bottomMargin * this.windowSize / this.picSize;
        }
        if (layoutParams instanceof LinearLayout.LayoutParams) {
            charSequence = (LinearLayout.LayoutParams)layoutParams;
            ((LinearLayout.LayoutParams)charSequence).leftMargin = ((LinearLayout.LayoutParams)charSequence).leftMargin * this.windowSize / this.picSize;
            ((LinearLayout.LayoutParams)charSequence).topMargin = ((LinearLayout.LayoutParams)charSequence).topMargin * this.windowSize / this.picSize;
            ((LinearLayout.LayoutParams)charSequence).rightMargin = ((LinearLayout.LayoutParams)charSequence).rightMargin * this.windowSize / this.picSize;
            ((LinearLayout.LayoutParams)charSequence).bottomMargin = ((LinearLayout.LayoutParams)charSequence).bottomMargin * this.windowSize / this.picSize;
        }
        if (layoutParams instanceof FrameLayout.LayoutParams) {
            layoutParams = (FrameLayout.LayoutParams)layoutParams;
            layoutParams.leftMargin = layoutParams.leftMargin * this.windowSize / this.picSize;
            layoutParams.topMargin = layoutParams.topMargin * this.windowSize / this.picSize;
            layoutParams.rightMargin = layoutParams.rightMargin * this.windowSize / this.picSize;
            layoutParams.bottomMargin = layoutParams.bottomMargin * this.windowSize / this.picSize;
        }
        if (this.mIsAutoAdjustText) {
            if (view instanceof TextView) {
                layoutParams = (TextView)view;
                layoutParams.setTextSize(this.px2sp(layoutParams.getTextSize() * (float)this.windowSize / (float)this.picSize) - 1.0f);
            }
            if (view instanceof Button) {
                layoutParams = (Button)view;
                layoutParams.setTextSize(this.px2sp(layoutParams.getTextSize() * (float)this.windowSize / (float)this.picSize) - 1.0f);
            }
            if (view instanceof EditText) {
                view = (EditText)view;
                view.setTextSize(this.px2sp(view.getTextSize() * (float)this.windowSize / (float)this.picSize) - 1.0f);
            }
        }
    }

    public static XmlBuilder getInstance(Context context) {
        if (instance == null) {
            instance = new XmlBuilder(context);
        }
        instance.setup();
        return instance;
    }

    private float px2sp(float f) {
        return f / this.mContext.getResources().getDisplayMetrics().scaledDensity;
    }

    private void setup() {
        this.dm = new DisplayMetrics();
        ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(this.dm);
        this.monitorWidth = this.dm.widthPixels;
        this.monitorHeight = this.dm.heightPixels;
        this.windowSize = this.monitorWidth;
        this.mIsAutoAdjustText = false;
    }

    private void startAdjustView() {
        this.adjustView(this.mView);
        View view = this.mView;
        if (view instanceof ViewGroup) {
            this.adjustRecursively(view);
        }
        this.mView.postInvalidate();
    }

    public Context getContext() {
        return this.mContext;
    }

    public View inflate(int n) {
        View view;
        this.mView = view = ((LayoutInflater)this.getContext().getSystemService("layout_inflater")).inflate(n, null);
        view.getViewTreeObserver().addOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        return this.mView;
    }

    public View inflate(LayoutInflater layoutInflater, ViewGroup viewGroup, int n) {
        this.mView = layoutInflater.inflate(n, viewGroup, false);
        this.startAdjustView();
        return this.mView;
    }

    public XmlBuilder setAutoAdjustText(boolean bl) {
        this.mIsAutoAdjustText = bl;
        return this;
    }

    public XmlBuilder setPicSize(int n) {
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics(this.dm);
        this.monitorWidth = this.dm.widthPixels;
        this.monitorHeight = this.dm.heightPixels;
        this.windowSize = this.monitorWidth;
        if (n != -1) {
            this.picSize = n;
        }
        return this;
    }

    public XmlBuilder setPicSize(int n, int n2, int n3) {
        int n4;
        ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getMetrics(this.dm);
        this.monitorWidth = this.dm.widthPixels;
        this.monitorHeight = n4 = this.dm.heightPixels;
        if (n3 == 4096) {
            this.windowSize = this.monitorWidth;
            if (n != -1) {
                this.picSize = n;
            }
        } else if (n3 == 4097) {
            this.windowSize = n4;
            if (n2 != -1) {
                this.picSize = n2;
            }
        }
        return this;
    }
}

