/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core;

import android.content.Context;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;

public final class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE_IN_BYTES = 4096;
    private static final String LOG_TAG = "FileUtils";

    private FileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void deleteFile(File file) {
        if (!file.delete()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not delete file: ");
            stringBuilder.append(file);
            Log.w((String)LOG_TAG, (String)stringBuilder.toString());
        }
    }

    public static void deleteFirst(File[] fileArray, Comparator<File> object, int n) {
        Arrays.sort(fileArray, object);
        int n2 = Math.min(fileArray.length, n);
        for (n = 0; n < n2; ++n) {
            if (fileArray[n].delete()) continue;
            object = new StringBuilder();
            ((StringBuilder)object).append("Failed to delete file: ");
            ((StringBuilder)object).append(fileArray[n]);
            Log.w((String)LOG_TAG, (String)((StringBuilder)object).toString());
        }
    }

    public static File getFile(Context context, String string2) {
        return new File(context.getFilesDir(), string2);
    }

    public static File[] listAllFiles(File fileArray) {
        if (fileArray == null) {
            return new File[0];
        }
        if ((fileArray = fileArray.listFiles()) == null) {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFromFile(File object) throws FileNotFoundException {
        Throwable throwable2222222;
        InputStreamReader inputStreamReader;
        block10: {
            int n;
            inputStreamReader = new InputStreamReader(new FileInputStream((File)object));
            object = new StringWriter();
            char[] cArray = new char[4096];
            while ((n = inputStreamReader.read(cArray)) != -1) {
                ((StringWriter)object).write(cArray, 0, n);
            }
            {
                catch (Throwable throwable2222222) {
                    break block10;
                }
                catch (IOException iOException) {}
                {
                    Log.w((String)LOG_TAG, (String)iOException.toString());
                }
                try {}
                catch (IOException iOException) {
                    Log.e((String)LOG_TAG, (String)iOException.toString());
                    return ((StringWriter)object).toString();
                }
                ((Reader)inputStreamReader).close();
                return ((StringWriter)object).toString();
            }
            {
                ((Reader)inputStreamReader).close();
                return ((StringWriter)object).toString();
            }
        }
        try {
            ((Reader)inputStreamReader).close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)iOException.toString());
        }
        throw throwable2222222;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToFile(File object, String string2) throws IOException {
        Throwable throwable2222222;
        block9: {
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), "UTF-8");
            ((Writer)object).write(string2);
            ((OutputStreamWriter)object).flush();
            {
                catch (Throwable throwable2222222) {
                    break block9;
                }
                catch (IOException iOException) {}
                {
                    Log.e((String)LOG_TAG, (String)iOException.toString());
                }
                try {}
                catch (IOException iOException) {
                    Log.e((String)LOG_TAG, (String)iOException.toString());
                    return;
                }
                ((OutputStreamWriter)object).close();
                return;
            }
            {
                ((OutputStreamWriter)object).close();
                return;
            }
        }
        try {
            ((OutputStreamWriter)object).close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)iOException.toString());
        }
        throw throwable2222222;
    }

    public static final class LastModifiedComparator
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            long l = file.lastModified() - file2.lastModified();
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            l2 = l2 < 0 ? (long)-1 : (l2 == false ? (long)0 : (long)1);
            return (int)l2;
        }
    }
}

