/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.crashreporter;

import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReport {
    private static final String CRASH_EVENT = "mobile.crash";
    private static final String TAG = "MapboxCrashReport";
    private final JSONObject content;

    CrashReport(String string2) throws JSONException {
        this.content = new JSONObject(string2);
    }

    CrashReport(Calendar calendar) {
        this.content = new JSONObject();
        this.put("event", CRASH_EVENT);
        this.put("created", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US).format(calendar.getTimeInMillis()));
    }

    private void putNull(String string2) {
        try {
            this.content.put(string2, (Object)"null");
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)"Failed json encode null value");
        }
    }

    public String getDateString() {
        return this.getString("created");
    }

    JSONArray getJsonArray(String string2) {
        return this.content.optJSONArray(string2);
    }

    String getString(String string2) {
        return this.content.optString(string2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(String var1_1, Object var2_5) {
        synchronized (this) {
            block5: {
                if (var2_5 != null) ** GOTO lbl6
                try {
                    this.putNull(var1_1);
                    return;
lbl6:
                    // 1 sources

                    try {
                        this.content.put(var1_1, var2_5);
                    }
                    catch (JSONException var1_3) {
                        var1_4 = new StringBuilder();
                        var1_4.append("Failed json encode value: ");
                        var1_4.append(var2_5);
                        Log.e((String)"MapboxCrashReport", (String)var1_4.toString());
                    }
                }
                catch (Throwable var1_2) {
                    break block5;
                }
                return;
            }
            throw var1_2;
        }
    }

    public String toJson() {
        return this.content.toString();
    }
}

