/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.crashreporter;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.mapbox.android.core.FileUtils;
import com.mapbox.android.core.crashreporter.CrashReport;
import com.mapbox.android.core.crashreporter.CrashReportFactory;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;

public class MapboxUncaughtExceptionHanlder
implements Thread.UncaughtExceptionHandler,
SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String CRASH_FILENAME_FORMAT = "%s/%s.crash";
    private static final int DEFAULT_MAX_REPORTS = 10;
    public static final String MAPBOX_CRASH_REPORTER_PREFERENCES = "MapboxCrashReporterPrefs";
    public static final String MAPBOX_PREF_ENABLE_CRASH_REPORTER = "mapbox.crash.enable";
    private static final String TAG = "MbUncaughtExcHandler";
    private final Context applicationContext;
    final CrashReportFactory crashReportFactory;
    private final Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private final AtomicBoolean isEnabled = new AtomicBoolean(true);
    private final String mapboxPackage;

    MapboxUncaughtExceptionHanlder(Context object, SharedPreferences sharedPreferences, String string2, String string3, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            this.applicationContext = object;
            this.mapboxPackage = string2;
            this.defaultExceptionHandler = uncaughtExceptionHandler;
            this.crashReportFactory = new CrashReportFactory((Context)object, string2, string3, Collections.<String>emptySet());
            this.initializeSharedPreferences(sharedPreferences);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Invalid package name: ");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" or version: ");
        ((StringBuilder)object).append(string3);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    static void ensureDirectoryWritable(Context object, String string2) {
        if (!((File)(object = FileUtils.getFile((Context)object, string2))).exists()) {
            ((File)object).mkdir();
        }
        if (((Object)(object = FileUtils.listAllFiles((File)object))).length >= 10) {
            FileUtils.deleteFirst((File[])object, new FileUtils.LastModifiedComparator(), 9);
        }
    }

    static String getReportFileName(String string2, String string3) {
        return String.format(CRASH_FILENAME_FORMAT, string2, string3);
    }

    private void initializeSharedPreferences(SharedPreferences sharedPreferences) {
        try {
            this.isEnabled.set(sharedPreferences.getBoolean(MAPBOX_PREF_ENABLE_CRASH_REPORTER, true));
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)exception.toString());
        }
        sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public static void install(Context context, String string2, String string3) {
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        Thread.setDefaultUncaughtExceptionHandler(new MapboxUncaughtExceptionHanlder(context, context.getSharedPreferences(MAPBOX_CRASH_REPORTER_PREFERENCES, 0), string2, string3, Thread.getDefaultUncaughtExceptionHandler()));
    }

    boolean isEnabled() {
        return this.isEnabled.get();
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
        if (!MAPBOX_PREF_ENABLE_CRASH_REPORTER.equals(string2)) {
            return;
        }
        try {
            this.isEnabled.set(sharedPreferences.getBoolean(MAPBOX_PREF_ENABLE_CRASH_REPORTER, false));
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)exception.toString());
        }
    }

    @Override
    public void uncaughtException(Thread thread2, Throwable throwable) {
        Object object;
        if (this.isEnabled.get() && (object = this.crashReportFactory.createReportForCrash(thread2, throwable)) != null) {
            try {
                MapboxUncaughtExceptionHanlder.ensureDirectoryWritable(this.applicationContext, this.mapboxPackage);
                FileUtils.writeToFile(FileUtils.getFile(this.applicationContext, MapboxUncaughtExceptionHanlder.getReportFileName(this.mapboxPackage, ((CrashReport)object).getDateString())), ((CrashReport)object).toJson());
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)exception.toString());
            }
        }
        if ((object = this.defaultExceptionHandler) != null) {
            object.uncaughtException(thread2, throwable);
        } else {
            Log.i((String)TAG, (String)"Default exception handler is null");
        }
    }
}

