/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.location.LocationResult;
import com.mapbox.android.core.location.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LocationEngineResult {
    private static final String GOOGLE_PLAY_LOCATION_RESULT = "com.google.android.gms.location.LocationResult";
    private final List<Location> locations;

    private LocationEngineResult(List<Location> list) {
        this.locations = Collections.unmodifiableList(list);
    }

    public static LocationEngineResult create(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (location != null) {
            arrayList.add(location);
        }
        return new LocationEngineResult(arrayList);
    }

    public static LocationEngineResult create(List<Location> list) {
        if (list != null) {
            list = new ArrayList<Location>(list);
            list.removeAll(Collections.singleton(null));
            return new LocationEngineResult(list);
        }
        return new LocationEngineResult(Collections.<Location>emptyList());
    }

    private static LocationEngineResult extractAndroidResult(Intent object) {
        object = !LocationEngineResult.hasResult(object) ? null : LocationEngineResult.create((Location)object.getExtras().getParcelable("location"));
        return object;
    }

    private static LocationEngineResult extractGooglePlayResult(Intent object) {
        object = (object = LocationResult.extractResult((Intent)object)) != null ? LocationEngineResult.create(object.getLocations()) : null;
        return object;
    }

    public static LocationEngineResult extractResult(Intent intent) {
        LocationEngineResult locationEngineResult = Utils.isOnClasspath(GOOGLE_PLAY_LOCATION_RESULT) ? LocationEngineResult.extractGooglePlayResult(intent) : null;
        LocationEngineResult locationEngineResult2 = locationEngineResult;
        if (locationEngineResult == null) {
            locationEngineResult2 = LocationEngineResult.extractAndroidResult(intent);
        }
        return locationEngineResult2;
    }

    private static boolean hasResult(Intent intent) {
        boolean bl = intent != null && intent.hasExtra("location");
        return bl;
    }

    public Location getLastLocation() {
        Location location = this.locations.isEmpty() ? null : this.locations.get(0);
        return location;
    }

    public List<Location> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }
}

