/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.mapbox.android.core.location.AndroidLocationEngineImpl;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import com.mapbox.android.core.location.Utils;
import java.util.Iterator;

class MapboxFusedLocationEngineImpl
extends AndroidLocationEngineImpl {
    private static final String TAG = "MapboxLocationEngine";

    MapboxFusedLocationEngineImpl(Context context) {
        super(context);
    }

    private Location getBestLastLocation() {
        Iterator iterator2 = this.locationManager.getAllProviders().iterator();
        Location location = null;
        while (iterator2.hasNext()) {
            Location location2 = this.getLastLocationFor((String)iterator2.next());
            if (location2 == null || !Utils.isBetterLocation(location2, location)) continue;
            location = location2;
        }
        return location;
    }

    private boolean shouldStartNetworkProvider(int n) {
        boolean bl = true;
        if (n != 0 && n != 1 || !this.currentProvider.equals("gps")) {
            bl = false;
        }
        return bl;
    }

    @Override
    public LocationListener createListener(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
        return new MapboxLocationEngineCallbackTransport(locationEngineCallback);
    }

    @Override
    public void getLastLocation(LocationEngineCallback<LocationEngineResult> locationEngineCallback) throws SecurityException {
        Location location = this.getBestLastLocation();
        if (location != null) {
            locationEngineCallback.onSuccess(LocationEngineResult.create(location));
        } else {
            locationEngineCallback.onFailure(new Exception("Last location unavailable"));
        }
    }

    @Override
    public void requestLocationUpdates(LocationEngineRequest locationEngineRequest, PendingIntent pendingIntent) throws SecurityException {
        super.requestLocationUpdates(locationEngineRequest, pendingIntent);
        if (this.shouldStartNetworkProvider(locationEngineRequest.getPriority())) {
            try {
                this.locationManager.requestLocationUpdates("network", locationEngineRequest.getInterval(), locationEngineRequest.getDisplacement(), pendingIntent);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
    }

    @Override
    public void requestLocationUpdates(LocationEngineRequest locationEngineRequest, LocationListener locationListener, Looper looper) throws SecurityException {
        super.requestLocationUpdates(locationEngineRequest, locationListener, looper);
        if (this.shouldStartNetworkProvider(locationEngineRequest.getPriority())) {
            try {
                this.locationManager.requestLocationUpdates("network", locationEngineRequest.getInterval(), locationEngineRequest.getDisplacement(), locationListener, looper);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
    }

    private static final class MapboxLocationEngineCallbackTransport
    implements LocationListener {
        private final LocationEngineCallback<LocationEngineResult> callback;
        private Location currentBestLocation;

        MapboxLocationEngineCallbackTransport(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
            this.callback = locationEngineCallback;
        }

        public void onLocationChanged(Location location) {
            if (Utils.isBetterLocation(location, this.currentBestLocation)) {
                this.currentBestLocation = location;
            } else {
                location = null;
            }
            LocationEngineCallback<LocationEngineResult> locationEngineCallback = this.callback;
            if (locationEngineCallback != null) {
                if (location != null) {
                    locationEngineCallback.onSuccess(LocationEngineResult.create(location));
                } else {
                    locationEngineCallback.onFailure(new Exception("New location is significantly worse than the last one, skipping update."));
                }
            }
        }

        public void onProviderDisabled(String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("onProviderDisabled: ");
            stringBuilder.append(string2);
            Log.d((String)MapboxFusedLocationEngineImpl.TAG, (String)stringBuilder.toString());
        }

        public void onProviderEnabled(String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("onProviderEnabled: ");
            stringBuilder.append(string2);
            Log.d((String)MapboxFusedLocationEngineImpl.TAG, (String)stringBuilder.toString());
        }

        public void onStatusChanged(String string2, int n, Bundle object) {
            object = new StringBuilder();
            ((StringBuilder)object).append("onStatusChanged: ");
            ((StringBuilder)object).append(string2);
            Log.d((String)MapboxFusedLocationEngineImpl.TAG, (String)((StringBuilder)object).toString());
        }
    }
}

