/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.mapbox.android.core.permissions.PermissionsListener;
import java.util.ArrayList;
import java.util.Arrays;

public class PermissionsManager {
    private static final String BACKGROUND_LOCATION_PERMISSION = "android.permission.ACCESS_BACKGROUND_LOCATION";
    private static final String COARSE_LOCATION_PERMISSION = "android.permission.ACCESS_COARSE_LOCATION";
    private static final String FINE_LOCATION_PERMISSION = "android.permission.ACCESS_FINE_LOCATION";
    private static final String LOG_TAG = "PermissionsManager";
    private final int REQUEST_PERMISSIONS_CODE;
    private PermissionsListener listener;

    public PermissionsManager(PermissionsListener permissionsListener) {
        this.REQUEST_PERMISSIONS_CODE = 0;
        this.listener = permissionsListener;
    }

    public static AccuracyAuthorization accuracyAuthorization(Context context) {
        if (PermissionsManager.isFineLocationPermissionGranted(context)) {
            return AccuracyAuthorization.PRECISE;
        }
        if (PermissionsManager.isCoarseLocationPermissionGranted(context)) {
            return AccuracyAuthorization.APPROXIMATE;
        }
        return AccuracyAuthorization.NONE;
    }

    public static boolean areLocationPermissionsGranted(Context context) {
        boolean bl = PermissionsManager.isCoarseLocationPermissionGranted(context) || PermissionsManager.isFineLocationPermissionGranted(context);
        return bl;
    }

    public static boolean areRuntimePermissionsRequired() {
        boolean bl = Build.VERSION.SDK_INT >= 23;
        return bl;
    }

    public static boolean isBackgroundLocationPermissionGranted(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            return PermissionsManager.isPermissionGranted(context, BACKGROUND_LOCATION_PERMISSION);
        }
        return PermissionsManager.areLocationPermissionsGranted(context);
    }

    private static boolean isCoarseLocationPermissionGranted(Context context) {
        return PermissionsManager.isPermissionGranted(context, COARSE_LOCATION_PERMISSION);
    }

    private static boolean isFineLocationPermissionGranted(Context context) {
        return PermissionsManager.isPermissionGranted(context, FINE_LOCATION_PERMISSION);
    }

    private static boolean isPermissionGranted(Context context, String string2) {
        boolean bl = ContextCompat.checkSelfPermission((Context)context, (String)string2) == 0;
        return bl;
    }

    private void requestLocationPermissions(Activity activity, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add(FINE_LOCATION_PERMISSION);
        } else {
            arrayList.add(COARSE_LOCATION_PERMISSION);
        }
        if (Build.VERSION.SDK_INT >= 29 && bl2) {
            arrayList.add(BACKGROUND_LOCATION_PERMISSION);
        }
        this.requestPermissions(activity, arrayList.toArray(new String[arrayList.size()]));
    }

    private void requestPermissions(Activity activity, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)string2)) continue;
            arrayList.add(string2);
        }
        if (this.listener != null && arrayList.size() > 0) {
            this.listener.onExplanationNeeded(arrayList);
        }
        ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)0);
    }

    public PermissionsListener getListener() {
        return this.listener;
    }

    public void onRequestPermissionsResult(int n, String[] object, int[] nArray) {
        if (n == 0 && (object = this.listener) != null) {
            boolean bl;
            n = nArray.length;
            boolean bl2 = bl = false;
            if (n > 0) {
                bl2 = bl;
                if (nArray[0] == 0) {
                    bl2 = true;
                }
            }
            object.onPermissionResult(bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestLocationPermissions(Activity activity) {
        try {
            Object object = activity.getPackageManager().getPackageInfo((String)activity.getPackageName(), (int)4096).requestedPermissions;
            if (object == null) return;
            object = Arrays.asList(object);
            boolean bl = object.contains(FINE_LOCATION_PERMISSION);
            boolean bl2 = object.contains(COARSE_LOCATION_PERMISSION);
            boolean bl3 = object.contains(BACKGROUND_LOCATION_PERMISSION);
            if (bl) {
                this.requestLocationPermissions(activity, true, bl3);
                return;
            }
            if (bl2) {
                this.requestLocationPermissions(activity, false, bl3);
                return;
            }
            Log.w((String)LOG_TAG, (String)"Location permissions are missing");
            return;
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)exception.getMessage());
        }
    }

    public void setListener(PermissionsListener permissionsListener) {
        this.listener = permissionsListener;
    }

    public static final class AccuracyAuthorization
    extends Enum<AccuracyAuthorization> {
        private static final /* synthetic */ AccuracyAuthorization[] $VALUES;
        public static final /* enum */ AccuracyAuthorization APPROXIMATE;
        public static final /* enum */ AccuracyAuthorization NONE;
        public static final /* enum */ AccuracyAuthorization PRECISE;

        static {
            AccuracyAuthorization accuracyAuthorization;
            AccuracyAuthorization accuracyAuthorization2;
            AccuracyAuthorization accuracyAuthorization3;
            NONE = accuracyAuthorization3 = new AccuracyAuthorization();
            PRECISE = accuracyAuthorization2 = new AccuracyAuthorization();
            APPROXIMATE = accuracyAuthorization = new AccuracyAuthorization();
            $VALUES = new AccuracyAuthorization[]{accuracyAuthorization3, accuracyAuthorization2, accuracyAuthorization};
        }

        public static AccuracyAuthorization valueOf(String string2) {
            return Enum.valueOf(AccuracyAuthorization.class, string2);
        }

        public static AccuracyAuthorization[] values() {
            return (AccuracyAuthorization[])$VALUES.clone();
        }
    }
}

