/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import com.mapbox.android.gestures.BaseGesture;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.MultiFingerGesture;
import com.mapbox.android.gestures.MultiFingerTapGestureDetector;
import com.mapbox.android.gestures.R;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.android.gestures.ShoveGestureDetector;
import com.mapbox.android.gestures.SidewaysShoveGestureDetector;
import com.mapbox.android.gestures.StandardGestureDetector;
import com.mapbox.android.gestures.StandardScaleGestureDetector;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AndroidGesturesManager {
    public static final int GESTURE_TYPE_DOUBLE_TAP = 10;
    public static final int GESTURE_TYPE_DOUBLE_TAP_EVENT = 11;
    public static final int GESTURE_TYPE_DOWN = 9;
    public static final int GESTURE_TYPE_FLING = 7;
    public static final int GESTURE_TYPE_LONG_PRESS = 6;
    public static final int GESTURE_TYPE_MOVE = 13;
    public static final int GESTURE_TYPE_MULTI_FINGER_TAP = 4;
    public static final int GESTURE_TYPE_QUICK_SCALE = 15;
    public static final int GESTURE_TYPE_ROTATE = 2;
    public static final int GESTURE_TYPE_SCALE = 1;
    public static final int GESTURE_TYPE_SCROLL = 0;
    public static final int GESTURE_TYPE_SHOVE = 3;
    public static final int GESTURE_TYPE_SHOW_PRESS = 8;
    public static final int GESTURE_TYPE_SIDEWAYS_SHOVE = 14;
    public static final int GESTURE_TYPE_SINGLE_TAP_CONFIRMED = 12;
    public static final int GESTURE_TYPE_SINGLE_TAP_UP = 5;
    private final List<BaseGesture> detectors;
    private final MoveGestureDetector moveGestureDetector;
    private final MultiFingerTapGestureDetector multiFingerTapGestureDetector;
    private final List<Set<Integer>> mutuallyExclusiveGestures;
    private final RotateGestureDetector rotateGestureDetector;
    private final ShoveGestureDetector shoveGestureDetector;
    private final SidewaysShoveGestureDetector sidewaysShoveGestureDetector;
    private final StandardGestureDetector standardGestureDetector;
    private final StandardScaleGestureDetector standardScaleGestureDetector;

    public AndroidGesturesManager(Context context) {
        this(context, true);
    }

    public AndroidGesturesManager(Context object, List<Set<Integer>> object2, boolean bl) {
        MoveGestureDetector moveGestureDetector;
        MultiFingerTapGestureDetector multiFingerTapGestureDetector;
        SidewaysShoveGestureDetector sidewaysShoveGestureDetector;
        ShoveGestureDetector shoveGestureDetector;
        Object object3 = new ArrayList<Set<Integer>>();
        this.mutuallyExclusiveGestures = object3;
        ArrayList<BaseGesture> arrayList = new ArrayList<BaseGesture>();
        this.detectors = arrayList;
        object3.addAll(object2);
        this.rotateGestureDetector = object2 = new RotateGestureDetector((Context)object, this);
        this.standardScaleGestureDetector = object3 = new StandardScaleGestureDetector((Context)object, this);
        this.shoveGestureDetector = shoveGestureDetector = new ShoveGestureDetector((Context)object, this);
        this.sidewaysShoveGestureDetector = sidewaysShoveGestureDetector = new SidewaysShoveGestureDetector((Context)object, this);
        this.multiFingerTapGestureDetector = multiFingerTapGestureDetector = new MultiFingerTapGestureDetector((Context)object, this);
        this.moveGestureDetector = moveGestureDetector = new MoveGestureDetector((Context)object, this);
        object = new StandardGestureDetector((Context)object, this);
        this.standardGestureDetector = object;
        arrayList.add((BaseGesture)object2);
        arrayList.add((BaseGesture)object3);
        arrayList.add(shoveGestureDetector);
        arrayList.add(sidewaysShoveGestureDetector);
        arrayList.add(multiFingerTapGestureDetector);
        arrayList.add(moveGestureDetector);
        arrayList.add((BaseGesture)object);
        if (bl) {
            this.initDefaultThresholds();
        }
    }

    public AndroidGesturesManager(Context context, boolean bl) {
        this(context, new ArrayList<Set<Integer>>(), bl);
    }

    @SafeVarargs
    public AndroidGesturesManager(Context context, Set<Integer> ... setArray) {
        this(context, Arrays.asList(setArray), true);
    }

    private void initDefaultThresholds() {
        for (BaseGesture baseGesture : this.detectors) {
            MultiFingerGesture multiFingerGesture;
            if (baseGesture instanceof MultiFingerGesture) {
                if (Build.VERSION.SDK_INT < 24) {
                    ((MultiFingerGesture)baseGesture).setSpanThresholdResource(R.dimen.mapbox_internalMinSpan23);
                } else {
                    ((MultiFingerGesture)baseGesture).setSpanThresholdResource(R.dimen.mapbox_internalMinSpan24);
                }
            }
            if (baseGesture instanceof StandardScaleGestureDetector) {
                ((StandardScaleGestureDetector)baseGesture).setSpanSinceStartThresholdResource(R.dimen.mapbox_defaultScaleSpanSinceStartThreshold);
            }
            if (baseGesture instanceof ShoveGestureDetector) {
                multiFingerGesture = (ShoveGestureDetector)baseGesture;
                ((ShoveGestureDetector)multiFingerGesture).setPixelDeltaThresholdResource(R.dimen.mapbox_defaultShovePixelThreshold);
                ((ShoveGestureDetector)multiFingerGesture).setMaxShoveAngle(20.0f);
            }
            if (baseGesture instanceof SidewaysShoveGestureDetector) {
                multiFingerGesture = (SidewaysShoveGestureDetector)baseGesture;
                ((SidewaysShoveGestureDetector)multiFingerGesture).setPixelDeltaThresholdResource(R.dimen.mapbox_defaultShovePixelThreshold);
                ((SidewaysShoveGestureDetector)multiFingerGesture).setMaxShoveAngle(20.0f);
            }
            if (baseGesture instanceof MultiFingerTapGestureDetector) {
                multiFingerGesture = (MultiFingerTapGestureDetector)baseGesture;
                ((MultiFingerTapGestureDetector)multiFingerGesture).setMultiFingerTapMovementThresholdResource(R.dimen.mapbox_defaultMultiTapMovementThreshold);
                ((MultiFingerTapGestureDetector)multiFingerGesture).setMultiFingerTapTimeThreshold(150L);
            }
            if (!(baseGesture instanceof RotateGestureDetector)) continue;
            ((RotateGestureDetector)baseGesture).setAngleThreshold(15.3f);
        }
    }

    public List<BaseGesture> getDetectors() {
        return this.detectors;
    }

    public MoveGestureDetector getMoveGestureDetector() {
        return this.moveGestureDetector;
    }

    public MultiFingerTapGestureDetector getMultiFingerTapGestureDetector() {
        return this.multiFingerTapGestureDetector;
    }

    public List<Set<Integer>> getMutuallyExclusiveGestures() {
        return this.mutuallyExclusiveGestures;
    }

    public RotateGestureDetector getRotateGestureDetector() {
        return this.rotateGestureDetector;
    }

    public ShoveGestureDetector getShoveGestureDetector() {
        return this.shoveGestureDetector;
    }

    public SidewaysShoveGestureDetector getSidewaysShoveGestureDetector() {
        return this.sidewaysShoveGestureDetector;
    }

    public StandardGestureDetector getStandardGestureDetector() {
        return this.standardGestureDetector;
    }

    public StandardScaleGestureDetector getStandardScaleGestureDetector() {
        return this.standardScaleGestureDetector;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        Iterator<BaseGesture> iterator2 = this.detectors.iterator();
        boolean bl = false;
        while (iterator2.hasNext()) {
            if (!iterator2.next().onTouchEvent(motionEvent)) continue;
            bl = true;
        }
        return bl;
    }

    public void removeMoveGestureListener() {
        this.moveGestureDetector.removeListener();
    }

    public void removeMultiFingerTapGestureListener() {
        this.multiFingerTapGestureDetector.removeListener();
    }

    public void removeRotateGestureListener() {
        this.rotateGestureDetector.removeListener();
    }

    public void removeShoveGestureListener() {
        this.shoveGestureDetector.removeListener();
    }

    public void removeSidewaysShoveGestureListener() {
        this.sidewaysShoveGestureDetector.removeListener();
    }

    public void removeStandardGestureListener() {
        this.standardGestureDetector.removeListener();
    }

    public void removeStandardScaleGestureListener() {
        this.standardScaleGestureDetector.removeListener();
    }

    public void setMoveGestureListener(MoveGestureDetector.OnMoveGestureListener onMoveGestureListener) {
        this.moveGestureDetector.setListener(onMoveGestureListener);
    }

    public void setMultiFingerTapGestureListener(MultiFingerTapGestureDetector.OnMultiFingerTapGestureListener onMultiFingerTapGestureListener) {
        this.multiFingerTapGestureDetector.setListener(onMultiFingerTapGestureListener);
    }

    public void setMutuallyExclusiveGestures(List<Set<Integer>> list) {
        this.mutuallyExclusiveGestures.clear();
        this.mutuallyExclusiveGestures.addAll(list);
    }

    @SafeVarargs
    public final void setMutuallyExclusiveGestures(Set<Integer> ... setArray) {
        this.setMutuallyExclusiveGestures(Arrays.asList(setArray));
    }

    public void setRotateGestureListener(RotateGestureDetector.OnRotateGestureListener onRotateGestureListener) {
        this.rotateGestureDetector.setListener(onRotateGestureListener);
    }

    public void setShoveGestureListener(ShoveGestureDetector.OnShoveGestureListener onShoveGestureListener) {
        this.shoveGestureDetector.setListener(onShoveGestureListener);
    }

    public void setSidewaysShoveGestureListener(SidewaysShoveGestureDetector.OnSidewaysShoveGestureListener onSidewaysShoveGestureListener) {
        this.sidewaysShoveGestureDetector.setListener(onSidewaysShoveGestureListener);
    }

    public void setStandardGestureListener(StandardGestureDetector.StandardOnGestureListener standardOnGestureListener) {
        this.standardGestureDetector.setListener(standardOnGestureListener);
    }

    public void setStandardScaleGestureListener(StandardScaleGestureDetector.StandardOnScaleGestureListener standardOnScaleGestureListener) {
        this.standardScaleGestureDetector.setListener(standardOnScaleGestureListener);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GestureType {
    }
}

