/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.view.MotionEvent;
import android.view.WindowManager;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.Set;

public abstract class BaseGesture<L> {
    protected final Context context;
    private MotionEvent currentEvent;
    private long gestureDuration;
    private final AndroidGesturesManager gesturesManager;
    private boolean isEnabled = true;
    protected L listener;
    private MotionEvent previousEvent;
    protected final WindowManager windowManager;

    public BaseGesture(Context context, AndroidGesturesManager androidGesturesManager) {
        this.context = context;
        this.windowManager = (WindowManager)context.getSystemService("window");
        this.gesturesManager = androidGesturesManager;
    }

    private boolean analyze(MotionEvent motionEvent) {
        if (motionEvent == null) {
            return false;
        }
        MotionEvent motionEvent2 = this.previousEvent;
        if (motionEvent2 != null) {
            motionEvent2.recycle();
            this.previousEvent = null;
        }
        if ((motionEvent2 = this.currentEvent) != null) {
            this.previousEvent = MotionEvent.obtain((MotionEvent)motionEvent2);
            this.currentEvent.recycle();
            this.currentEvent = null;
        }
        this.currentEvent = motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
        this.gestureDuration = motionEvent2.getEventTime() - this.currentEvent.getDownTime();
        return this.analyzeEvent(motionEvent);
    }

    protected abstract boolean analyzeEvent(MotionEvent var1);

    protected boolean canExecute(int n) {
        if (this.listener != null && this.isEnabled) {
            for (Set<Integer> set : this.gesturesManager.getMutuallyExclusiveGestures()) {
                if (!set.contains(n)) continue;
                set = set.iterator();
                while (set.hasNext()) {
                    int n2 = (Integer)set.next();
                    for (BaseGesture baseGesture : this.gesturesManager.getDetectors()) {
                        if (!(baseGesture instanceof ProgressiveGesture) || !((ProgressiveGesture)(baseGesture = (ProgressiveGesture)baseGesture)).getHandledTypes().contains(n2) || !((ProgressiveGesture)baseGesture).isInProgress()) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public MotionEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public long getGestureDuration() {
        return this.gestureDuration;
    }

    public MotionEvent getPreviousEvent() {
        return this.previousEvent;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    protected boolean onTouchEvent(MotionEvent motionEvent) {
        return this.analyze(motionEvent);
    }

    protected void removeListener() {
        this.listener = null;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    protected void setListener(L l) {
        this.listener = l;
    }
}

