/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.MotionEvent;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MoveGestureDetector
extends ProgressiveGesture<OnMoveGestureListener> {
    private static final int MOVE_REQUIRED_POINTERS_COUNT = 1;
    private static final Set<Integer> handledTypes;
    float lastDistanceX;
    float lastDistanceY;
    private final Map<Integer, MoveDistancesObject> moveDistancesObjectMap = new HashMap<Integer, MoveDistancesObject>();
    private float moveThreshold;
    private RectF moveThresholdRect;
    private PointF previousFocalPoint;
    private boolean resetFocal;

    static {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        handledTypes = hashSet;
        hashSet.add(13);
    }

    public MoveGestureDetector(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
    }

    private void updateMoveDistancesObjects() {
        Iterator iterator2 = this.pointerIdList.iterator();
        while (iterator2.hasNext()) {
            int n = (Integer)iterator2.next();
            this.moveDistancesObjectMap.get(n).addNewPosition(this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(n)), this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(n)));
        }
    }

    @Override
    protected boolean analyzeEvent(MotionEvent motionEvent) {
        block4: {
            block1: {
                block2: {
                    block3: {
                        int n = motionEvent.getActionMasked();
                        if (n == 0) break block1;
                        if (n == 1) break block2;
                        if (n == 3) break block3;
                        if (n == 5) break block1;
                        if (n == 6) {
                            this.resetFocal = true;
                            this.moveDistancesObjectMap.remove(motionEvent.getPointerId(motionEvent.getActionIndex()));
                        }
                        break block4;
                    }
                    this.moveDistancesObjectMap.clear();
                    break block4;
                }
                this.moveDistancesObjectMap.clear();
                break block4;
            }
            this.resetFocal = true;
            float f = motionEvent.getX(motionEvent.getActionIndex());
            float f2 = motionEvent.getY(motionEvent.getActionIndex());
            this.moveDistancesObjectMap.put(motionEvent.getPointerId(motionEvent.getActionIndex()), new MoveDistancesObject(f, f2));
        }
        return super.analyzeEvent(motionEvent);
    }

    @Override
    protected boolean analyzeMovement() {
        super.analyzeMovement();
        this.updateMoveDistancesObjects();
        if (this.isInProgress()) {
            PointF pointF = this.getFocalPoint();
            this.lastDistanceX = this.previousFocalPoint.x - pointF.x;
            this.lastDistanceY = this.previousFocalPoint.y - pointF.y;
            this.previousFocalPoint = pointF;
            if (this.resetFocal) {
                this.resetFocal = false;
                return ((OnMoveGestureListener)this.listener).onMove(this, 0.0f, 0.0f);
            }
            return ((OnMoveGestureListener)this.listener).onMove(this, this.lastDistanceX, this.lastDistanceY);
        }
        if (this.canExecute(13) && ((OnMoveGestureListener)this.listener).onMoveBegin(this)) {
            this.gestureStarted();
            this.previousFocalPoint = this.getFocalPoint();
            this.resetFocal = false;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExecute(int n) {
        boolean bl = super.canExecute(n) && this.checkAnyMoveAboveThreshold();
        return bl;
    }

    boolean checkAnyMoveAboveThreshold() {
        boolean bl;
        Object object = this.moveDistancesObjectMap.values().iterator();
        boolean bl2 = object.hasNext();
        boolean bl3 = bl = false;
        if (bl2) {
            boolean bl4 = Math.abs(((MoveDistancesObject)(object = object.next())).getDistanceXSinceStart()) >= this.moveThreshold || Math.abs(((MoveDistancesObject)object).getDistanceYSinceStart()) >= this.moveThreshold;
            object = this.moveThresholdRect;
            boolean bl5 = object != null && object.contains(this.getFocalPoint().x, this.getFocalPoint().y);
            bl3 = bl;
            if (!bl5) {
                bl3 = bl;
                if (bl4) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        ((OnMoveGestureListener)this.listener).onMoveEnd(this, this.velocityX, this.velocityY);
    }

    public float getLastDistanceX() {
        return this.lastDistanceX;
    }

    public float getLastDistanceY() {
        return this.lastDistanceY;
    }

    public MoveDistancesObject getMoveObject(int n) {
        if (this.isInProgress() && n >= 0 && n < this.getPointersCount()) {
            return this.moveDistancesObjectMap.get(this.pointerIdList.get(n));
        }
        return null;
    }

    public float getMoveThreshold() {
        return this.moveThreshold;
    }

    public RectF getMoveThresholdRect() {
        return this.moveThresholdRect;
    }

    @Override
    protected int getRequiredPointersCount() {
        return 1;
    }

    @Override
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    @Override
    protected void reset() {
        super.reset();
    }

    public void setMoveThreshold(float f) {
        this.moveThreshold = f;
    }

    public void setMoveThresholdRect(RectF rectF) {
        this.moveThresholdRect = rectF;
    }

    public void setMoveThresholdResource(int n) {
        this.setMoveThreshold(this.context.getResources().getDimension(n));
    }

    public static interface OnMoveGestureListener {
        public boolean onMove(MoveGestureDetector var1, float var2, float var3);

        public boolean onMoveBegin(MoveGestureDetector var1);

        public void onMoveEnd(MoveGestureDetector var1, float var2, float var3);
    }

    public static class SimpleOnMoveGestureListener
    implements OnMoveGestureListener {
        @Override
        public boolean onMove(MoveGestureDetector moveGestureDetector, float f, float f2) {
            return false;
        }

        @Override
        public boolean onMoveBegin(MoveGestureDetector moveGestureDetector) {
            return true;
        }

        @Override
        public void onMoveEnd(MoveGestureDetector moveGestureDetector, float f, float f2) {
        }
    }
}

