/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.PointerDistancePair;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ShoveGestureDetector
extends ProgressiveGesture<OnShoveGestureListener> {
    private static final Set<Integer> handledTypes;
    float deltaPixelSinceLast;
    float deltaPixelsSinceStart;
    private float maxShoveAngle;
    private float pixelDeltaThreshold;

    static {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        handledTypes = hashSet;
        hashSet.add(3);
    }

    public ShoveGestureDetector(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
    }

    @Override
    protected boolean analyzeMovement() {
        float f;
        super.analyzeMovement();
        this.deltaPixelSinceLast = f = this.calculateDeltaPixelsSinceLast();
        this.deltaPixelsSinceStart += f;
        if (this.isInProgress() && this.deltaPixelSinceLast != 0.0f) {
            return ((OnShoveGestureListener)this.listener).onShove(this, this.deltaPixelSinceLast, this.deltaPixelsSinceStart);
        }
        if (this.canExecute(3) && ((OnShoveGestureListener)this.listener).onShoveBegin(this)) {
            this.gestureStarted();
            return true;
        }
        return false;
    }

    float calculateDeltaPixelsSinceLast() {
        float f = (this.getPreviousEvent().getY(this.getPreviousEvent().findPointerIndex(((Integer)this.pointerIdList.get(0)).intValue())) + this.getPreviousEvent().getY(this.getPreviousEvent().findPointerIndex(((Integer)this.pointerIdList.get(1)).intValue()))) / 2.0f;
        return (this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(((Integer)this.pointerIdList.get(0)).intValue())) + this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(((Integer)this.pointerIdList.get(1)).intValue()))) / 2.0f - f;
    }

    @Override
    protected boolean canExecute(int n) {
        boolean bl = Math.abs(this.deltaPixelsSinceStart) >= this.pixelDeltaThreshold && super.canExecute(n);
        return bl;
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        ((OnShoveGestureListener)this.listener).onShoveEnd(this, this.velocityX, this.velocityY);
    }

    public float getDeltaPixelSinceLast() {
        return this.deltaPixelSinceLast;
    }

    public float getDeltaPixelsSinceStart() {
        return this.deltaPixelsSinceStart;
    }

    public float getMaxShoveAngle() {
        return this.maxShoveAngle;
    }

    public float getPixelDeltaThreshold() {
        return this.pixelDeltaThreshold;
    }

    boolean isAngleAcceptable() {
        float f;
        Object object = this.pointersDistanceMap;
        List list = this.pointerIdList;
        boolean bl = false;
        double d = Math.toDegrees(Math.abs(Math.atan2(((MultiFingerDistancesObject)(object = (MultiFingerDistancesObject)((HashMap)object).get((Object)new PointerDistancePair((Integer)list.get(0), (Integer)this.pointerIdList.get(1))))).getCurrFingersDiffY(), ((MultiFingerDistancesObject)object).getCurrFingersDiffX())));
        if (d <= (double)(f = this.maxShoveAngle) || 180.0 - d <= (double)f) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected boolean isSloppyGesture() {
        boolean bl = super.isSloppyGesture() || !this.isAngleAcceptable();
        return bl;
    }

    @Override
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    @Override
    protected void reset() {
        super.reset();
        this.deltaPixelsSinceStart = 0.0f;
    }

    public void setMaxShoveAngle(float f) {
        this.maxShoveAngle = f;
    }

    public void setPixelDeltaThreshold(float f) {
        this.pixelDeltaThreshold = f;
    }

    public void setPixelDeltaThresholdResource(int n) {
        this.setPixelDeltaThreshold(this.context.getResources().getDimension(n));
    }

    public static interface OnShoveGestureListener {
        public boolean onShove(ShoveGestureDetector var1, float var2, float var3);

        public boolean onShoveBegin(ShoveGestureDetector var1);

        public void onShoveEnd(ShoveGestureDetector var1, float var2, float var3);
    }

    public static class SimpleOnShoveGestureListener
    implements OnShoveGestureListener {
        @Override
        public boolean onShove(ShoveGestureDetector shoveGestureDetector, float f, float f2) {
            return false;
        }

        @Override
        public boolean onShoveBegin(ShoveGestureDetector shoveGestureDetector) {
            return true;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector shoveGestureDetector, float f, float f2) {
        }
    }
}

