/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import com.mapbox.android.telemetry.LogUtils;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class AppStateUtils {
    public static String KEY_LAST_KNOWN_ACTIVITY_STATE = "mb_telemetry_last_know_activity_state";
    public static String PREFERENCE_FILENAME = "mb_app_state_utils";
    private static final String TAG = "AppStateUtils";
    private static final ScheduledThreadPoolExecutor ioExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);

    private static AppState arbitrage(AppState appState, ActivityState activityState) {
        Object object = new StringBuilder();
        object.append("stateFromActivityManager = ");
        object.append((Object)appState);
        object.append(", lastKnowActivityState = ");
        object.append((Object)activityState);
        LogUtils.v(TAG, object.toString(), new Object[0]);
        object = appState;
        if (appState == AppState.FOREGROUND) {
            object = appState;
            if (AppStateUtils.isActivityInactive(activityState)) {
                object = AppState.BACKGROUND;
            }
        }
        return object;
    }

    public static void getAppState(final Context context, final GetAppStateCallback getAppStateCallback) {
        ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                LogUtils.v(AppStateUtils.TAG, "Getting app state...", new Object[0]);
                AppState appState = AppStateUtils.arbitrage(AppStateUtils.getAppStateFromActivityManager(context), AppStateUtils.getLastKnownActivityState(context));
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("getAppState() returns ");
                stringBuilder.append((Object)appState);
                LogUtils.v(AppStateUtils.TAG, stringBuilder.toString(), new Object[0]);
                getAppStateCallback.onReady(appState);
            }
        });
    }

    private static AppState getAppStateFromActivityManager(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            return AppStateUtils.getAppStateQAndHigher(context);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return AppStateUtils.getAppStateLollipopAndHigher(context);
        }
        return AppStateUtils.getAppStatePreLollipop(context);
    }

    private static AppState getAppStateLollipopAndHigher(Context object) {
        Object object2 = (ActivityManager)object.getSystemService("activity");
        if (object2 == null) {
            return AppState.UNKNOWN;
        }
        object = AppState.BACKGROUND;
        object2 = object2.getAppTasks().iterator();
        while (object2.hasNext()) {
            if (((ActivityManager.AppTask)object2.next()).getTaskInfo().id == -1) continue;
            object = AppState.FOREGROUND;
        }
        return object;
    }

    private static AppState getAppStatePreLollipop(Context object) {
        Object object2 = (ActivityManager)object.getSystemService("activity");
        if (object2 == null) {
            return AppState.UNKNOWN;
        }
        Object object3 = object.getApplicationContext().getPackageName();
        object = AppState.UNKNOWN;
        object2 = object2.getRunningTasks(32);
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            ActivityManager.RunningTaskInfo runningTaskInfo = (ActivityManager.RunningTaskInfo)iterator2.next();
            if (runningTaskInfo.topActivity == null || !runningTaskInfo.topActivity.getPackageName().equals(object3)) continue;
            object = AppState.FOREGROUND;
        }
        object3 = object;
        if (object2.size() < 32) {
            object3 = object;
            if (object == AppState.UNKNOWN) {
                object3 = AppState.BACKGROUND;
            }
        }
        return object3;
    }

    private static AppState getAppStateQAndHigher(Context object) {
        Object object2 = (ActivityManager)object.getSystemService("activity");
        if (object2 == null) {
            return AppState.UNKNOWN;
        }
        object = AppState.BACKGROUND;
        object2 = object2.getAppTasks().iterator();
        while (object2.hasNext()) {
            if (!((ActivityManager.AppTask)object2.next()).getTaskInfo().isRunning) continue;
            object = AppState.FOREGROUND;
        }
        return object;
    }

    public static ActivityState getLastKnownActivityState(Context context) {
        return ActivityState.fromCode(context.getSharedPreferences(PREFERENCE_FILENAME, 0).getInt(KEY_LAST_KNOWN_ACTIVITY_STATE, ActivityState.ACTIVITY_STATE_UNKNOWN.getCode()));
    }

    private static boolean isActivityInactive(ActivityState activityState) {
        int n = 3.$SwitchMap$com$mapbox$android$telemetry$AppStateUtils$ActivityState[activityState.ordinal()];
        return n == 1 || n == 2 || n == 3 || n == 4;
    }

    public static void saveActivityState(final Context context, final ActivityState activityState) {
        ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                context.getSharedPreferences(PREFERENCE_FILENAME, 0).edit().putInt(KEY_LAST_KNOWN_ACTIVITY_STATE, activityState.getCode()).commit();
            }
        });
    }

    public static final class ActivityState
    extends Enum<ActivityState> {
        private static final /* synthetic */ ActivityState[] $VALUES;
        public static final /* enum */ ActivityState ACTIVITY_STATE_CREATED;
        public static final /* enum */ ActivityState ACTIVITY_STATE_DESTROYED;
        public static final /* enum */ ActivityState ACTIVITY_STATE_PAUSED;
        public static final /* enum */ ActivityState ACTIVITY_STATE_RESUMED;
        public static final /* enum */ ActivityState ACTIVITY_STATE_SAVE_INSTANCE_STATE;
        public static final /* enum */ ActivityState ACTIVITY_STATE_STARTED;
        public static final /* enum */ ActivityState ACTIVITY_STATE_STOPPED;
        public static final /* enum */ ActivityState ACTIVITY_STATE_UNKNOWN;
        private final int code;

        static {
            ActivityState activityState;
            ActivityState activityState2;
            ActivityState activityState3;
            ActivityState activityState4;
            ActivityState activityState5;
            ActivityState activityState6;
            ActivityState activityState7;
            ActivityState activityState8;
            ACTIVITY_STATE_UNKNOWN = activityState8 = new ActivityState(0);
            ACTIVITY_STATE_CREATED = activityState7 = new ActivityState(1);
            ACTIVITY_STATE_STARTED = activityState6 = new ActivityState(2);
            ACTIVITY_STATE_RESUMED = activityState5 = new ActivityState(3);
            ACTIVITY_STATE_PAUSED = activityState4 = new ActivityState(4);
            ACTIVITY_STATE_STOPPED = activityState3 = new ActivityState(5);
            ACTIVITY_STATE_SAVE_INSTANCE_STATE = activityState2 = new ActivityState(6);
            ACTIVITY_STATE_DESTROYED = activityState = new ActivityState(7);
            $VALUES = new ActivityState[]{activityState8, activityState7, activityState6, activityState5, activityState4, activityState3, activityState2, activityState};
        }

        private ActivityState(int n2) {
            this.code = n2;
        }

        static ActivityState fromCode(int n) {
            switch (n) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unknown activity status code: ");
                    stringBuilder.append(n);
                    LogUtils.e(AppStateUtils.TAG, stringBuilder.toString(), new Object[0]);
                    return ACTIVITY_STATE_UNKNOWN;
                }
                case 7: {
                    return ACTIVITY_STATE_DESTROYED;
                }
                case 6: {
                    return ACTIVITY_STATE_SAVE_INSTANCE_STATE;
                }
                case 5: {
                    return ACTIVITY_STATE_STOPPED;
                }
                case 4: {
                    return ACTIVITY_STATE_PAUSED;
                }
                case 3: {
                    return ACTIVITY_STATE_RESUMED;
                }
                case 2: {
                    return ACTIVITY_STATE_STARTED;
                }
                case 1: {
                    return ACTIVITY_STATE_CREATED;
                }
                case 0: 
            }
            return ACTIVITY_STATE_UNKNOWN;
        }

        public static ActivityState valueOf(String string2) {
            return Enum.valueOf(ActivityState.class, string2);
        }

        public static ActivityState[] values() {
            return (ActivityState[])$VALUES.clone();
        }

        public int getCode() {
            return this.code;
        }
    }

    public static final class AppState
    extends Enum<AppState> {
        private static final /* synthetic */ AppState[] $VALUES;
        public static final /* enum */ AppState BACKGROUND;
        public static final /* enum */ AppState FOREGROUND;
        public static final /* enum */ AppState UNKNOWN;

        static {
            AppState appState;
            AppState appState2;
            AppState appState3;
            UNKNOWN = appState3 = new AppState();
            FOREGROUND = appState2 = new AppState();
            BACKGROUND = appState = new AppState();
            $VALUES = new AppState[]{appState3, appState2, appState};
        }

        public static AppState valueOf(String string2) {
            return Enum.valueOf(AppState.class, string2);
        }

        public static AppState[] values() {
            return (AppState[])$VALUES.clone();
        }

        public String toString() {
            int n = 3.$SwitchMap$com$mapbox$android$telemetry$AppStateUtils$AppState[this.ordinal()];
            if (n != 1) {
                if (n != 2) {
                    return "Unknown";
                }
                return "Background";
            }
            return "Foreground";
        }
    }

    public static interface GetAppStateCallback {
        public void onReady(AppState var1);
    }
}

