/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.mapbox.android.telemetry.ConfigurationChangeHandler;
import com.mapbox.android.telemetry.ConfigurationClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class CertificateBlacklist
implements ConfigurationChangeHandler {
    private static final String BLACKLIST_FILE = "MapboxBlacklist";
    private static final String LOG_TAG = "MapboxBlacklist";
    private final Context context;
    private final List<String> revokedKeys;

    CertificateBlacklist(Context context, ConfigurationClient configurationClient) {
        this.context = context;
        this.revokedKeys = new CopyOnWriteArrayList<String>();
        configurationClient.addHandler(this);
        if (configurationClient.shouldUpdate()) {
            configurationClient.update();
        } else {
            this.retrieveBlackList(context.getFilesDir(), false);
        }
    }

    private static boolean isValidContent(String object) {
        boolean bl;
        block4: {
            bl = TextUtils.isEmpty((CharSequence)object);
            boolean bl2 = false;
            if (bl) {
                return false;
            }
            Gson gson = new GsonBuilder().create();
            try {
                object = gson.fromJson((String)object, JsonObject.class).get("RevokedCertKeys");
                object = ((JsonElement)object).isJsonArray() ? gson.fromJson((JsonElement)object, JsonArray.class) : null;
                bl = bl2;
                if (object == null) break block4;
                bl = bl2;
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                Log.e((String)"MapboxBlacklist", (String)jsonSyntaxException.getMessage());
                return false;
            }
            if (((JsonArray)object).size() > 0) {
                bl = true;
            }
        }
        return bl;
    }

    private List<String> obtainBlacklistContents(File list) throws IOException {
        BufferedReader bufferedReader;
        block5: {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)((Object)list))));
            Gson gson = new Gson();
            Object var4_6 = null;
            TypeToken<List<String>> typeToken = gson.fromJson((Reader)bufferedReader, JsonObject.class);
            list = var4_6;
            if (typeToken == null) break block5;
            try {
                list = ((JsonObject)((Object)typeToken)).getAsJsonArray("RevokedCertKeys");
                typeToken = new TypeToken<List<String>>(){};
                typeToken = typeToken.getType();
                list = (List)gson.fromJson(((JsonElement)((Object)list)).toString(), (Type)((Object)typeToken));
                break block5;
            }
            catch (JsonSyntaxException jsonSyntaxException) {
            }
            catch (JsonIOException jsonIOException) {
                // empty catch block
            }
            Log.e((String)"MapboxBlacklist", (String)((Throwable)((Object)list)).getMessage());
            list = var4_6;
        }
        bufferedReader.close();
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void retrieveBlackList(File list, boolean bl) {
        if (!((File)((Object)list)).isDirectory()) {
            return;
        }
        if (!((File)((Object)(list = new File((File)((Object)list), "MapboxBlacklist")))).exists()) return;
        try {
            list = this.obtainBlacklistContents((File)((Object)list));
            if (list.isEmpty()) {
                return;
            }
            if (bl) {
                this.revokedKeys.clear();
            }
            this.revokedKeys.addAll(list);
            return;
        }
        catch (IOException iOException) {
            Log.e((String)"MapboxBlacklist", (String)iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveBlackList(String string2) {
        Throwable throwable2222222;
        FileOutputStream fileOutputStream;
        block10: {
            FileOutputStream fileOutputStream2;
            boolean bl = CertificateBlacklist.isValidContent(string2);
            boolean bl2 = false;
            if (!bl) {
                return false;
            }
            FileOutputStream fileOutputStream3 = null;
            fileOutputStream = null;
            fileOutputStream = fileOutputStream2 = this.context.openFileOutput("MapboxBlacklist", 0);
            fileOutputStream3 = fileOutputStream2;
            fileOutputStream2.write(string2.getBytes());
            if (fileOutputStream2 == null) return true;
            {
                catch (Throwable throwable2222222) {
                    break block10;
                }
                catch (IOException iOException) {}
                fileOutputStream = fileOutputStream3;
                {
                    Log.e((String)"MapboxBlacklist", (String)iOException.getMessage());
                    bl = bl2;
                    if (fileOutputStream3 == null) return bl;
                }
                try {}
                catch (IOException iOException) {
                    Log.e((String)"MapboxBlacklist", (String)iOException.getMessage());
                    return bl2;
                }
                fileOutputStream3.close();
                return bl2;
            }
            {
                fileOutputStream2.close();
            }
            return true;
        }
        if (fileOutputStream == null) throw throwable2222222;
        try {
            fileOutputStream.close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            Log.e((String)"MapboxBlacklist", (String)iOException.getMessage());
        }
        throw throwable2222222;
    }

    boolean isBlacklisted(String string2) {
        return this.revokedKeys.contains(string2);
    }

    @Override
    public void onUpdate(String string2) {
        if (this.saveBlackList(string2)) {
            this.retrieveBlackList(this.context.getFilesDir(), true);
        }
    }
}

