/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.ChinaCertificatePins;
import com.mapbox.android.telemetry.ComCertificatePins;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.StagingCertificatePins;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.CertificatePinner;

class CertificatePinnerFactory {
    private static final Map<Environment, Map<String, List<String>>> CERTIFICATES_PINS = new HashMap<Environment, Map<String, List<String>>>(){
        {
            this.put(Environment.STAGING, StagingCertificatePins.CERTIFICATE_PINS);
            this.put(Environment.COM, ComCertificatePins.CERTIFICATE_PINS);
            this.put(Environment.CHINA, ChinaCertificatePins.CERTIFICATE_PINS);
        }
    };
    private static final String SHA256_PIN_FORMAT = "sha256/%s";

    CertificatePinnerFactory() {
    }

    private void addCertificatesPins(Map<String, List<String>> object, CertificatePinner.Builder builder) {
        for (Map.Entry entry : object.entrySet()) {
            for (String string2 : (List)entry.getValue()) {
                builder.add((String)entry.getKey(), new String[]{String.format(SHA256_PIN_FORMAT, string2)});
            }
        }
    }

    private List<String> removeBlacklistedHashes(CertificateBlacklist certificateBlacklist, List<String> list) {
        for (String string2 : list) {
            if (!certificateBlacklist.isBlacklisted(string2)) continue;
            list.remove(string2);
        }
        return list;
    }

    private Map<String, List<String>> removeBlacklistedPins(Map<String, List<String>> map, CertificateBlacklist certificateBlacklist) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> list = entry.getValue();
            if (list == null) continue;
            list = this.removeBlacklistedHashes(certificateBlacklist, list);
            map.put(entry.getKey(), list);
        }
        return map;
    }

    CertificatePinner provideCertificatePinnerFor(Environment environment, CertificateBlacklist certificateBlacklist) {
        CertificatePinner.Builder builder = new CertificatePinner.Builder();
        this.addCertificatesPins(this.removeBlacklistedPins(this.provideCertificatesPinsFor(environment), certificateBlacklist), builder);
        return builder.build();
    }

    Map<String, List<String>> provideCertificatesPinsFor(Environment environment) {
        return CERTIFICATES_PINS.get((Object)environment);
    }
}

